#include "../../gui/kpmainwindow.h"
#include "../../kipina-i18n.h"
#include "../../kpplugin.h"

#include "exercisereader.h"

GtkWidget *menu_item;

static void
import_item_activated (GtkMenuItem *item, KPPlugin *plugin)
{
  gchar *exercises_file;
  gchar *sport_file;
  
  kp_debug ("Exercise reader init.");

  exercises_file = g_strdup_printf ("%s/.sportstracker/exercises.xml", g_get_home_dir ());
  sport_file = g_strdup_printf ("%s/.sportstracker/sport-types.xml", g_get_home_dir ());
 
  exercise_reader_init (exercises_file, sport_file);
  
  g_free (exercises_file);
  g_free (sport_file);
  
  exercise_reader_read_data ();
  exercise_reader_deinit ();
}



static gboolean
plugin_load(KPPlugin *plugin)
{
  menu_item = gtk_menu_item_new_with_label ("SportsTracker data");
  kp_main_window_add_to_import_menu (GTK_MENU_ITEM (menu_item));

  gtk_widget_show (menu_item);

  g_signal_connect (G_OBJECT (menu_item), "activate",
                    G_CALLBACK (import_item_activated), plugin);
  
  return TRUE;
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "sportstracker-import-tura",                      /**< id             */
  N_("SportsTracker Import plugin"),                /**< name           */
  VERSION,                                          /**< version        */
  N_("Import SportsTracker exercise data"),
  N_("..."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  NULL,
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}

KP_PLUGIN_INIT("SportsTracker-import", init_plugin, info)

