#include <string.h>
#include <glib.h>
#include <glib-object.h>

#include "kpcalendarentry.h"
#include "kpworkoutmodel.h"
#include "kppresetworkout.h"
#include "kipina-i18n.h"
#include "kpworkout.h"

/* GObject stuff */
static void       kp_preset_workout_class_init        (GObjectClass *klass,
                                                       gpointer data);
static void       kp_workout_model_init               (KPWorkoutModelIface *iface);
static void       kp_preset_workout_instance_init     (GObject *object,
                                                       gpointer data);
static void       kp_preset_workout_instance_finalize (GObject *object);

static guint      kp_preset_workout_get_duration      (KPWorkoutModel *wo);
static gdouble    kp_preset_workout_get_distance      (KPWorkoutModel *wo);
static gchar     *kp_preset_workout_get_human_name    (KPCalendarEntry *entry);

GType
kp_preset_workout_get_type ()
{
  static GType kp_preset_workout_type = 0;

  if (!kp_preset_workout_type) {
    static const GTypeInfo kp_preset_workout_info = {
      sizeof (KPPresetWorkoutClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) kp_preset_workout_class_init,
      (GClassFinalizeFunc) NULL,
      NULL,
      sizeof (KPPresetWorkout),
      0,
      (GInstanceInitFunc) kp_preset_workout_instance_init,
      NULL
    };
    static const GInterfaceInfo workout_model_info = {
      (GInterfaceInitFunc) kp_workout_model_init,
       NULL,
       NULL
    };

    kp_preset_workout_type = g_type_register_static (KP_TYPE_WORKOUT,
                                                    "KPPresetWorkout",
                                                   &kp_preset_workout_info,
                                                    0);
    g_type_add_interface_static (kp_preset_workout_type,
                                 KP_TYPE_WORKOUT_MODEL,
                                &workout_model_info);
  }
  return kp_preset_workout_type;
}

static void
kp_preset_workout_class_init (GObjectClass *klass, gpointer data)
{
  KPCalendarEntryClass *entry_class;
  GObjectClass *object_class;

  entry_class = KP_CALENDAR_ENTRY_CLASS (klass);
  entry_class->get_human_name = kp_preset_workout_get_human_name;
  
  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_preset_workout_instance_finalize;
}

static void
kp_workout_model_init (KPWorkoutModelIface *iface)
{
  iface->get_duration = kp_preset_workout_get_duration;
  iface->get_distance = kp_preset_workout_get_distance;
}


static void
kp_preset_workout_instance_init (GObject *object, gpointer data)
{
  KPPresetWorkout *wo;

  wo = KP_PRESET_WORKOUT (object);
  wo->name = g_string_new (NULL);
}

static void
kp_preset_workout_instance_finalize (GObject *object)
{
  GObjectClass *parent_class;

  parent_class = g_type_class_peek_parent (G_OBJECT_GET_CLASS (object));
  parent_class->finalize (object);
}

/**
 * kp_preset_workout_new:
 * 
 * Create a new instance of #KPPresetWorkout.
 * 
 * Returns: A new #KPPresetWorkout.
 */
KPPresetWorkout *
kp_preset_workout_new ()
{
  return g_object_new (kp_preset_workout_get_type (), NULL);
}

/**
 * kp_preset_workout_new:
 * @name: Name of the preset workout
 * 
 * Create a new instance of #KPPresetWorkout.
 * 
 * Returns: A new #KPPresetWorkout.
 */
KPPresetWorkout *
kp_preset_workout_new_with_name (const gchar *name)
{
  GObject *wo;
  
  wo = g_object_new (kp_preset_workout_get_type (), NULL);
  kp_preset_workout_set_name (KP_PRESET_WORKOUT (wo), name);

  return KP_PRESET_WORKOUT (wo);
}


static gchar *
kp_preset_workout_get_human_name (KPCalendarEntry *entry)
{
  return g_strdup (_("Preset workout"));
}

static guint
kp_preset_workout_get_duration (KPWorkoutModel *wo)
{
  return kp_workout_model_get_duration (KP_WORKOUT_MODEL (KP_WORKOUT (wo)));
}

static gdouble
kp_preset_workout_get_distance (KPWorkoutModel *wo)
{
  return kp_workout_model_get_distance (KP_WORKOUT_MODEL (KP_WORKOUT (wo)));
}


const gchar *
kp_preset_workout_get_name (KPPresetWorkout *wo)
{
  g_return_val_if_fail (KP_IS_PRESET_WORKOUT (wo), NULL);
  g_return_val_if_fail (wo->name != NULL, NULL);

  return wo->name->str;
}

void
kp_preset_workout_set_name (KPPresetWorkout *wo, const gchar *name)
{
  g_return_if_fail (KP_IS_PRESET_WORKOUT (wo));
  g_return_if_fail (name != NULL);
  g_return_if_fail (wo->name != NULL);

  g_string_assign (wo->name, name);  
}


