#ifndef KP_PRESET_DATA_ITEM_H_
#define KP_PRESET_DATA_ITEM_H_

#include <libxml/tree.h>
#include <glib.h>


#define KP_PRESET_DATA_ITEM(x)  ((KPPresetDataItem *)(x))

typedef 
struct KPPresetDataItem_ {
  gchar   *name;
  gchar   *abbreviation;
  gchar   *description;
  gchar   *data;
  guint    id;
} KPPresetDataItem;


KPPresetDataItem  *kp_preset_data_item_new            (void);
KPPresetDataItem  *kp_preset_data_item_new_from_xml   (xmlNodePtr node);
xmlNodePtr         kp_preset_data_item_to_xml         (KPPresetDataItem *item);
void               kp_preset_data_item_free           (KPPresetDataItem *item); 
guint              kp_preset_data_item_get_id         (KPPresetDataItem *item);

#endif /* KP_PRESET_DATA_ITEM_H_ */
