#ifndef KP_PRESET_DATA_H_
#define KP_PRESET_DATA_H_

#include "kppresetdataitem.h"
#include "kppresetworkout.h"
#include <libxml/tree.h>
#include <glib.h>

typedef enum {
  KP_PRESET_DATA_SPORT,
  KP_PRESET_DATA_DETAIL,
  KP_PRESET_DATA_EXERCISE_TYPE,
  KP_PRESET_DATA_N
} KPPresetDataType;

gboolean          kp_preset_data_init              (const gchar *filename);
void              kp_preset_data_deinit            (void);
void              kp_preset_data_clean             (KPPresetDataType type);

void              kp_preset_data_add_item          (KPPresetDataType type,
                                                    KPPresetDataItem *item);

KPPresetDataItem *kp_preset_data_get_item          (KPPresetDataType type,
                                                    const gchar *name);
GSList           *kp_preset_data_get_items         (KPPresetDataType type);

/* Export & Import data */
void             kp_preset_data_write              (const gchar *file);

gboolean         kp_preset_data_import_tree        (xmlNodePtr node);
xmlNodePtr       kp_preset_data_export_tree        (void);

#endif
