#ifndef KP_HTML_DIAGRAM_H_
#define KP_HTML_DIAGRAM_H_

#include <glib.h>
#include <stdio.h>

typedef struct KPHtmlDiagram_ {
  /* Private Items */
  guint        groups;
  guint        items;
  gdouble     *data;
  gdouble      max;
  gdouble      min;

  GString     *title;
  GString     *x_title;
  GString     *y_title;

  /* items tells how many x_hints are there */
  gchar      **x_hints;

  gchar      **group_titles;
  
  guint        height;
} KPHtmlDiagram;

#define KP_HTML_DIAGRAM(pointer) ((KPHtmlDiagram *)(pointer))

KPHtmlDiagram   *kp_html_diagram_new             (guint groups, guint items);
void             kp_html_diagram_write           (KPHtmlDiagram *diagram, 
                                                  FILE *fp);
void             kp_html_diagram_set_title       (KPHtmlDiagram *diagram,
                                                  const gchar *title);
void             kp_html_diagram_set_x_title     (KPHtmlDiagram *diagram,
                                                  const gchar *title);
void             kp_html_diagram_set_y_title     (KPHtmlDiagram *diagram,
                                                  const gchar *title);
void             kp_html_diagram_set_group_title (KPHtmlDiagram *diagram,
                                                  guint n,
                                                  const gchar *title);
void             kp_html_diagram_set_x_hint      (KPHtmlDiagram *diagram,
                                                  guint n,
                                                  const gchar *title);
void             kp_html_diagram_set_data        (KPHtmlDiagram *diagram,
                                                  gdouble *data);
void             kp_html_diagram_free            (KPHtmlDiagram *diagram);

#endif /* KP_HTML_DIAGRAM_H_ */
