#ifndef KP_INTENSITY_ENTRY_H_
#define KP_INTENSITY_ENTRY_H_

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "../kptraininglog.h"

#include "kpviewmodel.h"

#define KP_TYPE_INTENSITY_ENTRY (kp_intensity_entry_get_type())
#define KP_INTENSITY_ENTRY(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_INTENSITY_ENTRY, KPIntensityEntry))
#define KP_INTENSITY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_INTENSITY_ENTRY, KPIntensityEntryClass))
#define KP_IS_INTENSITY_ENTRY(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_INTENSITY_ENTRY))
#define KP_IS_INTENSITY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_INTENSITY_ENTRY))
#define KP_INTENSITY_ENTRY_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_INTENSITY_ENTRY, KPIntensityEntryClass))

typedef struct KPIntensityEntry_
{
  GtkComboBoxEntry        parent;

  gpointer          private_data;
} KPIntensityEntry;

typedef struct KPIntensityEntryClass_
{
  GtkComboBoxEntryClass   parent;

  void             (* intensity_selected) (KPIntensityEntry *entry, 
                                           const gchar *sport);
} KPIntensityEntryClass;

GType           kp_intensity_entry_get_type        (void);
GtkWidget      *kp_intensity_entry_new             (void);
void            kp_intensity_entry_set_text        (KPIntensityEntry *entry,
                                                    const gchar *text);
    

#endif
