#include <gtk/gtk.h>
#include <glib.h>

#include "kpguiutils.h"
#include "kpcontexts.h"
#include "../kputil.h"

GSList *context_lists[KP_CONTEXT_N];
GSList *context_list = NULL;

void
kp_context_init (void)
{
  guint i;

  for (i=0; i < KP_CONTEXT_N; i++)
    context_lists[i] = NULL;
}

void
kp_context_add (guint flags, const gchar *title, GCallback cb,
                gpointer data, const gchar *icon)
{
  KPContextItem *item;
 
  item = g_new (KPContextItem, 1);
  item->flags = 0;
  item->flags |= flags;
  item->title = g_strdup (title);
  item->cb = cb;
  item->data = data;
  item->icon = (icon) ? g_strdup (icon) : NULL;

  context_list = g_slist_prepend (context_list, item);
}


GSList *
kp_context_get_items (KPContextType type)
{
  g_return_val_if_fail (type < KP_CONTEXT_N, NULL);

  return context_list;
}


GSList *
kp_context_get_menu_items (guint flags, KPCalendarEntry *entry)
{
  KPContextItem *ci;
  GtkWidget *image;
  GtkWidget *item;
  GSList *node;
  GSList *list = NULL;
  
  for (node = context_list; node; node = node->next) {
    ci = KP_CONTEXT_ITEM (node->data);

    if (ci->flags & flags) {
      item = gtk_image_menu_item_new_with_label (ci->title);
    
      if (ci->icon) {
        image = GTK_WIDGET (kp_get_icon_as_image (ci->icon));
        gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
      } 
      gtk_widget_show (item);
      g_signal_connect (G_OBJECT (item), "activate", ci->cb, entry);
      list = g_slist_prepend (list, item);
    }
  }

  return list;
}

