/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "tinstallersettings.h"


TInstallerSettings::TInstallerSettings()
{
  setKeepPackage(true);
  setUseCategories(false);
  setInstallType(TInstallerSettings::Make);
  setKeepInstallfiles(true);
}


TInstallerSettings::~TInstallerSettings()
{
}


/*!
 */
bool TInstallerSettings::readConfig(KConfig * config)
{
  // is the config file v0.1?
  if (!config->hasGroup(CONFIG_GROUPSETTINGS))
  {
    config->setGroup(CONFIG_GROUPGENERAL);
    setKDEBase(config->readEntry(CONFIG_KEYKDEBASE,""));
    if (config->readNumEntry(CONFIG_KEYINSTALLTYPE,0) == 0)
    {
      setStorageDir(config->readEntry(CONFIG_KEYTEMPDIR,"/tmp"));
    }
    else
    {
      setStorageDir(config->readEntry(CONFIG_KEYPKGDIR,""));
    }
    setKeepPackage(true);
    setUseCategories(false);
    setInstallType(TInstallerSettings::Make);
    setKeepInstallfiles(true);
    setUseConfigureOptions(config->readBoolEntry(CONFIG_KEYUSECONFIGOPTIONS,false));
    setConfigureOptions(config->readEntry(CONFIG_KEYCONFIGOPTIONS,""));
  }
  else
  {
    config->setGroup(CONFIG_GROUPSETTINGS);
    // source/dest options
    setKDEBase(config->readEntry(CONFIG_KEYKDEBASE,""));
    // storage options
    setStorageDir(config->readEntry(CONFIG_KEYSTORAGEDIR,""));
    setKeepPackage(config->readBoolEntry(CONFIG_KEYKEEPPACKAGE,true));
    setUseCategories(config->readBoolEntry(CONFIG_KEYUSECATEGORIES,false));
    // install/uninstall options
    if (config->readNumEntry(CONFIG_KEYINSTALLTYPE,Make) == Make)
      setInstallType(TInstallerSettings::Make);
    else
      setInstallType(TInstallerSettings::Checkinstall);
//    setKeepInstallfiles(config->readBoolEntry(CONFIG_KEYKEEPFILES,true));
    setKeepInstallfiles(true);
    if (config->readNumEntry(CONFIG_KEYPACKKAGETYPE,RPM) == RPM)
      setPackageType(TInstallerSettings::RPM);
    else if (config->readNumEntry(CONFIG_KEYPACKKAGETYPE,RPM) == Debian)
      setPackageType(TInstallerSettings::Debian);
    else
      setPackageType(TInstallerSettings::Slackware);
    // configure options
    setUseConfigureOptions(config->readBoolEntry(CONFIG_KEYUSECONFIGOPTIONS,false));
    setConfigureOptions(config->readEntry(CONFIG_KEYCONFIGOPTIONS,""));
  }

  return(true);
}


/*!
 */
bool TInstallerSettings::writeConfig(KConfig * config)
{
  config->setGroup(CONFIG_GROUPSETTINGS);
  // general options
  config->writeEntry(CONFIG_KEYKDEBASE,KDEBase());
  // persistence options
  config->writeEntry(CONFIG_KEYSTORAGEDIR,storageDir());
  config->writeEntry(CONFIG_KEYKEEPPACKAGE,keepPackage());
  config->writeEntry(CONFIG_KEYUSECATEGORIES,useCategories());
  // install/uninstall options
  config->writeEntry(CONFIG_KEYINSTALLTYPE,installType());
  config->writeEntry(CONFIG_KEYKEEPFILES,keepInstallfiles());
  config->writeEntry(CONFIG_KEYPACKKAGETYPE,packageType());
  // configure options
  config->writeEntry(CONFIG_KEYUSECONFIGOPTIONS,useConfigureOptions());
  config->writeEntry(CONFIG_KEYCONFIGOPTIONS,configureOptions());

  return(true);
}


/*!
 */
QString TInstallerSettings::KDEBase()
{
  return(m_kdeBaseDir);
}


/*!
 */
void TInstallerSettings::setKDEBase(const QString & dir)
{
  m_kdeBaseDir = dir;
}


/*!
 */
QString TInstallerSettings::storageDir()
{
  return(m_storageDir);
}


/*!
 */
void TInstallerSettings::setStorageDir(const QString & dir)
{
  m_storageDir = dir;
}


/*!
 */
bool TInstallerSettings::keepPackage()
{
  return(m_keepPackage);
}


/*!
 */
void TInstallerSettings::setKeepPackage(bool keep)
{
  m_keepPackage = keep;
}


/*!
 */
bool TInstallerSettings::useCategories()
{
  return(m_useCategories);
}


/*!
 */
void TInstallerSettings::setUseCategories(bool use)
{
  m_useCategories = use;
}


/*!
 */
bool TInstallerSettings::useConfigureOptions()
{
  return(m_useConfigureOptions);
}


/*!
 */
void TInstallerSettings::setUseConfigureOptions(bool use)
{
  m_useConfigureOptions = use;
}


/*!
 */
QString TInstallerSettings::configureOptions()
{
  return(m_configureOptions);
}


/*!
 */
void TInstallerSettings::setConfigureOptions(const QString & opts)
{
  m_configureOptions = opts;
}


/*!
 */
TInstallerSettings::InstallType TInstallerSettings::installType()
{
  return(m_installType);
}


/*!
 */
void TInstallerSettings::setInstallType(TInstallerSettings::InstallType type)
{
  m_installType = type;
}


/*!
 */
bool TInstallerSettings::keepInstallfiles()
{
  return(m_keepInstallfiles);
}


/*!
 */
void TInstallerSettings::setKeepInstallfiles(bool keep)
{
  m_keepInstallfiles = keep;
}


/*!
 */
TInstallerSettings::PackageType TInstallerSettings::packageType()
{
  return(m_packageType);
}


/*!
 */
void TInstallerSettings::setPackageType(TInstallerSettings::PackageType type)
{
  m_packageType = type;
}
