/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, http://www.stierand-linuxit.de   *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KINSTALLERPREF_H_
#define _KINSTALLERPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

#include "tinstallersettings.h"
#include "ksettingsgeneralwidget.h"
#include "ksettingsinstallwidget.h"


class KInstallerPreferences : public KDialogBase
{
  Q_OBJECT
  public:
    KInstallerPreferences();
    
    bool execute(TInstallerSettings * settings);

  signals:
    void signalGuessKDEBaseClicked(QString & dir);
    void signalSelectStorageDirClicked(QString & dir);

  private slots:
    void slotGuessKDEBaseClicked(QString & dir);
    void slotSelectStorageDirClicked(QString & dir);

  private:
    TInstallerSettings * m_settings;
    KSettingsGeneralWidget * m_pageOne;
    KSettingsInstallWidget * m_pageTwo;
};


#endif // _KINSTALLERPREF_H_
