/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
  
#include <qapplication.h>
 
#include "kinstallerprocess.h"
#include "kinstallerprocess.moc"



KInstallerProcess::KInstallerProcess(QObject *parent, const char *name)
 : QObject(parent, name)
{
  m_proc = new KProcess();
  m_proc->setUseShell(true);
  connect(m_proc,SIGNAL(receivedStdout(KProcess *, char *, int)),
          this,SLOT(slotReceivedStdout(KProcess *, char *, int)));
  connect(m_proc,SIGNAL(receivedStderr(KProcess *, char *, int)),
          this,SLOT(slotReceivedStderr(KProcess *, char *, int)));
  connect(m_proc,SIGNAL(processExited(KProcess *)),
          this,SLOT(slotProcessExited(KProcess *)));
}


KInstallerProcess::~KInstallerProcess()
{
}


/*!
 */
bool KInstallerProcess::exec(const QString & command, 
                             const QString & arg1, const QString & arg2, 
                             const QString & arg3, const QString & arg4,
                             const QString & arg5, const QString & arg6)
{
  m_proc->clearArguments();
  *m_proc << command;
  if (arg1 != QString::null)
    *m_proc << KShellProcess::quote(arg1);
  if (arg2 != QString::null)
    *m_proc << KShellProcess::quote(arg2);
  if (arg3 != QString::null)
    *m_proc << KShellProcess::quote(arg3);
  if (arg4 != QString::null)
    *m_proc << KShellProcess::quote(arg4);
  if (arg5 != QString::null)
    *m_proc << KShellProcess::quote(arg5);
  if (arg6 != QString::null)
    *m_proc << KShellProcess::quote(arg6);
  
  
  
/*  for (QValueList<QCString>::const_iterator it = m_proc->args().begin(); it != m_proc->args().end(); ++it)
  {
    qDebug(*it);
  }*/
  

  m_aborted = false;
  m_result = true;
  m_proc->start(KProcess::NotifyOnExit,KProcess::AllOutput);
  
  while(m_proc->isRunning())
    qApp->processEvents();
  
  return(m_result);
}


/*!
 */
void KInstallerProcess::slotReceivedStdout(KProcess *proc, char *buf, int len)
{
  QString str;


  str.setLatin1(buf,len);

//  qDebug("stdout:" + str);
  emit signalProcessStdout(str);
}


/*!
 */
void KInstallerProcess::slotReceivedStderr(KProcess *proc, char *buf, int len)
{
  QString str;


  str.setLatin1(buf,len);

//  qDebug("stderr:" + str);
  emit signalProcessStderr(str);
}


/*!
 */
void KInstallerProcess::slotProcessExited(KProcess *proc)
{
//  qDebug(tr("process ended with code %1").arg(proc->exitStatus()));
  if (!m_aborted && !proc->normalExit())
  {
    m_result = false;
//    qDebug("not normal exit");
  }
  else if (!m_aborted && (proc->exitStatus() != 0))
  {
    m_result = false;
//    qDebug("status code");
  }
  else
  {
    m_result = true;
//    qDebug("normal exit");
  }
}


/*!
 */
bool KInstallerProcess::isRunning()
{
  return(m_proc->isRunning());
}


/*!
 */
void KInstallerProcess::requestAbort()
{
  if (m_proc->isRunning())
  {
    m_aborted = true;
    m_proc->kill();
  }
}

