/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef I8KSRC_H
#define I8KSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <qfile.h>
#include <list>

/**
 * I8kSrc reads CPU thermal and fan rpm values from /proc/i8k
 * which is provided by the i8k kernel module.
 */
class I8kSrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File
	 */
	I8kSrc(QWidget* inParent, const QFile& inSourceFile, unsigned int inIndex);
	virtual ~I8kSrc();
	
	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual QString fetchValue();

private:
	/**
	 * Returns the name (such as CPU, GPU, ...) of the sensor according to a given index
	 */
	static QString index2Name(unsigned int inIndex);

	/**
	 * the index of the source in /proc/acpi/ibm/thermal
	 */
	unsigned int mIndex;

	/**
	 * The file from which the value is read
	 */
	QFile mSourceFile;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //I8KSRC_H

