// This file is generated by kconfig_compiler from pagersettings.kcfg.
// All changes you do to this file will be lost.
#ifndef PAGERSETTINGS_H
#define PAGERSETTINGS_H

#include <kglobal.h>
#include <kconfigskeleton.h>
#include <kdebug.h>

class PagerSettings : public KConfigSkeleton
{
  public:
    class EnumLabelType
    {
      public:
      enum type { LabelNone, LabelName, LabelNumber, COUNT };
    };
    class EnumBackgroundType
    {
      public:
      enum type { BgPlain, BgTransparent, BgLive, COUNT };
    };

    PagerSettings( KSharedConfig::Ptr config = KGlobal::sharedConfig() );
    ~PagerSettings();

    /**
      Set Virtual desktop label type
    */
    void setLabelType( int v )
    {
      if (!isImmutable( QString::fromLatin1( "LabelType" ) ))
        mLabelType = v;
    }

    /**
      Get Virtual desktop label type
    */
    int labelType() const
    {
      return mLabelType;
    }

    /**
      Set Virtual desktop background type
    */
    void setBackgroundType( int v )
    {
      if (!isImmutable( QString::fromLatin1( "BackgroundType" ) ))
        mBackgroundType = v;
    }

    /**
      Get Virtual desktop background type
    */
    int backgroundType() const
    {
      return mBackgroundType;
    }

    /**
      Set Number of rows to arrange the desktop previews into
    */
    void setNumberOfRows( int v )
    {
      if (v < 0)
      {
        kdDebug() << "setNumberOfRows: value " << v << " is less than the minimum value of 0" << endl;
        v = 0;
      }

      if (v > 4)
      {
        kdDebug() << "setNumberOfRows: value " << v << " is greater than the maximum value of 4" << endl;
        v = 4;
      }

      if (!isImmutable( QString::fromLatin1( "NumberOfRows" ) ))
        mNumberOfRows = v;
    }

    /**
      Get Number of rows to arrange the desktop previews into
    */
    int numberOfRows() const
    {
      return mNumberOfRows;
    }

    /**
      Set Show desktop preview?
    */
    void setPreview( bool v )
    {
      if (!isImmutable( QString::fromLatin1( "Preview" ) ))
        mPreview = v;
    }

    /**
      Get Show desktop preview?
    */
    bool preview() const
    {
      return mPreview;
    }

    /**
      Set Show window icons in previews?
    */
    void setIcons( bool v )
    {
      if (!isImmutable( QString::fromLatin1( "Icons" ) ))
        mIcons = v;
    }

    /**
      Get Show window icons in previews?
    */
    bool icons() const
    {
      return mIcons;
    }

  protected:

    // General
    int mLabelType;
    int mBackgroundType;
    int mNumberOfRows;
    bool mPreview;
    bool mIcons;

  private:
};

#endif

