/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



#ifndef KHALKHI_ICON_H
#define KHALKHI_ICON_H

// qt specific
#include <qpixmap.h>
#include <qimage.h>
// kde
#include <kdemacros.h>

namespace KABC { class Addressee; }


namespace Khalkhi {

class KDE_EXPORT Icon
{
public:
    Icon( int Size );
    ~Icon();

public:
    QPixmap data() const;
    int symbolSize() const;

public:
    void appendIcon( const QImage &I );
    void appendSymbol( const QImage &S );
    void fill( const KABC::Addressee &Person );

protected:
    QImage Data;
    /** contains the number of added symbols */
    int Symbols;
    int SymbolSize;
};


inline Icon::~Icon() {}

inline QPixmap Icon::data() const { return Data; }
inline int Icon::symbolSize() const { return SymbolSize; }

}

#endif
