/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef LISTALLPROPERTIESDEFAULTDATAACTIONSERVICEMENUFILLER_H
#define LISTALLPROPERTIESDEFAULTDATAACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
// kde specific
#include <kabc/addresseelist.h>
// khalkhi core
#include "listallpropertiesglobaldataactionserviceclient.h"
// lib specific
#include "idserviceactionmap.h"

class QPopupMenu;

namespace Khalkhi {

class KDE_EXPORT ListAllPropertiesGlobalDataActionServiceMenuFiller
 : public QObject, public ListAllPropertiesGlobalDataActionServiceClient
{
    Q_OBJECT
public:
    ListAllPropertiesGlobalDataActionServiceMenuFiller();
    virtual ~ListAllPropertiesGlobalDataActionServiceMenuFiller();

public:
    void set( const KABC::AddresseeList &PersonList, QMimeSource *E );
    int fillMenu( QPopupMenu *Menu, int BaseMenuId );

public: // GlobalDropServiceClient API
    virtual void onGlobalDataActionServiceSwitch( const QString &PropertyId );
    virtual void onPropertyManagerChange();

public: // DropServiceClient API
    virtual const KABC::AddresseeList &personList() const;
    virtual QMimeSource *dataSource() const;
//     virtual void onDataActionServiceStateChange( const PropertyDataActionService &Service, int Change,
//                                                  int ItemIndex );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    KABC::AddresseeList PersonList;
    QMimeSource *DataSource;

    QPopupMenu *Menu;
    IdServiceActionMap IdActionMap;
};


inline ListAllPropertiesGlobalDataActionServiceMenuFiller::ListAllPropertiesGlobalDataActionServiceMenuFiller()
: Menu( 0 ) {}

inline void ListAllPropertiesGlobalDataActionServiceMenuFiller::set( const KABC::AddresseeList &PL, QMimeSource *S ) { PersonList = PL; DataSource = S; }

}

#endif
