/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "map.h"

//KGRUBEditor
#include "kgrubeditor.h"

MapAssistant::MapAssistant( GRUB::ComplexCommand::Map *map, QWidget *parent ) : KAssistantDialog( parent )
{
//SETUP UI
	setCaption( i18n( "Map Assistant" ) );
	setWindowIcon( KIcon( "drive-harddisk" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	showButton( KDialog::Help, false );

	QWidget *intro = new QWidget;
	ui_intro.setupUi( intro );
	addPage( intro, i18n( "Introduction" ) );
	QWidget *step1 = new QWidget;
	ui_step1.setupUi( step1 );
	addPage( step1, i18n( "Step 1/2 - From Drive" ) );
	QWidget *step2 = new QWidget;
	ui_step2.setupUi( step2 );
	addPage( step2, i18n( "Step 2/2 - To Drive" ) );
	QWidget *summary = new QWidget;
	ui_summary.setupUi( summary );
	summaryPage = addPage( summary, i18n( "Summary" ) );

	for ( int i = 0; i < KGRUBEditor::DeviceList.size(); i++ )
	{
		if ( !alreadyExists( KGRUBEditor::DeviceList.at( i ).grubDevice() ) )
		{
			ui_step1.comboBox_fromDrive->addItem( KGRUBEditor::DeviceList.at( i ).grubDevice() );
			ui_step2.comboBox_toDrive->addItem( KGRUBEditor::DeviceList.at( i ).grubDevice() );
		}
	}
//PROPERTY SETUP
	m_map = map;
//SHOW MAP(IF ANY - ONLY USED IN EDIT MODE)
	if ( !map->isEmpty() )
	{
		for ( int i = 0; i < ui_step1.comboBox_fromDrive->count(); i++ )
		{
			if ( ui_step1.comboBox_fromDrive->itemText( i ) == map->fromDrive() )
			{
				ui_step1.comboBox_fromDrive->setCurrentIndex( i );
				break;
			}
		}
		for ( int j = 0; j < ui_step2.comboBox_toDrive->count(); j++ )
		{
			if ( ui_step2.comboBox_toDrive->itemText( j ) == map->toDrive() )
			{
				ui_step2.comboBox_toDrive->setCurrentIndex( j );
				break;
			}
		}
	}
//SETUP CONNECTIONS
	connect( this, SIGNAL( user2Clicked() ), SLOT( nextClicked() ) );
	connect( this, SIGNAL( user1Clicked() ), SLOT( finishClicked() ) );
}

bool MapAssistant::alreadyExists( const QString device )
{
	for ( int i = 0; i < ui_step1.comboBox_fromDrive->count(); i++ )
		if ( ui_step1.comboBox_fromDrive->itemText( i ) == device )
			return true;
	return false;
}

void MapAssistant::nextClicked()
{
	if ( currentPage() == summaryPage )
	{
		GRUB::ComplexCommand::Map tmp_map;
		tmp_map.setFromDrive( ui_step1.comboBox_fromDrive->currentText() );
		tmp_map.setToDrive( ui_step2.comboBox_toDrive->currentText() );

		ui_summary.label_map->setText( "<b>" + tmp_map.result() + "</b>" );
	}
}
void MapAssistant::finishClicked()
{
	m_map->setFromDrive( ui_step1.comboBox_fromDrive->currentText() );
	m_map->setToDrive( ui_step2.comboBox_toDrive->currentText() );
}
