/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//KDE
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>

//KGRUBEditor
#include "kgrubeditor.h"

int main( int argc, char **argv )
{
	KAboutData about( "kgrubeditor", 0, ki18n( "KGRUBEditor" ), "0.5", ki18n( "A KDE utility, that edits GRUB's configuration files through an inituitive user interface." ), KAboutData::License_GPL, ki18n( "Copyright (C) 2008 Konstantinos Smanis" ), KLocalizedString(), "http://sourceforge.net/projects/kgrubeditor", "kon.smanis@gmail.com" );
	about.addAuthor( ki18n( "Κonstantinos Smanis" ), ki18n( "Head Developer" ), "kon.smanis@gmail.com" );
	about.addCredit( ki18n( "Andreas Theodosiou" ), ki18n( "Application's Icon Graphics Designer" ), "andreasabu@gmail.com" );
	about.addCredit( ki18n( "JimTB (nickname)" ), ki18n( "Miscellaneous help with the project" ), "jimaras@gmail.com" );
	about.addCredit( ki18n( "prts_1 (nickname)" ), ki18n( "Tips concerning usability" ), "prts_1@e-pcmag.gr" );
	KCmdLineArgs::init( argc, argv, &about );

	KApplication app;
	KGRUBEditor *main_window = new KGRUBEditor;
	
	if ( app.isSessionRestored() )
	{
		RESTORE( KGRUBEditor );
	}
	else
	{
		main_window->show();
	}

	return app.exec();
}
