
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

from kdecore import KSimpleConfig
from qt import QDir,QString
import pyDes

class ConfigurationHandler:
	def __init__(self):
		
		self.configuration = KSimpleConfig(QDir.homeDirPath().ascii() + "/.kde/share/config/kgmailnotifierrc",False)
		
		print "Reading configuration..."
		self.Username = self.configuration.readEntry("Username","username@gmail.com")
		
		# Get encrypted password and decrypt it
		password = self.configuration.readEntry("Password","")
		if password == "":
			self.Password = ""
		else:
			crypto = pyDes.des("DESCRYPT", pyDes.CBC, "\0\0\0\0\0\0\0\0")
			try:
				tempPassword = crypto.decrypt(password.ascii(), "*") # If the password is written in plain it will likely have a invalid length
				self.Password = tempPassword[:-1] # Remove the seperator "/"
			except:
				print "You password seems to have been stored in plain text."
				self.Password = password
		
		self.SavePassword = self.configuration.readBoolEntry("SavePassword",False)
		self.BrowserPath = self.configuration.readEntry("BrowserPath","/usr/bin/firefox")
		self.Language = self.configuration.readEntry("Language","English")
		self.CheckInterval = self.configuration.readNumEntry("CheckInterval",60)
		self.VerticalOffset = self.configuration.readNumEntry("VerticalOffset",50)
		self.HorizontalOffset = self.configuration.readNumEntry("HorizontalOffset",50)
		self.SoundEnabled = self.configuration.readBoolEntry("SoundEnabled", False)
		self.FileToPlay = self.configuration.readPathEntry("FileToPlay", "")
		self.PopupTimeout = self.configuration.readNumEntry("PopupTimeout",5)
		self.PopupAnimated = self.configuration.readNumEntry("PopupAnimated",True)
		self.AnimationDelay = self.configuration.readNumEntry("AnimationDelay",5)
		self.PopupDirection = self.configuration.readEntry("PopupDirection","Up")
		self.LedsEnabled = self.configuration.readBoolEntry("LedsEnabled",False)
		self.LedOnCommand = self.configuration.readEntry("LedOnCommand","")
		self.LedOffCommand = self.configuration.readEntry("LedOffCommand","")


	def GetUsername(self):
		return QString(self.Username)
	
	def SetUsername(self,name):
		self.Username = name


	def GetPassword(self):
		return QString(self.Password)

	def SetPassword(self,password):
		self.Password = password


	def GetSavePassword(self):
		return self.SavePassword
	
	def SetSavePassword(self,save):
		self.SavePassword = save


	def GetBrowserPath(self):
		return self.BrowserPath
	
	def SetBrowserPath(self,path):
		self.BrowserPath = path
		
		
	def GetLanguage(self):
		return self.Language
	
	def SetLanguage(self,language):
		self.Language = language


	def GetCheckInterval(self):
		return self.CheckInterval
	
	def SetCheckInterval(self,interval):
		self.CheckInterval = interval


	def GetVerticalOffset(self):
		return self.VerticalOffset
	
	def SetVerticalOffset(self,voffset):
		self.VerticalOffset = voffset


	def GetHorizontalOffset(self):
		return self.HorizontalOffset
	
	def SetHorizontalOffset(self,hoffset):
		self.HorizontalOffset = hoffset


	def GetSoundEnabled(self):
		return self.SoundEnabled
	
	def SetSoundEnabled(self,isEnabled):
		self.SoundEnabled = isEnabled


	def GetFileToPlay(self):
		return self.FileToPlay
	
	def SetFileToPlay(self,file):
		self.FileToPlay = file


	def GetPopupTimeout(self):
		return self.PopupTimeout
	
	def SetPopupTimeout(self, timeout):
		self.PopupTimeout = timeout


	def GetPopupAnimated(self):
		return self.PopupAnimated
	
	def SetPopupAnimated(self, animated):
		self.PopupAnimated = animated


	def GetAnimationDelay(self):
		return self.AnimationDelay
	
	def SetAnimationDelay(self, delay):
		self.AnimationDelay = delay
		
		
	def GetPopupDirection(self):
		return self.PopupDirection
	
	def SetPopupDirection(self, direction):
		self.PopupDirection = direction


	def GetLedsEnabled(self):
		return self.LedsEnabled
	
	def SetLedsEnabled(self,isEnabled):
		self.LedsEnabled = isEnabled


	def GetLedOnCommand(self):
		return self.LedOnCommand
	
	def SetLedOnCommand(self,command):
		self.LedOnCommand = command


	def GetLedOffCommand(self):
		return self.LedOffCommand
	
	def SetLedOffCommand(self,command):
		self.LedOffCommand = command


	def SaveConfiguration(self):
		# Store configuration data
		self.configuration.writeEntry("Username",self.Username,True,False,False)
		self.configuration.writeEntry("SavePassword",self.SavePassword,True,False,False)
		
		if self.SavePassword == True:
			# Encrypt the password
			crypto = pyDes.des("DESCRYPT", pyDes.CBC, "\0\0\0\0\0\0\0\0")
			tempPassword = self.Password.ascii() + "/" # Add seperator "/" just in case the password ends with "*"
			password = crypto.encrypt(tempPassword, "*")
			self.configuration.writeEntry("Password",password,True,False,False)
		else:
			self.configuration.writeEntry("Password","",True,False,False)
		
		self.configuration.writeEntry("BrowserPath",self.BrowserPath,True,False,False)
		self.configuration.writeEntry("Language",self.Language,True,False,False)
		self.configuration.writeEntry("CheckInterval",self.CheckInterval,True,False,False)
		self.configuration.writeEntry("VerticalOffset",self.VerticalOffset,True,False,False)
		self.configuration.writeEntry("HorizontalOffset",self.HorizontalOffset,True,False,False)
		self.configuration.writeEntry("SoundEnabled",self.SoundEnabled,True,False,False)
		self.configuration.writeEntry("FileToPlay",self.FileToPlay,True,False,False)
		self.configuration.writeEntry("PopupTimeout",self.PopupTimeout,True,False,False)
		self.configuration.writeEntry("PopupAnimated",self.PopupAnimated,True,False,False)
		self.configuration.writeEntry("AnimationDelay",self.AnimationDelay,True,False,False)
		self.configuration.writeEntry("PopupDirection",self.PopupDirection,True,False,False)
		self.configuration.writeEntry("LedsEnabled",self.LedsEnabled,True,False,False)
		self.configuration.writeEntry("LedOnCommand",self.LedOnCommand,True,False,False)
		self.configuration.writeEntry("LedOffCommand",self.LedOffCommand,True,False,False)

		# Save to file
		print "Saving configuration..."
		self.configuration.sync()
