/***************************************************************************
                           vbidecoder.h
                           ------------
    begin                : Sun Oct 26 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef VBIDECODER_H
#define VBIDECODER_H

#include <kdetvvbiplugin.h>
#include <qstring.h>

class QComboBox;
class QLabel;
class VbiDecoderPrivate;

class VbiDecoderPlugin : public KdetvVbiPlugin
{
    Q_OBJECT


public:
    VbiDecoderPlugin(Kdetv* ktv, const QString& cfgkey, QObject* parent, const char* name=0);
    virtual ~VbiDecoderPlugin();
    
    virtual bool restart();

    virtual bool decoding() const;
    virtual bool tuned() const;
    virtual void suspend();
    virtual void resume();


    QWidget* configWidget(QWidget* parent, const char* name);
    void     saveConfig();


private slots:
    void changed();


private:
    QString     _cfg_dev;
    uint        _cfg_norm;
    QComboBox*  _cb_dev;
    QComboBox*  _cb_norm;
    QLabel*     _lb_running;

    VbiDecoderPrivate* _t;
};

#endif // VBIDECODER_H
