// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef KDETVEXTENSION_H
#define KDETVEXTENSION_H

#include <kpanelextension.h>

class KdetvPart;
class KdetvWidget;

/**
 * A panel extension that displays a TV picture.
 *
 * @author Richard Moore, <rich@kde.org>
 */
class KdetvExtension : public KPanelExtension
{
    Q_OBJECT

public:
    KdetvExtension( const QString& configFile, Type t = Normal, int actions = 0,
                    QWidget *parent = 0, const char *name = 0 );
    ~KdetvExtension();

    virtual QSize sizeHint( Position , QSize maxsize ) const;
    virtual void positionChange( Position /* position */);

protected slots:
    virtual void about();
    virtual void help();
    virtual void preferences();
    virtual void reportBug();

protected:
    void showEvent( QShowEvent *se );

private:
    KdetvPart *tv;
    KdetvWidget *screen;
};

#endif
