//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Runtime.InteropServices;
	using System.Collections.Generic;

	/// <remarks>
	///  KCalendarSystem abstract base class, provides support for local Calendar Systems in KDE
	///  Derived classes must be created through the create() static method
	///  </remarks>		<short>    KCalendarSystem abstract base class, provides support for local Calendar Systems in KDE </short>

	[SmokeClass("KCalendarSystem")]
	public abstract class KCalendarSystem : Object {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KCalendarSystem(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KCalendarSystem), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KCalendarSystem() {
			staticInterceptor = new SmokeInvocation(typeof(KCalendarSystem), null);
		}
		/// <remarks>
		///  Format for returned year number / month number / day number as string.
		///      </remarks>		<short>    Format for returned year number / month number / day number as string.</short>
		public enum StringFormat {
			ShortFormat = 0,
			LongFormat = 1,
		}
		/// <remarks>
		///  Format for returned month / day name.
		///      </remarks>		<short>    Format for returned month / day name.</short>
		public enum MonthNameFormat {
			ShortName = 0,
			LongName = 1,
			ShortNamePossessive = 2,
			LongNamePossessive = 3,
		}
		/// <remarks>
		///  Format for returned month / day name.
		///      </remarks>		<short>    Format for returned month / day name.</short>
		public enum WeekDayNameFormat {
			ShortDayName = 0,
			LongDayName = 1,
		}
		/// <remarks>
		///  Constructor of abstract calendar class. This will be called by derived classes.
		/// <param> name="locale" locale to use for translations. The global locale is used if null.
		///      </param></remarks>		<short>    Constructor of abstract calendar class.</short>
		public KCalendarSystem(KLocale locale) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KCalendarSystem#", "KCalendarSystem(const KLocale*)", typeof(void), typeof(KLocale), locale);
		}
		public KCalendarSystem() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KCalendarSystem", "KCalendarSystem()", typeof(void));
		}
		/// <remarks>
		///  Returns the calendar system type.
		/// </remarks>		<return> type of calendar system
		///      </return>
		/// 		<short>    Returns the calendar system type.</short>
		[SmokeMethod("calendarType() const")]
		public abstract string CalendarType();
		/// <remarks>
		///  Returns a QDate holding the epoch of the calendar system.  Usually YMD
		///  of 1/1/1, access the returned QDates method toJulianDay() if you
		///  require the actual Julian day number.  Note: a particular calendar
		///  system implementation may not include the epoch in its supported range,
		///  or the calendar system may be proleptic in which case it supports dates
		///  before the epoch.
		/// </remarks>		<return> epoch of calendar system
		///      </return>
		/// 		<short>    Returns a QDate holding the epoch of the calendar system.</short>
		/// 		<see> KCalendarSystem.EarliestValidDate</see>
		/// 		<see> KCalendarSystem.LatestValidDate</see>
		/// 		<see> KCalendarSystem.IsProleptic</see>
		/// 		<see> KCalendarSystem.IsValid</see>
		[SmokeMethod("epoch() const")]
		public virtual QDate Epoch() {
			return (QDate) interceptor.Invoke("epoch", "epoch() const", typeof(QDate));
		}
		/// <remarks>
		///  Returns the earliest date valid in this calendar system implementation.
		///  If the calendar system is proleptic then this may be before epoch.
		/// </remarks>		<return> date the earliest valid date
		///      </return>
		/// 		<short>    Returns the earliest date valid in this calendar system implementation.</short>
		/// 		<see> KCalendarSystem.Epoch</see>
		/// 		<see> KCalendarSystem.LatestValidDate</see>
		[SmokeMethod("earliestValidDate() const")]
		public virtual QDate EarliestValidDate() {
			return (QDate) interceptor.Invoke("earliestValidDate", "earliestValidDate() const", typeof(QDate));
		}
		/// <remarks>
		///  Returns the latest date valid in this calendar system implementation.
		/// </remarks>		<return> date the latest valid date
		///      </return>
		/// 		<short>    Returns the latest date valid in this calendar system implementation.</short>
		/// 		<see> KCalendarSystem.Epoch</see>
		/// 		<see> KCalendarSystem.EarliestValidDate</see>
		[SmokeMethod("latestValidDate() const")]
		public virtual QDate LatestValidDate() {
			return (QDate) interceptor.Invoke("latestValidDate", "latestValidDate() const", typeof(QDate));
		}
		/// <remarks>
		///  Returns whether a given date is valid in this calendar system.
		/// <param> name="year" the year portion of the date to check
		/// </param><param> name="month" the month portion of the date to check
		/// </param><param> name="day" the day portion of the date to check
		/// </param></remarks>		<return> @c true if the date is valid, @c false otherwise
		///      </return>
		/// 		<short>    Returns whether a given date is valid in this calendar system.</short>
		[SmokeMethod("isValid(int, int, int) const")]
		public abstract bool IsValid(int year, int month, int day);
		/// <remarks>
		///  Returns whether a given date is valid in this calendar system.
		/// <param> name="date" the date to check
		/// </param></remarks>		<return> @c true if the date is valid, @c false otherwise
		///      </return>
		/// 		<short>    Returns whether a given date is valid in this calendar system.</short>
		[SmokeMethod("isValid(const QDate&) const")]
		public virtual bool IsValid(QDate date) {
			return (bool) interceptor.Invoke("isValid#", "isValid(const QDate&) const", typeof(bool), typeof(QDate), date);
		}
		/// <remarks>
		///  Changes the date's year, month and day. The range of the year, month
		///  and day depends on which calendar is being used.  All years entered
		///  are treated literally, i.e. no Y2K translation is applied to years
		///  entered in the range 00 to 99.  Replaces setYMD.
		/// <param> name="date" date to change
		/// </param><param> name="year" year
		/// </param><param> name="month" month number
		/// </param><param> name="day" day of month
		/// </param></remarks>		<return> @c true if the date is valid, @c false otherwise
		///      </return>
		/// 		<short>    Changes the date's year, month and day.</short>
		[SmokeMethod("setDate(QDate&, int, int, int) const")]
		public virtual bool SetDate(QDate date, int year, int month, int day) {
			return (bool) interceptor.Invoke("setDate#$$$", "setDate(QDate&, int, int, int) const", typeof(bool), typeof(QDate), date, typeof(int), year, typeof(int), month, typeof(int), day);
		}
		/// <remarks>
		///  Returns the year portion of a given date in the current calendar system
		/// <param> name="date" date to return year for
		/// </param></remarks>		<return> year, 0 if input date is invalid
		///      </return>
		/// 		<short>    Returns the year portion of a given date in the current calendar system </short>
		[SmokeMethod("year(const QDate&) const")]
		public virtual int Year(QDate date) {
			return (int) interceptor.Invoke("year#", "year(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the month portion of a given date in the current calendar system
		/// <param> name="date" date to return month for
		/// </param></remarks>		<return> month of year, 0 if input date is invalid
		///      </return>
		/// 		<short>    Returns the month portion of a given date in the current calendar system </short>
		[SmokeMethod("month(const QDate&) const")]
		public virtual int Month(QDate date) {
			return (int) interceptor.Invoke("month#", "month(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the day portion of a given date in the current calendar system
		/// <param> name="date" date to return day for
		/// </param></remarks>		<return> day of the month, 0 if input date is invalid
		///      </return>
		/// 		<short>    Returns the day portion of a given date in the current calendar system </short>
		[SmokeMethod("day(const QDate&) const")]
		public virtual int Day(QDate date) {
			return (int) interceptor.Invoke("day#", "day(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns a QDate containing a date <code>nyears</code> years later.
		/// <param> name="date" The old date
		/// </param><param> name="nyears" The number of years to add
		/// </param></remarks>		<return> The new date, null date if any errors
		///      </return>
		/// 		<short>    Returns a QDate containing a date <code>nyears</code> years later.</short>
		[SmokeMethod("addYears(const QDate&, int) const")]
		public virtual QDate AddYears(QDate date, int nyears) {
			return (QDate) interceptor.Invoke("addYears#$", "addYears(const QDate&, int) const", typeof(QDate), typeof(QDate), date, typeof(int), nyears);
		}
		/// <remarks>
		///  Returns a QDate containing a date <code>nmonths</code> months later.
		/// <param> name="date" The old date
		/// </param><param> name="nmonths" number of months to add
		/// </param></remarks>		<return> The new date, null date if any errors
		///      </return>
		/// 		<short>    Returns a QDate containing a date <code>nmonths</code> months later.</short>
		[SmokeMethod("addMonths(const QDate&, int) const")]
		public virtual QDate AddMonths(QDate date, int nmonths) {
			return (QDate) interceptor.Invoke("addMonths#$", "addMonths(const QDate&, int) const", typeof(QDate), typeof(QDate), date, typeof(int), nmonths);
		}
		/// <remarks>
		///  Returns a QDate containing a date <code>ndays</code> days later.
		/// <param> name="date" The old date
		/// </param><param> name="ndays" number of days to add
		/// </param></remarks>		<return> The new date, null date if any errors
		///      </return>
		/// 		<short>    Returns a QDate containing a date <code>ndays</code> days later.</short>
		[SmokeMethod("addDays(const QDate&, int) const")]
		public virtual QDate AddDays(QDate date, int ndays) {
			return (QDate) interceptor.Invoke("addDays#$", "addDays(const QDate&, int) const", typeof(QDate), typeof(QDate), date, typeof(int), ndays);
		}
		/// <remarks>
		///  Returns number of months in the given year
		/// <param> name="date" the date to obtain year from
		/// </param></remarks>		<return> number of months in the year, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns number of months in the given year </short>
		[SmokeMethod("monthsInYear(const QDate&) const")]
		public virtual int MonthsInYear(QDate date) {
			return (int) interceptor.Invoke("monthsInYear#", "monthsInYear(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the number of ISO weeks in the given year.
		/// <param> name="date" the date to obtain year from
		/// </param></remarks>		<return> number of weeks in the year, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the number of ISO weeks in the given year.</short>
		[SmokeMethod("weeksInYear(const QDate&) const")]
		public virtual int WeeksInYear(QDate date) {
			return (int) interceptor.Invoke("weeksInYear#", "weeksInYear(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the number of ISO weeks in the given year.
		///  ISO 8601 defines the first week of the year as the week containing the first Thursday.
		///  See http://en.wikipedia.org/wiki/ISO_8601 and http://en.wikipedia.org/wiki/ISO_week_date
		/// <param> name="year" the year
		/// </param></remarks>		<return> number of weeks in the year, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the number of ISO weeks in the given year.</short>
		[SmokeMethod("weeksInYear(int) const")]
		public virtual int WeeksInYear(int year) {
			return (int) interceptor.Invoke("weeksInYear$", "weeksInYear(int) const", typeof(int), typeof(int), year);
		}
		/// <remarks>
		///  Returns the number of days in the given year.
		/// <param> name="date" the date to obtain year from
		/// </param></remarks>		<return> number of days in year, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the number of days in the given year.</short>
		[SmokeMethod("daysInYear(const QDate&) const")]
		public virtual int DaysInYear(QDate date) {
			return (int) interceptor.Invoke("daysInYear#", "daysInYear(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the number of days in the given month.
		/// <param> name="date" the date to obtain month from
		/// </param></remarks>		<return> number of days in month, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the number of days in the given month.</short>
		[SmokeMethod("daysInMonth(const QDate&) const")]
		public virtual int DaysInMonth(QDate date) {
			return (int) interceptor.Invoke("daysInMonth#", "daysInMonth(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the number of days in the given week.
		/// <param> name="date" the date to obtain week from
		/// </param></remarks>		<return> number of days in week, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the number of days in the given week.</short>
		[SmokeMethod("daysInWeek(const QDate&) const")]
		public virtual int DaysInWeek(QDate date) {
			return (int) interceptor.Invoke("daysInWeek#", "daysInWeek(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the day number of year for the given date
		/// <param> name="date" the date to obtain day from
		/// </param></remarks>		<return> day of year number, -1 if input date not valid
		///      </return>
		/// 		<short>    Returns the day number of year for the given date </short>
		[SmokeMethod("dayOfYear(const QDate&) const")]
		public virtual int DayOfYear(QDate date) {
			return (int) interceptor.Invoke("dayOfYear#", "dayOfYear(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the weekday number for the given date
		/// <param> name="date" the date to obtain day from
		/// </param></remarks>		<return> day of week number, -1 if input date not valid
		///      </return>
		/// 		<short>    Returns the weekday number for the given date </short>
		[SmokeMethod("dayOfWeek(const QDate&) const")]
		public virtual int DayOfWeek(QDate date) {
			return (int) interceptor.Invoke("dayOfWeek#", "dayOfWeek(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns the ISO week number for the given date.
		///  ISO 8601 defines the first week of the year as the week containing the first Thursday.
		///  See http://en.wikipedia.org/wiki/ISO_8601 and http://en.wikipedia.org/wiki/ISO_week_date
		///  If the date falls in the last week of the previous year or the first week of the following
		///  year, then the yearNum returned will be set to the appropriate year.
		/// <param> name="date" the date to obtain week from
		/// </param><param> name="yearNum" returns the year the date belongs to
		/// </param></remarks>		<return> ISO week number, -1 if input date invalid
		///      </return>
		/// 		<short>    Returns the ISO week number for the given date.</short>
		[SmokeMethod("weekNumber(const QDate&, int*) const")]
		public virtual int WeekNumber(QDate date, ref int yearNum) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(date);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(date);
#endif
			stack[2].s_int = yearNum;
			interceptor.Invoke("weekNumber#$", "weekNumber(const QDate&, int*) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			yearNum = stack[2].s_int;
			return stack[0].s_int;
		}
		[SmokeMethod("weekNumber(const QDate&) const")]
		public virtual int WeekNumber(QDate date) {
			return (int) interceptor.Invoke("weekNumber#", "weekNumber(const QDate&) const", typeof(int), typeof(QDate), date);
		}
		/// <remarks>
		///  Returns whether a given year is a leap year.
		///  Input year must be checked for validity in current Calendar System prior to calling, no
		///  validity checking performed in this routine, behaviour is undefined in invalid case.
		/// <param> name="year" the year to check
		/// </param></remarks>		<return> @c true if the year is a leap year, @c false otherwise
		///      </return>
		/// 		<short>    Returns whether a given year is a leap year.</short>
		[SmokeMethod("isLeapYear(int) const")]
		public abstract bool IsLeapYear(int year);
		/// <remarks>
		///  Returns whether a given date falls in a leap year.
		///  Input date must be checked for validity in current Calendar System prior to calling, no
		///  validity checking performed in this routine, behaviour is undefined in invalid case.
		/// <param> name="date" the date to check
		/// </param></remarks>		<return> @c true if the date falls in a leap year, @c false otherwise
		///      </return>
		/// 		<short>    Returns whether a given date falls in a leap year.</short>
		[SmokeMethod("isLeapYear(const QDate&) const")]
		public virtual bool IsLeapYear(QDate date) {
			return (bool) interceptor.Invoke("isLeapYear#", "isLeapYear(const QDate&) const", typeof(bool), typeof(QDate), date);
		}
		/// <remarks>
		///  Gets specific calendar type month name for a given month number
		///  If an invalid month is specified, string() is returned.
		/// <param> name="month" the month number
		/// </param><param> name="year" the year the month belongs to
		/// </param><param> name="format" specifies whether the short month name or long month name should be used
		/// </param></remarks>		<return> name of the month, empty string if any error
		///      </return>
		/// 		<short>    Gets specific calendar type month name for a given month number  If an invalid month is specified, string() is returned.</short>
		[SmokeMethod("monthName(int, int, KCalendarSystem::MonthNameFormat) const")]
		public abstract string MonthName(int month, int year, KCalendarSystem.MonthNameFormat format);
		/// <remarks>
		///  Gets specific calendar type month name for a given date
		/// <param> name="date" date to obtain month from
		/// </param><param> name="format" specifies whether the short month name or long month name should be used
		/// </param></remarks>		<return> name of the month, empty string if any error
		///      </return>
		/// 		<short>    Gets specific calendar type month name for a given date </short>
		[SmokeMethod("monthName(const QDate&, KCalendarSystem::MonthNameFormat) const")]
		public virtual string MonthName(QDate date, KCalendarSystem.MonthNameFormat format) {
			return (string) interceptor.Invoke("monthName#$", "monthName(const QDate&, KCalendarSystem::MonthNameFormat) const", typeof(string), typeof(QDate), date, typeof(KCalendarSystem.MonthNameFormat), format);
		}
		[SmokeMethod("monthName(const QDate&) const")]
		public virtual string MonthName(QDate date) {
			return (string) interceptor.Invoke("monthName#", "monthName(const QDate&) const", typeof(string), typeof(QDate), date);
		}
		/// <remarks>
		///  Gets specific calendar type week day name.
		///  If an invalid week day is specified, string() is returned.
		/// <param> name="weekDay" number of day in week (Monday = 1, ..., Sunday = 7)
		/// </param><param> name="format" specifies whether the short month name or long month name should be used
		/// </param></remarks>		<return> day name, empty string if any error
		///      </return>
		/// 		<short>    Gets specific calendar type week day name.</short>
		[SmokeMethod("weekDayName(int, KCalendarSystem::WeekDayNameFormat) const")]
		public abstract string WeekDayName(int weekDay, KCalendarSystem.WeekDayNameFormat format);
		/// <remarks>
		///  Gets specific calendar type week day name.
		/// <param> name="date" the date
		/// </param><param> name="format" specifies whether the short month name or long month name should be used
		/// </param></remarks>		<return> day name, empty string if any error
		///      </return>
		/// 		<short>    Gets specific calendar type week day name.</short>
		[SmokeMethod("weekDayName(const QDate&, KCalendarSystem::WeekDayNameFormat) const")]
		public virtual string WeekDayName(QDate date, KCalendarSystem.WeekDayNameFormat format) {
			return (string) interceptor.Invoke("weekDayName#$", "weekDayName(const QDate&, KCalendarSystem::WeekDayNameFormat) const", typeof(string), typeof(QDate), date, typeof(KCalendarSystem.WeekDayNameFormat), format);
		}
		[SmokeMethod("weekDayName(const QDate&) const")]
		public virtual string WeekDayName(QDate date) {
			return (string) interceptor.Invoke("weekDayName#", "weekDayName(const QDate&) const", typeof(string), typeof(QDate), date);
		}
		/// <remarks>
		///  Converts a date into a year literal
		/// <param> name="date" date to convert
		/// </param><param> name="format" format to return, either short or long
		/// </param></remarks>		<return> year literal of the date, empty string if any error
		///      </return>
		/// 		<short>    Converts a date into a year literal </short>
		[SmokeMethod("yearString(const QDate&, KCalendarSystem::StringFormat) const")]
		public virtual string YearString(QDate date, KCalendarSystem.StringFormat format) {
			return (string) interceptor.Invoke("yearString#$", "yearString(const QDate&, KCalendarSystem::StringFormat) const", typeof(string), typeof(QDate), date, typeof(KCalendarSystem.StringFormat), format);
		}
		[SmokeMethod("yearString(const QDate&) const")]
		public virtual string YearString(QDate date) {
			return (string) interceptor.Invoke("yearString#", "yearString(const QDate&) const", typeof(string), typeof(QDate), date);
		}
		/// <remarks>
		///  Converts a date into a month literal
		/// <param> name="pDate" The date to convert
		/// </param><param> name="format" The format to return, either short or long
		/// </param></remarks>		<return> The month literal of the date, empty string if any error
		///      </return>
		/// 		<short>    Converts a date into a month literal </short>
		[SmokeMethod("monthString(const QDate&, KCalendarSystem::StringFormat) const")]
		public virtual string MonthString(QDate pDate, KCalendarSystem.StringFormat format) {
			return (string) interceptor.Invoke("monthString#$", "monthString(const QDate&, KCalendarSystem::StringFormat) const", typeof(string), typeof(QDate), pDate, typeof(KCalendarSystem.StringFormat), format);
		}
		[SmokeMethod("monthString(const QDate&) const")]
		public virtual string MonthString(QDate pDate) {
			return (string) interceptor.Invoke("monthString#", "monthString(const QDate&) const", typeof(string), typeof(QDate), pDate);
		}
		/// <remarks>
		///  Converts a date into a day literal
		/// <param> name="pDate" The date to convert
		/// </param><param> name="format" The format to return, either short or long
		/// </param></remarks>		<return> The day literal of the date, empty string if any error
		///      </return>
		/// 		<short>    Converts a date into a day literal </short>
		[SmokeMethod("dayString(const QDate&, KCalendarSystem::StringFormat) const")]
		public virtual string DayString(QDate pDate, KCalendarSystem.StringFormat format) {
			return (string) interceptor.Invoke("dayString#$", "dayString(const QDate&, KCalendarSystem::StringFormat) const", typeof(string), typeof(QDate), pDate, typeof(KCalendarSystem.StringFormat), format);
		}
		[SmokeMethod("dayString(const QDate&) const")]
		public virtual string DayString(QDate pDate) {
			return (string) interceptor.Invoke("dayString#", "dayString(const QDate&) const", typeof(string), typeof(QDate), pDate);
		}
		/// <remarks>
		///  Converts a year literal of a part of a string into a integer starting at the beginning of the string
		/// <param> name="sNum" The string to parse
		/// </param><param> name="iLength" The number of chars used, and 0 if no valid symbols was found in the string
		/// </param></remarks>		<return> An integer corresponding to the year
		///      </return>
		/// 		<short>    Converts a year literal of a part of a string into a integer starting at the beginning of the string </short>
		[SmokeMethod("yearStringToInteger(const QString&, int&) const")]
		public virtual int YearStringToInteger(string sNum, ref int iLength) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(sNum);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(sNum);
#endif
			stack[2].s_int = iLength;
			interceptor.Invoke("yearStringToInteger$$", "yearStringToInteger(const QString&, int&) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			iLength = stack[2].s_int;
			return stack[0].s_int;
		}
		/// <remarks>
		///  Converts a month literal of a part of a string into a integer starting at the beginning of the string
		/// <param> name="sNum" The string to parse
		/// </param><param> name="iLength" The number of chars used, and 0 if no valid symbols was found in the string
		/// </param></remarks>		<return> An integer corresponding to the month
		///      </return>
		/// 		<short>    Converts a month literal of a part of a string into a integer starting at the beginning of the string </short>
		[SmokeMethod("monthStringToInteger(const QString&, int&) const")]
		public virtual int MonthStringToInteger(string sNum, ref int iLength) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(sNum);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(sNum);
#endif
			stack[2].s_int = iLength;
			interceptor.Invoke("monthStringToInteger$$", "monthStringToInteger(const QString&, int&) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			iLength = stack[2].s_int;
			return stack[0].s_int;
		}
		/// <remarks>
		///  Converts a day literal of a part of a string into a integer starting at the beginning of the string
		/// <param> name="sNum" The string to parse
		/// </param><param> name="iLength" The number of chars used, and 0 if no valid symbols was found in the string
		/// </param></remarks>		<return> An integer corresponding to the day
		///      </return>
		/// 		<short>    Converts a day literal of a part of a string into a integer starting at the beginning of the string </short>
		[SmokeMethod("dayStringToInteger(const QString&, int&) const")]
		public virtual int DayStringToInteger(string sNum, ref int iLength) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(sNum);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(sNum);
#endif
			stack[2].s_int = iLength;
			interceptor.Invoke("dayStringToInteger$$", "dayStringToInteger(const QString&, int&) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			iLength = stack[2].s_int;
			return stack[0].s_int;
		}
		/// <remarks>
		///  Returns a string formatted to the current locale's conventions
		///  regarding dates.
		///  Uses the calendar system's internal locale set when the instance was
		///  created, which ensures that the correct calendar system and locale
		///  settings are respected, which would not occur in some cases if using
		///  the global locale.  Defaults to global locale.
		/// <param> name="date" the date to be formatted
		/// </param><param> name="format" category of date format to use
		/// </param></remarks>		<return> The date as a string
		///      </return>
		/// 		<short>    Returns a string formatted to the current locale's conventions  regarding dates.</short>
		/// 		<see> KLocale.FormatDate</see>
		[SmokeMethod("formatDate(const QDate&, KLocale::DateFormat) const")]
		public virtual string FormatDate(QDate date, KLocale.DateFormat format) {
			return (string) interceptor.Invoke("formatDate#$", "formatDate(const QDate&, KLocale::DateFormat) const", typeof(string), typeof(QDate), date, typeof(KLocale.DateFormat), format);
		}
		[SmokeMethod("formatDate(const QDate&) const")]
		public virtual string FormatDate(QDate date) {
			return (string) interceptor.Invoke("formatDate#", "formatDate(const QDate&) const", typeof(string), typeof(QDate), date);
		}
		/// <remarks>
		///  Converts a localized date string to a QDate.
		///  The bool pointed by <code>ok</code> will be <code>false</code> if the date entered was invalid.
		///  Uses the calendar system's internal locale set when the instance was
		///  created, which ensures that the correct calendar system and locale
		///  settings are respected, which would not occur in some cases if using
		///  the global locale.  Defaults to global locale.
		/// <param> name="str" the string to convert
		/// </param><param> name="ok" if non-null, will be set to <code>true</code> if the date is valid, <code>false</code> if invalid
		/// </param></remarks>		<return> the string converted to a QDate
		///      </return>
		/// 		<short>    Converts a localized date string to a QDate.</short>
		/// 		<see> KLocale.ReadDate</see>
		[SmokeMethod("readDate(const QString&, bool*) const")]
		public virtual QDate ReadDate(string str, ref bool ok) {
			StackItem[] stack = new StackItem[3];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(str);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(str);
#endif
			stack[2].s_bool = ok;
			interceptor.Invoke("readDate$$", "readDate(const QString&, bool*) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			ok = stack[2].s_bool;
			object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
			((GCHandle) stack[0].s_class).Free();
#endif
			return (QDate) returnValue;
		}
		[SmokeMethod("readDate(const QString&) const")]
		public virtual QDate ReadDate(string str) {
			return (QDate) interceptor.Invoke("readDate$", "readDate(const QString&) const", typeof(QDate), typeof(string), str);
		}
		/// <remarks>
		///  Converts a localized date string to a QDate, using the specified <code>format.</code>
		///  You will usually not want to use this method.
		/// </remarks>		<short>    Converts a localized date string to a QDate, using the specified <code>format.</code></short>
		/// 		<see> KLocale.ReadDate</see>
		[SmokeMethod("readDate(const QString&, const QString&, bool*) const")]
		public virtual QDate ReadDate(string intstr, string format, ref bool ok) {
			StackItem[] stack = new StackItem[4];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(intstr);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(intstr);
#endif
#if DEBUG
			stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(format);
#else
			stack[2].s_class = (IntPtr) GCHandle.Alloc(format);
#endif
			stack[3].s_bool = ok;
			interceptor.Invoke("readDate$$$", "readDate(const QString&, const QString&, bool*) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
			((GCHandle) stack[2].s_class).Free();
#endif
			ok = stack[3].s_bool;
			object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
			((GCHandle) stack[0].s_class).Free();
#endif
			return (QDate) returnValue;
		}
		[SmokeMethod("readDate(const QString&, const QString&) const")]
		public virtual QDate ReadDate(string intstr, string format) {
			return (QDate) interceptor.Invoke("readDate$$", "readDate(const QString&, const QString&) const", typeof(QDate), typeof(string), intstr, typeof(string), format);
		}
		/// <remarks>
		///  Converts a localized date string to a QDate.
		///  This method is stricter than readDate(str,&ok): it will either accept
		///  a date in full format or a date in short format, depending on <code>flags.</code>
		///  Uses the calendar system's internal locale set when the instance was
		///  created, which ensures that the correct calendar system and locale
		///  settings are respected, which would not occur in some cases if using
		///  the global locale.  Defaults to global locale.
		/// <param> name="str" the string to convert
		/// </param><param> name="flags" whether the date string is to be in full format or in short format
		/// </param><param> name="ok" if non-null, will be set to <code>true</code> if the date is valid, <code>false</code> if invalid
		/// </param></remarks>		<return> the string converted to a QDate
		///      </return>
		/// 		<short>    Converts a localized date string to a QDate.</short>
		/// 		<see> KLocale.ReadDate</see>
		[SmokeMethod("readDate(const QString&, KLocale::ReadDateFlags, bool*) const")]
		public virtual QDate ReadDate(string str, KLocale.ReadDateFlags flags, ref bool ok) {
			StackItem[] stack = new StackItem[4];
#if DEBUG
			stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(str);
#else
			stack[1].s_class = (IntPtr) GCHandle.Alloc(str);
#endif
			stack[2].s_int = (int) flags;
			stack[3].s_bool = ok;
			interceptor.Invoke("readDate$$$", "readDate(const QString&, KLocale::ReadDateFlags, bool*) const", stack);
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
			((GCHandle) stack[1].s_class).Free();
#endif
			ok = stack[3].s_bool;
			object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
			DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
			((GCHandle) stack[0].s_class).Free();
#endif
			return (QDate) returnValue;
		}
		[SmokeMethod("readDate(const QString&, KLocale::ReadDateFlags) const")]
		public virtual QDate ReadDate(string str, KLocale.ReadDateFlags flags) {
			return (QDate) interceptor.Invoke("readDate$$", "readDate(const QString&, KLocale::ReadDateFlags) const", typeof(QDate), typeof(string), str, typeof(KLocale.ReadDateFlags), flags);
		}
		/// <remarks>
		///  Use this to determine which day is the first day of the week.
		///  Uses the calendar system's internal locale set when the instance was
		///  created, which ensures that the correct calendar system and locale
		///  settings are respected, which would not occur in some cases if using
		///  the global locale.  Defaults to global locale.
		/// </remarks>		<return> an integer (Monday = 1, ..., Sunday = 7)
		///      </return>
		/// 		<short>    Use this to determine which day is the first day of the week.</short>
		/// 		<see> KLocale.WeekStartDay</see>
		[SmokeMethod("weekStartDay() const")]
		public virtual int WeekStartDay() {
			return (int) interceptor.Invoke("weekStartDay", "weekStartDay() const", typeof(int));
		}
		/// <remarks>
		///  Gets the day of the week traditionally associated with prayer.
		/// </remarks>		<return> day number (Monday = 1, ..., Sunday = 7)
		///      </return>
		/// 		<short>    Gets the day of the week traditionally associated with prayer.</short>
		[SmokeMethod("weekDayOfPray() const")]
		public abstract int WeekDayOfPray();
		/// <remarks>
		///  Returns whether the calendar is lunar based.
		/// </remarks>		<return> @c true if the calendar is lunar based, @c false if not
		///      </return>
		/// 		<short>    Returns whether the calendar is lunar based.</short>
		[SmokeMethod("isLunar() const")]
		public abstract bool IsLunar();
		/// <remarks>
		///  Returns whether the calendar is lunisolar based.
		/// </remarks>		<return> @c true if the calendar is lunisolar based, @c false if not
		///      </return>
		/// 		<short>    Returns whether the calendar is lunisolar based.</short>
		[SmokeMethod("isLunisolar() const")]
		public abstract bool IsLunisolar();
		/// <remarks>
		///  Returns whether the calendar is solar based.
		/// </remarks>		<return> @c true if the calendar is solar based, @c false if not
		///      </return>
		/// 		<short>    Returns whether the calendar is solar based.</short>
		[SmokeMethod("isSolar() const")]
		public abstract bool IsSolar();
		/// <remarks>
		///  Returns whether the calendar system is proleptic, i.e. whether dates
		///  before the epoch are supported.
		/// </remarks>		<return> @c true if the calendar system is proleptic, @c false if not
		///      </return>
		/// 		<short>    Returns whether the calendar system is proleptic, i.</short>
		/// 		<see> KCalendarSystem.Epoch</see>
		[SmokeMethod("isProleptic() const")]
		public abstract bool IsProleptic();
		/// <remarks>
		///  Internal method to convert a Julian Day number into the YMD values for
		///  this calendar system.
		///  All calendar system implementations MUST implement julianDayToDate and
		///  dateToJulianDay methods as all other methods can be expressed as
		///  functions of these.  Does no internal validity checking.
		/// <param> name="jd" Julian day number to convert to date
		/// </param><param> name="year" year number returned in this variable
		/// </param><param> name="month" month number returned in this variable
		/// </param><param> name="day" day of month returned in this variable
		/// </param></remarks>		<return> @c true if the date is valid, @c false otherwise
		///      </return>
		/// 		<short>    Internal method to convert a Julian Day number into the YMD values for  this calendar system.</short>
		/// 		<see> KCalendarSystem.DateToJulianDay</see>
		[SmokeMethod("julianDayToDate(int, int&, int&, int&) const")]
		protected abstract bool JulianDayToDate(int jd, ref int year, ref int month, ref int day);
		/// <remarks>
		///  Internal method to convert YMD values for this calendar system into a
		///  Julian Day number.
		///  All calendar system implementations MUST implement julianDayToDate and
		///  dateToJulianDay methods as all other methods can be expressed as
		///  functions of these.  Does no internal validity checking.
		/// <param> name="year" year number
		/// </param><param> name="month" month number
		/// </param><param> name="day" day of month
		/// </param><param> name="jd" Julian day number returned in this variable
		/// </param></remarks>		<return> @c true if the date is valid, @c false otherwise
		///      </return>
		/// 		<short>    Internal method to convert YMD values for this calendar system into a  Julian Day number.</short>
		/// 		<see> KCalendarSystem.JulianDayToDate</see>
		[SmokeMethod("dateToJulianDay(int, int, int, int&) const")]
		protected abstract bool DateToJulianDay(int year, int month, int day, ref int jd);
		/// <remarks>
		///  Returns the locale used for translations and formats for this 
		///  calendar system instance.  This allows a calendar system instance to be
		///  independent of the global translations and formats if required.  All 
		///  implementations must refer to this locale.
		///  Only for internal calendar system use; if public access is required then
		///  provide public methods only for those methods actually required.  Any
		///  app that creates an instance with its own locale overriding global will
		///  have the original handle to the locale and can manipulate it that way if
		///  required, e.g. to change default date format.  Only expose those methods
		///  that library widgets require access to internally.
		/// </remarks>		<return> locale to use
		///      </return>
		/// 		<short>    Returns the locale used for translations and formats for this   calendar system instance.</short>
		/// 		<see> KCalendarSystem.FormatDate</see>
		/// 		<see> KLocale.FormatDate</see>
		/// 		<see> KCalendarSystem.WeekStartDay</see>
		/// 		<see> KLocale.WeekStartDay</see>
		/// 		<see> KCalendarSystem.ReadDate</see>
		/// 		<see> KLoacle.ReadDate</see>
		protected KLocale Locale() {
			return (KLocale) interceptor.Invoke("locale", "locale() const", typeof(KLocale));
		}
		/// <remarks>
		///  Creates specific calendar type
		/// <param> name="calType" string identification of the specific calendar type
		///  to be constructed
		/// </param><param> name="locale" locale to use for translations. The global locale is used if null.
		/// </param></remarks>		<return> a KCalendarSystem object
		///      </return>
		/// 		<short>    Creates specific calendar type </short>
		public static KCalendarSystem Create(string calType, KLocale locale) {
			return (KCalendarSystem) staticInterceptor.Invoke("create$#", "create(const QString&, const KLocale*)", typeof(KCalendarSystem), typeof(string), calType, typeof(KLocale), locale);
		}
		public static KCalendarSystem Create(string calType) {
			return (KCalendarSystem) staticInterceptor.Invoke("create$", "create(const QString&)", typeof(KCalendarSystem), typeof(string), calType);
		}
		public static KCalendarSystem Create() {
			return (KCalendarSystem) staticInterceptor.Invoke("create", "create()", typeof(KCalendarSystem));
		}
		/// <remarks>
		///  Gets a list of names of supported calendar systems.
		/// </remarks>		<return> list of names
		///      </return>
		/// 		<short>    Gets a list of names of supported calendar systems.</short>
		public static List<string> CalendarSystems() {
			return (List<string>) staticInterceptor.Invoke("calendarSystems", "calendarSystems()", typeof(List<string>));
		}
		/// <remarks>
		///  Returns a typographically correct and translated label to display for
		///  the calendar system type.  Use with calendarSystems() to neatly
		///  format labels to display on combo widget of available calendar systems.
		/// <param> name="calendarType" the specific calendar type to return the label for
		/// </param></remarks>		<return> label for calendar
		///      </return>
		/// 		<short>    Returns a typographically correct and translated label to display for  the calendar system type.</short>
		public static string CalendarLabel(string calendarType) {
			return (string) staticInterceptor.Invoke("calendarLabel$", "calendarLabel(const QString&)", typeof(string), typeof(string), calendarType);
		}
	}
}
