/***************************************************************************
 *                                                                         *
 *   copyright (C) 2005 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD2_H_
#define PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD2_H_

#include "masterkey/smartkey/smartkey_backend.h"

#include <chipcard2/chipcard2.h>
#include <chipcard2-client/client/client.h>
#include <chipcard2-client/cards/memorycard.h>

#include <qcstring.h>


class Chipcard2Interface : public ChipcardInterface
{
public:
	Chipcard2Interface();
	virtual ~Chipcard2Interface() { }

	/** write data to the card. */
	virtual SmartKey_backend::Status write(const QByteArray &data);
	/** read data from the card. */
	virtual SmartKey_backend::Status read(QByteArray *data);
	/** erase the card. */
	virtual SmartKey_backend::Status erase();

protected:
	/** Open the card. */
	SmartKey_backend::Status ct_open();
	/** Close the card. */
	void ct_close();
	/** Write data to the card (must be open). */
	SmartKey_backend::Status ct_write(const QByteArray &data);
	/** Read data from the card (must be open). */
	SmartKey_backend::Status ct_read(QByteArray *data);
	/** Erase the card (must be open). */
	SmartKey_backend::Status ct_erase();

protected:
	/** Pointer to the client. */
	LC_CLIENT *client;
	/** Pointer to the chipcard. */
	LC_CARD *card;
};

#endif // PWMANAGER_MASTERKEY_SMARTKEY_CHIPCARD2_H_
