/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef PWMANAGER_MASTERKEY_H_
#define PWMANAGER_MASTERKEY_H_

#include "globalstuff.h"

#include <qcstring.h>

class QWidget;

class MasterKey
{
public:
	enum Type
	{
		/** No type set. */
		type_none	= 0xFF00,
		/** Type is OK. Everything went OK. */
		type_ok		= 0xFF01,
		/** Type not supported by the implementation. */
		type_notimpl	= 0xFF02,

		/** Password string. */
		type_password	= 0x00,
		/** Smartcard. */
		type_smartcard	= 0x01,
		/** Key-File. */
		type_keyfile	= 0x02 //XXX: This is not supported, yet.
	};

public:
	MasterKey(QWidget *_parent);
	~MasterKey();

	/** Returns the Type for an unsigned char type number. */
	static Type castType(unsigned char type)
			{ return (static_cast<Type>(type)); }
	/** Returns the unsigned char type number for a Type. */
	static unsigned char castType(Type type)
			{ return (static_cast<unsigned char>(type)); }

	/** Request a new Master Key from the user.
	  * @param key Buffer for the new key.
	  * @param type The type to request. If this is type_none,
	  *             every type is allowed.
	  * @return Returns the type of the new key, or type_none
	  *         if the user cancelled.
	  */
	Type requestNewKey(QByteArray *key, Type type = type_none);
	Type requestNewKey(QString *key, Type type = type_none);

	/** Request a Master Key from the user.
	  * @param type The type of Key to request from the user.
	  * @param key Buffer for the entered key.
	  * @return Returns type_ok, if everything went ok.
	  *         Returns type_none, if the user cancelled.
	  *         Returns type_notimpl, if this type is not
	  *         supported by the current implementation.
	  */
	Type requestKey(QByteArray *key, Type type);
	Type requestKey(QString *key, Type type);

	/** Display a "wrong master key" message. */
	void wrongKeyMsg(Type type);

protected:
#ifdef CONFIG_PWMANAGER_SMARTCARD
	Type requestSmartkey(QByteArray *key);
#endif
	Type requestPassword(QByteArray *key);
	Type requestKeyfile(QByteArray *key);

protected:
	/** Parent widget. */
	QWidget *parent;
};

#endif // PWMANAGER_MASTERKEY_H_
