/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSTREEWIDGET_H
#define DBUSTREEWIDGET_H

#include <qvbox.h>
#include <qwidgetstack.h>
#include <memory>

#include <dbus/dbus.h>

#include "dbus/qdbusproxy.h"
#include "dbus/qdbusconnection.h"
#include "dbusserviceenumerator.h"
#include "dbusdispatcher.h"
#include "dbusexceptions.h"

class KStatusBar;
class KListView;
class QListViewItem;
class QSplitter;
class kdbus;

/**
 * Main widget holding most of kdbus.
 * Specific to one particular bus (i.e. session or system)
 */
class DBusTreeWidget : public QVBox {
Q_OBJECT
public:
    /**
     * @param type bus type
     */
    DBusTreeWidget( kdbus * parent, QDBusConnection::BusType const & type );

    ~DBusTreeWidget();

    /**
     * @returns DBusDispatcher for this DBusTreeWidget
     */
    DBusDispatcher * dispatcher();

    /**
     * Set status bar to @a message and output with kdDebug also.
     * @param message message to output
     */
    void statusMessage( QString const & message );

    /**
     * @return KListView holding DBusItem objects
     */
    KListView * listView();

    /**
     * Reload all D-BUS items.
     */
    void reload();

private slots:
    /**
     * Delayed initialisation.
     */
    void initObjects();

    /**
     * Called when a DBus signal is emitted.
     */
    void dbusSignal( QDBusMessage const & message );
    /**
     * Called when selected DBusItem changes.
     */
    void selectionChanged();

    void resizeSplitter();

private:
    class Private; Private * d;

    /// Not implemented.
    DBusTreeWidget( DBusTreeWidget const & other );

    /// Not implemented.
    const DBusTreeWidget & operator=( DBusTreeWidget const & other );
};

#endif
