/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSPROPERTY_H
#define DBUSPROPERTY_H

#include <qstring.h>

#include "dbusannotatable.h"
#include "dbusexceptions.h"

/**
 * Representation of a D-BUS property.
 */
class DBusProperty
 : public DBusAnnotatable
{
public:
    /**
     * @param parent parent QListViewItem
     * @param elem   XML element representing this property
     */
    DBusProperty(
      QListViewItem * parent,
      QDomElement const & elem
    ) throw( QDBusXmlError );

    ~DBusProperty();

    /**
     * @return name of this property.
     */
    QString name() const;

    /**
     * @return true if this property can be read, false otherwise
     */
    bool canRead() const;

    /**
     * @return true if this property can be written to, false otherwise
     */
    bool canWrite() const;

    /**
     * @return access modifier on this property ('read', 'write', 'readwrite' )
     */
    QString access() const;

    /**
     * @return D-BUS type string of this property.
     */
    QString type() const;

    /**
     * @return human-readable type string of this property.
     */
    QString niceType() const;

    /**
     * @see DBusItem::widget
     */
    QWidget * widget( QWidget * parent ) const;

protected:
    QString m_name;
    QString m_access;
    QString m_type;
    QString m_niceType;

private:
    class Private; Private * d;

    /// Not implemented.
    DBusProperty( DBusProperty const & other );

    /// Not implemented.
    const DBusProperty & operator=( DBusProperty const & other);
};

#endif
