/***************************************************************************
*   Copyright (C) 2001-2005 by Javier Campos Morales & the Kconfigure team *
*   kconfigure@rockerssoft.com                                             *
*                                                                          *
*   This program is free software; you can redistribute it and/or modify   *
*   it under the terms of the GNU General Public License as published by   *
*   the Free Software Foundation; either version 2 of the License, or      *
*   (at your option) any later version.                                    *
*                                                                          *
*   This program is distributed in the hope that it will be useful,        *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
*   GNU General Public License for more details.                           *
*                                                                          *
*   You should have received a copy of the GNU General Public License      *
*   along with this program; if not, write to the                          *
*   Free Software Foundation, Inc.,                                        *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include "kconfigure.h"

static const char *description =
	I18N_NOOP("Build and install software from source.");

static KCmdLineOptions options[] =
{
	{ "+file",          I18N_NOOP("File to load"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "kconfigure", I18N_NOOP("Kconfigure"),
    "2.0", description, KAboutData::License_GPL,
    I18N_NOOP("(c) 2001-2005 Javier Campos Morales & the Kconfigure team"), 0,
    "http://kconfigure.sourceforge.net/", "kconfigure@rockerssoft.com" );
  aboutData.addAuthor("Javier Campos Morales",0, "javi_cms@terra.es");
  aboutData.addAuthor("Robert Rockers",0, "kconfigure@rockerssoft.com");
  aboutData.addAuthor("Micheal D. Moery",0, "Valen999@rockerssoft.com");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  Kconfigure *kconfigure = new Kconfigure();
  a.setMainWidget(kconfigure);
  kconfigure->show();

	if ( args->count() > 0 )
	{	kconfigure->openURL( args->url(0) ); }

	args->clear();

  return a.exec();
}
