//
// C++ Implementation: searcherconfigdlg
//
// Description:
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "searcherconfigdlg.h"
#include "searcherconfigwidget.h"
#include "searchmanager.h"
#include "z3950searcher.h"
#include "srusearcher.h"
#include "entrezsearcher.h"
#include "ieeexploresearcher.h"
#include "woksearcher.h"

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kiconloader.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qhgroupbox.h>
#include <qwidgetstack.h>
#include <qwhatsthis.h>
#include <qhbox.h>
#include <qvgroupbox.h>
#include <qcombobox.h>

SearcherConfigDlg::SearcherConfigDlg(QWidget* parent_)
        : KDialogBase(parent_, "fetcher dialog", true, i18n("Data Source Properties"),
                      KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Help)
        , m_newSource(true)
        , m_useDefaultName(true)
        , m_configWidget(0)
{
    init(Unknown);
}


SearcherConfigDlg::SearcherConfigDlg(const QString& sourceName_, Type type_, SearcherConfigWidget* configWidget_,
                                     QWidget* parent_)
        : KDialogBase(parent_, "Searcher dialog", true, i18n("Data Source Properties"),
                      KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Help)
        , m_newSource(false)
        , m_useDefaultName(false)
        , m_configWidget(configWidget_)
{
    init(type_);
    m_nameEdit->setText(sourceName_);
}



SearcherConfigDlg::~SearcherConfigDlg()
{
    if (m_configWidget)
        delete m_configWidget;
}


void SearcherConfigDlg::init(Type type_)
{
    widget = new QWidget(this);
    QBoxLayout* topLayout = new QHBoxLayout(widget, KDialog::spacingHint());

    QBoxLayout* vlay1 = new QVBoxLayout(topLayout, KDialog::spacingHint());
    QLabel* icon = new QLabel(widget);
    icon->setPixmap(KGlobal::iconLoader()->loadIcon(QString::fromLatin1("network"), KIcon::Panel, 64));
    vlay1->addWidget(icon);
    vlay1->addStretch(1);

    vlay2 = new QVBoxLayout(topLayout, KDialog::spacingHint());

    QGridLayout* gl = new QGridLayout(vlay2, 2, 2, KDialog::spacingHint());
    int row = -1;

    QLabel* label = new QLabel(i18n("&Source name: "), widget);
    gl->addWidget(label, ++row, 0);
    QString w = i18n("The name identifies the data source and should be unique and informative.");
    QWhatsThis::add(label, w);

    m_nameEdit = new KLineEdit(widget);
    gl->addWidget(m_nameEdit, row, 1);
    m_nameEdit->setFocus();
    QWhatsThis::add(m_nameEdit, w);
    label->setBuddy(m_nameEdit);

    if(m_newSource)
    {
        label = new QLabel(i18n("Source &type: "), widget);
    }
    else
    {
        // since the label doesn't have a buddy, we don't want an accel,
        // but also want to reuse string we already have
        label = new QLabel(i18n("Source &type: ").remove('&'), widget);
    }
    gl->addWidget(label, ++row, 0);
    w = i18n("KBib supports several different data sources.");
    QWhatsThis::add(label, w);

    if(m_newSource)
    {
        m_typeCombo = new QComboBox(widget);
        gl->addWidget(m_typeCombo, row, 1);
        QWhatsThis::add(m_typeCombo, w);
        label->setBuddy(m_typeCombo);
    }
    else
    {
        m_typeCombo = 0;
        QLabel* lab = new QLabel(searchManager::typeName(type_), widget);
        gl->addWidget(lab, row, 1);
        QWhatsThis::add(lab, w);
    }

    if(m_newSource)
    {
        connect(m_typeCombo, SIGNAL(activated(const QString&)), SLOT(slotNewSourceSelected(const QString&)));
        const SearchMap searchMap = searchManager::sourceMap();
        for(SearchMap::ConstIterator it = searchMap.begin(); it != searchMap.end(); ++it)
        {
            m_typeCombo->insertItem(it.data());
        }
        currentType = Unknown;
        // make sure first widget gets initialized
        m_typeCombo->setCurrentItem(0);
        slotNewSourceSelected(m_typeCombo->currentText());

    }
    else
    {
        // just add config widget and reparent
        m_configWidget->reparent(widget, QPoint());
        vlay2->addWidget(m_configWidget);
        //		connect(m_configWidget, SIGNAL(signalName(const QString&)), SLOT(slotPossibleNewName(const QString&)));
    }

    setMainWidget(widget);
}

QString SearcherConfigDlg::sourceName()
{
    return (m_nameEdit->text()).stripWhiteSpace();
}


Type SearcherConfigDlg::sourceType() const
{
    if(!m_newSource)
    {
        return Unknown;
    }

    const SearchMap searchMap = searchManager::sourceMap();
    for(SearchMap::ConstIterator it = searchMap.begin(); it != searchMap.end(); ++it)
    {
        if(it.data() == m_typeCombo->currentText())
        {
            return it.key();
        }
    }
    return Unknown;
}

void SearcherConfigDlg::slotNewSourceSelected(const QString& type_)
{
    if(!m_newSource)
    {
        return;
    }

    const SearchMap searchMap = searchManager::sourceMap();
    Type newType;
    for(SearchMap::ConstIterator it = searchMap.begin(); it != searchMap.end(); ++it)
    {
        if(it.data() == type_)
        {
            newType = it.key();
            break;
        }
    }

    if (newType == currentType)
        return;

    if (m_configWidget)
    {
        vlay2->remove(m_configWidget);
        delete m_configWidget;
    }
    //Z3950ConfigWidget *z3950Cw=0;
    //EntrezConfigWidget *entrezCw=0;
    switch(newType)
    {
    case Z3950:
        {
            Z3950ConfigWidget* z3950Cw = new Z3950ConfigWidget(widget, 0);
            m_configWidget = z3950Cw;
        }
        break;
    case SRU:
        {
            SRUConfigWidget* sruCw = new SRUConfigWidget(widget, 0);
            m_configWidget = sruCw;
        }
        break;
    case Entrez:
        {
            EntrezConfigWidget* entrezCw = new EntrezConfigWidget(widget, 0);
            m_configWidget = entrezCw;
        }
        break;
    case IEEEXplore:
        {
            IEEEXploreConfigWidget *IEEEXploreCw = new IEEEXploreConfigWidget(widget, 0);
            m_configWidget = IEEEXploreCw;
        }
        break;
    case WOK:
        {
            WOKConfigWidget *WOKCw = new WOKConfigWidget(widget, 0);
            m_configWidget = WOKCw;
        }
        break;
		
	default:
        return;
    }
    currentType = newType;
    m_configWidget->show();
    //	cw->reparent(widget, QPoint());
    vlay2->addWidget(m_configWidget);
    //	m_stack->raiseWidget(cw);


}
#include "searcherconfigdlg.moc"
