//
// C++ Implementation: linefieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "linefieldwidget.h"

#include <qlayout.h>
#include <klineedit.h>
#include <qcheckbox.h>
#include <kpushbutton.h>
#include <kdialog.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qwhatsthis.h>
#include <qtooltip.h>

namespace GUI {

LineFieldWidget::LineFieldWidget(QString _name, RefField* field,  QStringList macroKeys, QWidget *parent, const char *name)
 : FieldWidget(parent, name)
{
	m_field = field;
	m_name = _name;
	QHBoxLayout* l = new QHBoxLayout(this, 0, KDialog::spacingHint()); 
	QString fn = m_name.lower();
	QChar c = fn.at(0); 
	fn = fn.replace(0, 1, c.upper());
	
	m_label = new QLabel(fn+QString::fromLatin1(":"), this);
	m_lineEdit = new KLineEdit(this);
	QString msg = i18n("Enter the value of the %1 field here. %2 is a single line text field").arg(m_name.lower()).arg(fn);
	QWhatsThis::add ( m_lineEdit, msg );
	QToolTip::add ( m_lineEdit, msg );
	
	m_label->setBuddy(m_lineEdit);
	m_stringMacroIndicator = new QCheckBox(i18n("As String Macro"), this);
	msg = i18n("When checked, the value of the %1 field is a string macro key.").arg(m_name.lower());
	QWhatsThis::add ( m_stringMacroIndicator, msg );
	QToolTip::add( m_stringMacroIndicator, msg );
	
	m_stringMacroSelect = new KPushButton(i18n("Macros"), this);	
	msg = i18n("Set the %1 field to use one of the defined string macro keys.").arg(m_name.lower());
	QWhatsThis::add ( m_stringMacroSelect, msg );
	QToolTip::add ( m_stringMacroSelect, msg );
	l->addWidget(m_label);
	l->addWidget(m_lineEdit);
	l->addWidget(m_stringMacroIndicator);
	l->addWidget(m_stringMacroSelect);
	
	m_stringMacroMenu = new KPopupMenu(this);
	m_stringMacroSelect->setPopup(m_stringMacroMenu);
	
	for ( QStringList::Iterator it = macroKeys.begin(); it != macroKeys.end(); ++it ) {
        m_stringMacroMenu->insertItem(*it);
    }
	
	if (m_stringMacroMenu->count () > 0)
		 m_stringMacroSelect->show();
	else
		m_stringMacroSelect->hide();
	connect(m_stringMacroMenu, SIGNAL(activated(int)),
			this, SLOT(slotMacroMenuActivated(int)));
	
}


LineFieldWidget::~LineFieldWidget()
{
}

void LineFieldWidget::setText(QString st)
{
	m_lineEdit->setText(st.simplifyWhiteSpace());	
	m_lineEdit->setCursorPosition(0);
	
}


QString LineFieldWidget::getText(void){
	return (m_lineEdit->text()).simplifyWhiteSpace();
}

void LineFieldWidget::slotMacroMenuActivated(int id){
	m_lineEdit->setText(m_stringMacroMenu->text(id));
	m_stringMacroIndicator->setChecked(true);	
	m_lineEdit->setFocus ();
}

void LineFieldWidget::setAutoCompletion(QStringList list){
	if (!m_field)
		return;
	if (!m_field->autoCompletion)
		return;
	
	KCompletion* completion = new KCompletion();
    completion->setItems(list);
    completion->setIgnoreCase(true);
    m_lineEdit->setCompletionObject(completion);
    m_lineEdit->setAutoDeleteCompletionObject(true);
}

}
#include "linefieldwidget.moc"
