/***************************************************************************
                          kbibinsertfiledlg  -  description
                             -------------------
    begin                : Tue Apr 13 2004
    copyright            : (C) 2004 by Thach Nguyen
    email                : thach@dragon.thach.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbibinsertfiledlg.h"
#include <kiconloader.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurlcompletion.h>
#include <klineedit.h>
#include <qlayout.h>
#include <qhbox.h>
#include <klocale.h>
#include <qwhatsthis.h>

KbibInsertFileDlg::KbibInsertFileDlg ( QWidget *parent, const char *name )
		:KDialogBase ( parent, name , true, i18n ( "Insert File" ), KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false )
{
	QWidget* page = new QWidget ( this );
	setMainWidget ( page );
	QVBoxLayout* l = new QVBoxLayout ( page, 0, KDialog::spacingHint() );



	QHBox* box1 = new QHBox ( page );
	box1->setSpacing ( KDialog::spacingHint() );

	QLabel *fileNameLabel = new QLabel ( "File name:", box1 );

	m_requester = new KURLRequester ( box1 );
	QWhatsThis::add ( m_requester, i18n ( "Enter the to be inserted here." ) );

	fileNameLabel->setBuddy ( m_requester );

	m_requester->lineEdit()->setCompletionObject ( new KURLCompletion() );
	m_requester->lineEdit()->setAutoDeleteCompletionObject ( true );



	l->addWidget ( box1 );

	QHBox* box2 = new QHBox ( page );
	box2->setSpacing ( KDialog::spacingHint() );

	QLabel *fileTypeLabel=  new QLabel ( "File format:", box2 );

	int width;
	if (fileNameLabel->sizeHint().width() > fileTypeLabel->sizeHint().width())
		width = fileNameLabel->sizeHint().width();
	else
		width = fileTypeLabel->sizeHint().width();
	fileNameLabel->setFixedWidth(width);
	fileTypeLabel->setFixedWidth(width);
	
	fileType = new KComboBox ( false, box2 );
	fileType->insertItem ( "BibTex", -1 );
	fileType->insertItem ( "Endnote exported BibTex", -1 );
	fileType->insertItem ( "Endnote/Refer", -1 );
	fileType->insertItem ( "RIS", -1 );
	fileType->insertItem ( "ISI", -1 );
	fileType->insertItem ( "Pubmed XML", -1 );
	fileType->insertItem ( "COPAC", -1 );
	fileType->insertItem ( "MODS XML", -1 );

	box2->setStretchFactor ( fileTypeLabel, 0 );
	box2->setStretchFactor ( fileType, 1 );


	l->addWidget ( box2 );
	
	m_optionBox = new QVGroupBox(i18n("Import Options"), page);
    l->addWidget(m_optionBox);
	
	noImportExisting = new QCheckBox ( i18n ( "Do not import duplicated references" ), m_optionBox );
	noImportExisting->setChecked ( TRUE );
	QWhatsThis::add(noImportExisting, i18n("If this option is selected, duplicated references will not be imported.") );
	
	m_importNewFile = new QRadioButton(i18n("Import into new document"), m_optionBox);
	QWhatsThis::add(m_importNewFile, i18n("Select this option to close the current document import into a new document.") );
	
	m_importIntoExisting = new QRadioButton(i18n("Import into current document"), m_optionBox);
	QWhatsThis::add(m_importIntoExisting, i18n("Select this option to import into the currrent document.") );

	m_importNewFile->setChecked(false);
	m_importIntoExisting->setChecked(true);
	
	m_buttonGroup = new QButtonGroup(page);
	m_buttonGroup->hide();
    m_buttonGroup->insert(m_importNewFile);
    m_buttonGroup->insert(m_importIntoExisting);
	
	l->addStretch(1);
	
	QString filter = i18n ( "*.bib|BibTex files (*.bib)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*.end|Endnote files (*.end)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*.ris|RIS files (*.ris)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*.isi|ISI files (*.isi)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*.xml|XML files (*.xml)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*.txt|Text files (*.txt)" );
	filter += QString::fromLatin1 ( "\n" );
	filter += i18n ( "*|All files" );
	m_requester->setFilter ( filter );

	connect ( m_requester, SIGNAL ( urlSelected ( const QString& ) ), this, SLOT ( slotURLChanged ( const QString& ) ) );

}


KbibInsertFileDlg::~KbibInsertFileDlg()
{
}

QString KbibInsertFileDlg::getFileName()
{
	return ( m_requester->lineEdit()->text() );

}

int KbibInsertFileDlg::getFileType()
{
	return fileType->currentItem();
}

bool KbibInsertFileDlg::getNotInsertExisting()
{
	return noImportExisting->isChecked();
}





void KbibInsertFileDlg::slotURLChanged ( const QString&  fn )
{
	if ( fn.contains ( ".bib" ) )
		fileType->setCurrentItem ( 0 );
	else if ( fn.contains ( ".end" ) )
		fileType->setCurrentItem ( 2 );
	else if ( fn.contains ( ".ris" ) )
		fileType->setCurrentItem ( 3 );
	else if ( fn.contains ( ".isi" ) )
		fileType->setCurrentItem ( 4 );
	else if ( fn.contains ( ".xml" ) )
		fileType->setCurrentItem ( 7 );
}

#include "kbibinsertfiledlg.moc"
