/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include "katxattr.h"

#ifdef HAVE_ATTR_H

#include <sys/types.h>
#include <attr/xattr.h>

#include <cstdlib>

#include <kdebug.h>

bool KatExtendedAttr::testExtendedAttribute( const QString& path )
{
    if ( !path.isEmpty() &&
          ( lsetxattr ( path.latin1(), "user.kat.test", "catalog", 8, 0 ) != -1 ) )
    {
        lremovexattr ( path.latin1(), "user.kat.test" );
        return true;
    }
    else
        return false;
}

bool KatExtendedAttr::setExtendedAttribute( const QString &path, QString name, const QString &value )
{
    name.prepend ( "user.kat." );
    if ( lsetxattr ( path.latin1(), name.latin1(), value.latin1(), value.length(), 0 ) == -1 )
    {
        kdDebug() << "Could not set extended attribute " << name.latin1() << " for " << path << endl;
        return false;
    }
    else
        return true;
}

QString KatExtendedAttr::getStringExtendedAttribute( const QString &path, QString name )
{
    QString value = QString::null;
    char *svalue;

    name.prepend ( "user.kat." );
    // Use extended attribute
    ssize_t size = lgetxattr ( path.latin1(), name.latin1(), NULL, 0);
    if ( size != -1)
    {
        svalue = new char[size];
        if ( lgetxattr ( path.latin1(), name.latin1(), svalue, size) != -1 )
            value = QString(svalue);
        delete svalue;
        svalue = 0;
    }

    return value;
}

long KatExtendedAttr::getIntExtendedAttribute( const QString &path, QString name )
{
    long value = 0;
    char *svalue;

    name.prepend ( "user.kat." );
    // Use extended attribute
    ssize_t size = lgetxattr ( path.latin1(), name.latin1(), NULL, 0);
    if ( size != -1)
    {
        svalue = new char[size];
        if ( lgetxattr ( path.latin1(), name.latin1(), svalue, size) != -1 )
            value = atol ( svalue );
        delete svalue;
        svalue = 0;
    }

    return value;
}

bool KatExtendedAttr::removeExtendedAttribute( const QString &path, QString name )
{
    name.prepend ( "user.kat." );
    if ( lremovexattr ( path.latin1(), name.latin1() ) == -1 )
    {
        kdDebug() << "Could not remove extended attribute " << name.latin1() << " for " << path << endl;
        return false;
    }
    else
        return true;
}

#endif // HAVE_ATTR_H

