/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATINFORMATION_H_
#define _KATINFORMATION_H_

#include <time.h>
#include <kio/job.h>
#include <qstring.h>
#include <qcstring.h>

#include "kat_export.h"

class KAT_EXPORT KatInformation
{

public:
    enum Type {
        FileInfo    = 0x01,
        Thumbnail   = 0x02,
        MetaData    = 0x04,
        FullText    = 0x08,

        All         = FileInfo | Thumbnail | MetaData | FullText
    };

public:
    KatInformation();
    virtual ~KatInformation();

    Type type;
    int fileId;
    int catalogId;
    QString fullName;
    QString fileName;
    int parentId;
    QString fileType;
    time_t statusChangeDate;
    time_t modificationDate;
    time_t lastAccessDate;
    time_t lastUpdateDate;
    KIO::filesize_t fileSize;
    QString language;
    QByteArray thumbnailData;
    int thumbnailDataLength;
    QString metaData;
    QString fullText;
    bool hasThumbnail;
    bool hasMetaData;
    bool hasFullText;
};

#endif // _KATINFORMATION_H_
