/***************************************************************************
 *   Copyright (C) 2005 by Laurent Montel <montel@kde.org>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kdebug.h>

#include "katprocessmanager.h"
#include <qregexp.h>

KatExternalExtractor::KatExternalExtractor( const QString &path, bool htmlOutput ) :
    m_bDone( false ),
    m_bHtmlOutput( htmlOutput ),
    m_path( path )
{
}

KatExternalExtractor::~KatExternalExtractor()
{
    delete proc;
    proc = 0;
    delete kpm;
    kpm = 0;
}

void KatExternalExtractor::extract( QString& data )
{
    kdDebug() << "KatExternalExtractor start" << endl;
    if ( m_bDone ) {
        data = QString::null;
        return;
    }
    m_bDone = true;

    proc = new KProcess();
    kpm = new KatProcessManager();

    QString helperApp = helper();
    //add proc parameter.
    helperParameter( helperApp );

    QObject::connect( proc, SIGNAL( processExited( KProcess* ) ),
                      kpm, SLOT( slotProcessExited( KProcess* ) ) );
    QObject::connect( proc, SIGNAL( receivedStdout( KProcess*, char*, int ) ),
                      kpm, SLOT( slotReceivedStdout( KProcess*, char*, int ) ) );

    QString d = QString::null;

    if ( !proc->start( KProcess::Block, KProcess::Communication( KProcess::Stdout ) ) )
        kdDebug() << "ERROR: Unable to find helper program " << helperApp << endl;
    else
    {
        if ( m_bHtmlOutput )
        {
            d = kpm->buffer();
            d = d.replace( QRegExp( "<br>" ), "\n" ); // transform all <br> in \n
            d = d.replace( QRegExp( "<[^>]*>" ), " " ); // strip all HTML tags
            d = d.simplifyWhiteSpace();
        }
        else
        {
            d = kpm->buffer();
            d = d.simplifyWhiteSpace();
        }
    }

    QTextOStream stream( &data );
    stream << "<fulltext>";
    stream << d;
    stream << "</fulltext>";

    kdDebug() << "EMLExtractor end" << endl;
}

void KatProcessManager::slotProcessExited( KProcess* /*proc*/ )
{
}

KatProcessManager::~KatProcessManager()
{
    kdDebug() << "delete KatProcessManager::~KatProcessManager()===========" << endl;
}

KatProcessManager::KatProcessManager()
    : QObject()
{
    kdDebug() << " Start KatProcessManager::KatProcessManager()========" << endl;
}

void KatProcessManager::slotReceivedStdout( KProcess* /*proc*/, char* buffer, int /*buflen*/ )
{
    m_buffer += QString::fromUtf8( buffer );
}


#include "katprocessmanager.moc"
