/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Fred Schaettgen : kde.sch@ttgen.net                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _FULLTEXT_H_
#define _FULLTEXT_H_

#include <qmap.h>

#include <kio/slavebase.h>

#include "fulltextextractorbase.h"

class FulltextProtocol : public KIO::SlaveBase
{
public:
    FulltextProtocol( const QCString& pool, const QCString& app );
    virtual ~FulltextProtocol();

    virtual void get( const KURL& url );
    virtual void mimeType( const KURL& url );

private:
    QMap<QString, newFulltextExtractor> m_extractorCreators;
};

#endif // _FULLTEXT_H_
