/***************************************************************************
                                mykrar.h
            This class implements a read-only access to RAR files from KDE
                             -------------------
    begin                : Fri Sep 15 2006
    copyright            : (C) 2006 by Eric Coquelle
    email                : eric a.a coquelle a@a gmail.com

   Some parts taken from kzip.cpp (c) D. Faure and H. Schroeder
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
***************************************************************************/

#ifndef _MYKRAR_H_
#define _MYKRAR_H_

#include <sys/stat.h>

#include <karchive.h>
#include <kprocess.h>

#include <qiodevice.h>


class MyKRarFileEntry;
/**
 *   his class implements a read-only access to RAR files from KDE
 * @short A class for reading rar archives.
 * @author Eric Coquelle <eric a.a coquelle a@a gmail.com>
 */

class MyKRar : public KArchive
{
public:
    /**
     * Creates an instance that operates on the given filename.
     * using the compression filter associated to given mimetype.
     *
     * @param filename is a local path (e.g. "/home/holger/myfile.rar")
     */
    MyKRar( const QString& filename );

    virtual ~MyKRar();

    /** Constructs the KArchiveDirectoryStructure. Has to be called once per
    * file in the archive. @param is the output of the rar command */
    void displayRarArchiveContent( const char* line);

protected:
  /** Prepared the display of archive archiveName.*/
  virtual bool openArchive( int mode );
  /// Closes the archive
  virtual bool closeArchive();
  virtual bool writeDir( const QString&, const QString&, const QString& ) { return true; }
  virtual bool prepareWriting( const QString& name, const QString& user, const QString& group, uint size ) { return true; }
  virtual bool doneWriting( uint size ) { return true; }
  mode_t getMode_tPermissions(QString permission);
  int getFromIndividualPermission(QChar permission);

  
private:
    class MyKRarPrivate;
    MyKRarPrivate * d;
    QString archiveName;
    int flag;
    QCString m_line1;
};


/**
 * @internal
 */
class MyKRarFileEntry : public KArchiveFile
{
public:
  MyKRarFileEntry( MyKRar* rar, const QString& name, int access, int date,
                 const QString& user, const QString& group, const QString& symlink,
                 const QString& path, Q_LONG start, Q_LONG uncompressedSize,
                   int encoding, Q_LONG compressedSize) :
    KArchiveFile( rar, name, access, date, user, group, symlink,
                  start, uncompressedSize ),
  m_crc(0),
  m_compressedSize(compressedSize),
  m_encoding("m3f"),
  m_path( path )
  {}
  
  QString encoding() const { return m_encoding; }
  Q_LONG compressedSize() const { return m_compressedSize; }

  /// CRC: only used when writing
  unsigned long crc32() const { return m_crc; }
  void setCRC32(unsigned long crc32) { m_crc=crc32; }

  /// Name with complete path - KArchiveFile::name() is the filename only (no path)
  QString path() const { return m_path; }


private:
    unsigned long m_crc;
    Q_LONG m_compressedSize;
    QString m_encoding;
    QString m_path;
    class MyKRarFileEntryPrivate* d;
};

#endif
