/***************************************************************************
                                mykrar.cpp
            This class implements a read-only access to RAR files from KDE
                             -------------------
    begin                : Fri Sep 15 2006
    copyright            : (C) 2006 by Eric Coquelle
    email                : eric a.a coquelle a@a gmail.com

   Some parts taken from kzip.cpp (c) D. Faure and H. Schroeder
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
***************************************************************************/


#include "mykrar.h"

#include <kfilterdev.h>
#include <kmimetype.h>
#include <kdebug.h>

#include <qfile.h>
#include <qdir.h>
#include <qdatetime.h>
#include <qasciidict.h>

#include <time.h>
#include <string.h>
#include <math.h>


////////////////////////////////////////////////////////////////////////
/** MyKRar */

class MyKRar::MyKRarPrivate
{
public:
    MyKRarPrivate()
        : m_crc( 0 ),
          m_currentFile( 0 ),
          m_currentDev( 0 )
    {}

    unsigned long           m_crc;         // checksum
    MyKRarFileEntry*          m_currentFile; // file currently being written
    QIODevice*              m_currentDev;  // filterdev used to write to the above file
    QPtrList<MyKRarFileEntry> m_fileList;    // flat list of all files, for the index (saves a recursive method ;)
};

MyKRar::MyKRar( const QString& fileName )
  : KArchive( 0L )
{
  d=new MyKRarPrivate;
  
  archiveName=fileName;
}

MyKRar::~MyKRar()
{
    delete d;
}

/** Prepared the display of archive archiveName.*/
bool MyKRar::openArchive( int mode )
{
    d->m_fileList.clear();

    flag=0;

    return true;
}

bool MyKRar::closeArchive()
{
    return true;
}

/** Constructs the KArchiveDirectoryStructure. Has to be called once per
  * file in the archive. @param is the output of the rar command */
void MyKRar::displayRarArchiveContent( const char* line){
  QStringList columns;
  QString name;
  QString fullname;
  bool isdir=false;
  QString strdate;
  int pos;
  uint mtime;
  
  flag++;

  if ( flag== 1)//1st line: name
  {
    m_line1 = line;
    return;
  }
  columns=QStringList::split(' ', line);//2nd line: other informations

  // if we made it here, we have all two lines.
  // Reset the line number.
  flag = 0;

  strdate=columns[3];
  int dd=strdate.left(strdate.find("-")).toInt();
  int yy=strdate.right(strdate.length()-strdate.findRev("-")-1).toInt();
  int mm=strdate.mid(strdate.find("-")+1, 2).toInt();
  name=m_line1;
	
  name=name.remove(0,1); //Removes the " " or "*" at the begininig of filenames
  fullname=name;
  if(QString(columns[5]).contains("D",false))
    isdir=true;
  if(name.endsWith("/"))
    name=name.left( name.length() - 1 ); //Removes any "/" at the end of the names
  
  mtime=QDateTime(QDate(dd,mm,yy), QTime::fromString(columns[4])).toTime_t();
  mode_t access=getMode_tPermissions(columns[5]);
  
  pos = name.findRev( '/' );
  if(pos!=-1)
    name = name.mid( pos + 1 );//Only keeps the filename or directory name, without path
  
  KArchiveEntry* entry;
  if ( isdir )
  {
    KArchiveEntry* ent = rootDir()->entry( QDir::cleanDirPath( fullname ) );
    if ( ent && ent->isDirectory() )
    {
      entry = 0L;
    }
    else
    {
      entry = new KArchiveDirectory( this, name, access, mtime, rootDir()->user(), rootDir()->group(), QString::null );
    }
  }
  else
  {
    entry = new MyKRarFileEntry( this, name, access, mtime,
                               rootDir()->user(), rootDir()->group(),
                               "", fullname, 0,
                               columns[0].toLong(), columns[8].toInt(), columns[1].toLong() );
      
    d->m_fileList.append( static_cast<MyKRarFileEntry *>( entry ) );
  }

  if ( entry )
  {
    if ( pos == -1 )
    {
      rootDir()->addEntry(entry);
    }
    else
    {
      // In some tar files we can find dir/./file => call cleanDirPath
      QString parentdir = QDir::cleanDirPath( fullname.left( pos ) );
      // Ensure container directory exists, create otherwise
      KArchiveDirectory * tdir = findOrCreate( parentdir );
      tdir->addEntry(entry);
    }
  }

}

int MyKRar::getFromIndividualPermission(QChar permission)
{
  if(permission=='r')
    return S_IRUSR;
  else if(permission=='w')
    return S_IWUSR;
  else if(permission=='x')
    return S_IXUSR;
  return 0;
}

mode_t MyKRar::getMode_tPermissions(QString permission)
{
  int i, j;
  mode_t mode=0;
  
  for(i=0;i<3;i++)
    for(j=1;j<4;j++)
      mode=mode | (getFromIndividualPermission(permission.at(i*3+j)) >> 3*i );
  if(permission.at(0)=='l')
    mode=mode | S_IFLNK;
  else if(permission.at(0)=='d')
    mode=mode | S_IFDIR;
  return mode;
}
