/***************************************************************************
                          ctargz.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ctargz.h"
#include <kdebug.h>


CTarGz::CTarGz()
{
	CTar();
}

CTarGz::~CTarGz(){
}

/** this method will launch the right compressor
to list the file contents
It will then launch the right method to display
the content in the listview */
void CTarGz::displayArchiveContent(){

  initializeReadingArchive();
  
  if(viewbydirectories)
    CTar::displayArchiveContent();
  else
  {
    FILE *flot;

    processread << "tar";
    processread << "-zvtf" << archiveName;

    if(readArchiveWithStream)
    {
        processread.start(&flot,KProcess::AllOutput);
        displayTarArchiveContent(flot);
    }
    else
    {
        m_buffer[0]='\0';
        processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
    }
  }
}
  
/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
 *@param extractall = EXTRACTONE_ANDBLOCK    (9): extract to karchiveur's temp directory (for viewing)
 *@param extractall = EXTRACT_SELECTED_FILES (1): extract all selected files
	*/
void CTarGz::extractArchive(QString & extractpath, int extractall, QString & filetoextract){
  QString optionRepertoire;
  QString nomextrait;
  QString fichiersaextraire;
  QStringList listsubdir;

  optionRepertoire="";
  fichiersaextraire="";
  counter=0;
  progressbar->reset();

  processextract.clearArguments();
  processextract << "tar";

  optionRepertoire="-C";
  optionRepertoire+=extractpath;
  processextract << "--overwrite"; //user select the files that have to be extracted in checkFiles(extractpath, extractall)
  processextract << "-zvxf";

  processextract << archiveName;
  processextract << optionRepertoire;

 	//We will extract all selected files
  if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
  {
    endProcess(NULL);
    return;
  }
  else if(extractall==EXTRACTONE_AND_BLOCK)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::Block)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall==EXTRACTONE)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::NotifyOnExit)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall!=EXTRACTONE_AND_BLOCK)
  {
          //We extract through the Stdout to have a progress indicator
    if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  counter=0;
}

//** delete @param filestodelete from current archive */
void CTarGz::removeFilesFromArchive( QStringList filestodelete )
{
  processextract.clearArguments();
  processextract << "gzip" << "-df" << archiveName;
  processextract.start(KProcess::Block);

  //The name of archive arch.tar.gz is now arch.tar
  if(archiveName.right(4).lower()==".tgz")
  {
          //it can be called arch.tgz
          archiveName=archiveName.left(archiveName.length()-3);
          archiveName+="tar";
  }
  else
          archiveName=archiveName.left(archiveName.length()-3);

  CTar::removeFilesFromArchive(filestodelete);

  processread.clearArguments();
  processread << "gzip" << QString("-%1").arg(compressrate) << archiveName;
  processread.start(KProcess::Block);
  archiveName+=".gz";
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CTarGz::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath)
{
   KProcess processcompressgz;

   processcompressgz.clearArguments();
   processcompressgz << "gzip" << "-df" << archiveName;
   processcompressgz.start(KProcess::Block);

   //The name of archive arch.tar.gz is now arch.tar
   if(archiveName.right(4)==".tgz")
   {
            //it can be called arch.tgz
            archiveName=archiveName.left(archiveName.length()-3);
            archiveName+="tar";
   }
   else
            archiveName=archiveName.left(archiveName.length()-3);

   //We add files to the pure tar archive
   CTar::addFilesToArchive(filestoadd, removeoriginalfiles, action, relativepath);
}

void CTarGz::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath)
{
  archiveName=nameofarchive;
  
  //The name of archive arch.tar.gz is now arch.tar
  if(archiveName.right(4).lower()==".tgz")
  {
    //it can be called arch.tgz
    archiveName=archiveName.left(archiveName.length()-3);
    archiveName+="tar";
  }
  else
    archiveName=archiveName.left(archiveName.length()-3);
  
  //We add files to the pure tar archive
  CTar::addFilesToArchive(filestoadd, false, ADD_AND_REPLACE_FILES, relativepath);
}

void CTarGz::compressCreatedTarArchive()
{
    QString comprrate;
    KProcess processcompressgz;
    comprrate.sprintf("-%i",compressrate);
    
    processcompressgz.clearArguments();
    processcompressgz << "gzip" <<"-f" << comprrate << archiveName;
    processcompressgz.start(KProcess::Block);

    archiveName+=".gz";
   kdDebug()<<QString("CTarGz::slotCompressCreatedTarArchive done, got %1").arg(archiveName)<<endl;
   emit(archiveReadEnded());
}

/** The current process ended */
void CTarGz::endProcess(KProcess* p){
  kdDebug()<<("CTarGz Process ENDED\n");

  if((p!=NULL)&&(processadd.pid()!=0)&&(p->pid()==processadd.pid()))
    compressCreatedTarArchive();
  else
    emit(archiveReadEnded());
}

#include "ctargz.moc"
