/***************************************************************************
                          ctar.cpp  -  description
                             -------------------
    begin                : Tue Dec 19 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ctar.h"
#include <kdebug.h>

CTar::CTar(){
	CArchive();

  connect(&processread,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOut(KProcess*,char*,int)));
  connect(&processread,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processread,SIGNAL(receivedStderr(KProcess*, char*, int)),this,SLOT(haveStdErr(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(haveSdtErrExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));

  list->setColumnText(4, i18n("Owner"));
  list->setColumnText(5, i18n("Permissions"));
}

CTar::~CTar(){
}

/** this method will launch the right compressor
to list the file contents
It will then launch the right method to display
the content in the listview */
void CTar::displayArchiveContent(){

  initializeReadingArchive();
  
  if(viewbydirectories)
  {
    tarfile=new KTar(archiveName);
    if( !tarfile->open(IO_ReadOnly) )
      errors.append("Process failed to open file");
    
    CArchive::displayArchiveContent(tarfile->directory(),QString::null);
    endProcess(NULL);
  }
  else
  {
  	FILE *flot;

  	processread << "tar";
  	processread << "-vtf" << archiveName;

  	if(readArchiveWithStream)
  	{
  			processread.start(&flot,KProcess::AllOutput);
  			displayTarArchiveContent(flot);
  	}
  	else
  	{
  		m_buffer[0]='\0';
  		processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
  	}
  }
}

/* This method display, using some (fine ?) icons
the content of the current archive */
void CTar::displayTarArchiveContent(FILE* flot){
	CListViewItem* elementListe=NULL;
	char tampon[5000];
	char permission[30];
	char owner[256];
	char size[30];
	QString date;
	char hour[9];
	char sname[5000];
	char year[5];
	char month[2];
	char day[2];
	QString y, m, d;
	QString path;
	QString name;
	QString message;
	int i;

	fgets( tampon, 5000, flot );
	while( !feof(flot) )
	{
		sscanf(tampon, " %[-drwxstl] %[0-9a-zA-Z./_] %[0-9] %[0-9]-%[0-9]-%[0-9] %[0-9:-] %[^\n]",permission, owner, size, year, month, day, hour, sname );

		name=sname;
		i=name.findRev('/');
		if(i!=-1)
		{
			path=name.left(i+1);
		 	name=name.remove(0,i+1);
		if(name.isEmpty())
                  name="..";
		}
		else
			path="";

		y=year;
		m=month;
		m.truncate(2);
		d=day;
		date=y+"-"+m+"-"+d;

		elementListe=new CListViewItem(list,name,size,hour,getLocalizedDate(QDate(y.toInt(),m.toInt(),d.toInt())), owner,permission,path);
		setIcon(name, permission, elementListe);
  if(name=="configure")
    issourcesoftware=issourcesoftware | HAS_CONFIGURE;
  else if(name=="Makefile.am")
    issourcesoftware=issourcesoftware | HAS_MAKEFILE_AM;
  elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
}

/*Overloaded method*/
void CTar::displayTarArchiveContent(const QString & ligne){
	CListViewItem* elementListe=NULL;
	char permission[30];
	char owner[256];
	char size[30];
	QString date;
	char year[5];
	char month[4];
	char day[3];
	char hour[9];
	char sname[5000];
	QString path;
	QString name;
	QString message;
	QString y, m, d;
	int i;

	sscanf(ligne.latin1(), "%[-drwxstl] %[0-9a-zA-Z./_] %[0-9] %[0-9]-%[0-9]-%[0-9] %[0-9:-] %[^\n]",permission, owner, size, year, month, day, hour, sname );

		name=sname;
		i=name.findRev('/');
		if(i!=-1)
		{
		  path=name.left(i+1);
		  name=name.remove(0,i+1);
		  if(name.isEmpty())
		    name="..";
		}
		else
		  path="";

		y=year;
		m=month;
		d=day;
    date=getLocalizedDate(QDate(y.toInt(),m.toInt(),d.toInt()));
    elementListe=new CListViewItem(list,name,size,hour,date,owner,permission,path);
    if(displayicons)
      setIcon(name, permission, elementListe);
    elementListe->widthChanged();
    if(name=="configure")
      issourcesoftware=issourcesoftware | HAS_CONFIGURE;
    else if(name=="Makefile.am")
      issourcesoftware=issourcesoftware | HAS_MAKEFILE_AM;
}

/** we recive some informations through the standard
output of the process */
void CTar::haveSdtOut(KProcess *, char *buffer, int length){
	//Has user canceled current action ?
	if(stopreadprocess)
		return;

	// This section is here only for testing. It has been taken from ark:
	//1997-1999: Rob Palmbos palm9744@kettering.edu
	//2000: Corel Corporation (author: Emily Ezust, emilye@corel.com)
	//and adapted to karchiveur
  char c = buffer[length];
  buffer[length] = '\0';

//  m_settings->appendShellOutputData( buffer );

  char line[1024] = "";
  char *tmpl = line;
  char *tmpb;


  //We copy m_buffer to tmpl
  for( tmpb = m_buffer; *tmpb != '\0'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  //We copy the fisrt string of buffer (till \n) to tmpl
  for( tmpb = buffer; *tmpb != '\n'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  tmpb++;
  *tmpl = '\0';

  if( *tmpb == '\0' )
    m_buffer[0]='\0';

	displayTarArchiveContent( line );
  bool stop = (*tmpb == '\0');

  while( !stop)
  {
      tmpl = line; *tmpl = '\0';

      for(; (*tmpb!='\n') && (*tmpb!='\0'); tmpl++, tmpb++)
				*tmpl = *tmpb;

      if( *tmpb == '\n' )
			{
			  *tmpl = '\n';
			  tmpl++;
			  *tmpl = '\0';
			  tmpb++;
	  		displayTarArchiveContent( line );
			}
      else if (*tmpb == '\0' )
			{
	  		*tmpl = '\0';
			  strcpy( m_buffer, line );
	  		stop = true;
			}
    }
  buffer[length] = c;
}

/** we recive some informations through the standard
output of the process */
void CTar::haveSdtOutExtract(KProcess *, char *buffer, int length){
	QString inter;
	int i=0;

	inter=buffer;
	inter=inter.left(length);

	while((i=inter.find('\n',i+1))!=-1){
		progressbar->setProgress(progressbar->progress()+1);
	}
}

/** The current process ended */
void CTar::endProcess(KProcess* ){
  kdDebug()<<("CTar Process ENDED\n");

  emit(archiveReadEnded());
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@param extractall = 9: extract @param filetoextract into karchiveur's temp directory (for viewing)
	*@param extractall = 1: extract all selected files
	*/
void CTar::extractArchive(QString & extractpath, int extractall, QString & filetoextract){
  QString directoryoption;
  QString nomextrait;
  QStringList listsubdir;

  errors.clear();
  counter=0;
  progressbar->reset();
  progressbar->setTotalSteps(countFiles());

  processextract.clearArguments();
  processextract << "tar";

  directoryoption="-C"+extractpath;
  processextract << "-vxf";
  if(!overwrite)
          processextract << "-k";

  processextract << archiveName;
  processextract << directoryoption;
  
kdDebug()<<QString("CTar::extractArchive name:%1 path:%2 extractall:%4 file:%3").arg(archiveName).arg(directoryoption).arg(filetoextract).arg(extractall)<<endl;

  if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
  {
    endProcess(NULL);
    return;
  }
  else if(extractall==EXTRACTONE_AND_BLOCK)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::Block)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall==EXTRACTONE)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::NotifyOnExit)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall!=EXTRACTONE_AND_BLOCK)
  {
          //We extract through the Stdout to have a progress indicator
    if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  counter=0;
}

/** delete @param filestodelete from current archive */
void CTar::removeFilesFromArchive (QStringList filestodelete){
 	processread.clearArguments();
 	processread << "tar" << "--delete" << "-f";
 	processread << archiveName;
  for (QStringList::Iterator f = filestodelete.begin(); f!=filestodelete.end(); ++f )
  {
    kdDebug()<<QString("Will remove:%1*").arg(*f)<<endl;
    processread << *f;
  }
 	processread.start(KProcess::Block);
	kdDebug()<<("Ok:removeFilesArchiveTar\n");
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CTar::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath)
{
 	processadd.clearArguments();
 	processadd << "tar";

 	if(removeoriginalfiles)
 		processadd << "--remove-files";
 	if(!recursivemode)
 		processadd << "--no-recursion";
 	if(relativepath!=NULL)
 		processadd << "-C" << relativepath;

 	switch(action)
 	{
 		case UPDATE_FILES:
        {
 			//Mode update
 			processadd << "-uf";
 			break;
        }
 		default:
 		case ADD_AND_REPLACE_FILES:
        {
 			//Mode append
 			processadd << "-rf";
 			break;
        }
 	}
  processadd << archiveName;
  for (QStringList::Iterator f = filestoadd.begin(); f!=filestoadd.end(); ++f )
  {
    if(relativepath.isEmpty())
      processadd << relativepath + *f;
    else
      processadd << *f;
  }
  
  progressbar->setTotalSteps(filestoadd.count());
  
  processadd.start(KProcess::NotifyOnExit);
}

/** Create a tar archive
@param  nameofarchive: the name of the pure .tar archive
@param param: list of files to add
@param relativepath: include only filenames, without their path */
void CTar::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath){
  
  kdDebug()<<QString("BeginCreatingTar*%1*%2*").arg(nameofarchive).arg(relativepath)<<endl;
  archiveName=nameofarchive;
  addFilesToArchive(filestoadd, false, ADD_AND_REPLACE_FILES,relativepath);
}

#include "ctar.moc"
