/***************************************************************************
                          canimation.h  -  description
                             -------------------
    begin                : sam sep 27 2003
    copyright            : (C) 2003 by eric
    email                : eric@portable
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CANIMATION_H
#define CANIMATION_H

#include <qdialog.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <kiconloader.h>

class CAnimation : public QDialog
{
Q_OBJECT
public:
   CAnimation( QWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 );
   ~CAnimation();
   
   /**Don't display display this dialog box if reading/extraction is very fast*/
   void startAnimation();
   void stopAnimation();
   
signals:
   void animationCancelled();
      
protected:
   /**Paints the top right and top left pixmaps*/
   void paintEvent ( QPaintEvent* );
   
protected slots:
   /**Launches the animation*/
   void launchAnimation();
   /**Moves pixmap pix3 from left to right*/
   void performAnimation();
   void slotCancel();
   
protected:
   QTimer timer, timerwait;
   QPixmap pix1, pix2, pix3;
   QPushButton* cancelbutton;
   QPixmap bg;
   int animx;
   int animy;
   int animsize;
   int borderr, borderl;
};

#endif
