
/*
 * Kanatest
 *
 * Copyright (C) 2001-2004, 2006 Tomasz Maka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <config.h>

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "i18n.h"
#include "chart.h"
#include "gui.h"
#include "prefs.h"
#include "main.h"
#include "test.h"
#include "options.h"


GtkWidget *options_window;
GtkWidget *rna_radio_button;
GtkWidget *rwa_radio_button;
GtkWidget *raa_radio_button;
GtkWidget *enable_tooltips_button;
GtkWidget *example_label;

GtkWidget *kana_colorbutton;
GtkWidget *romaji_colorbutton;

extern GtkWidget    *main_window;
extern GtkTooltips  *tooltips;
extern gchar        kana_signs_mask[CHART_ROWS][CHART_COLUMNS];

GtkWidget *notebook;
GtkWidget *number_of_kanas_label;
GtkWidget *check_buttons[NUMBER_OF_SIGNS];
gboolean disable_toggles;

GtkWidget *row_button_s[CHART_ROWS], *row_button_c[CHART_ROWS];
gchar row_pos[CHART_ROWS][CHART_COLUMNS];

/*--------------------------------------------------------------------*/

void
options_font_select_handler_cb (GtkWidget *widget) {

    gchar *s, *n;
    GtkWidget *font_selector;
    gint response;
    gchar tmpbuf[BUFFER_SIZE];

    font_selector = gtk_font_selection_dialog_new (_("Select kana font"));
    gtk_window_set_modal(GTK_WINDOW(font_selector), TRUE);
    gtk_window_set_position(GTK_WINDOW(font_selector), GTK_WIN_POS_MOUSE);
    gtk_window_set_transient_for(GTK_WINDOW(font_selector), GTK_WINDOW(options_window));
    sprintf(tmpbuf, "%s 16", config.kana_font_face);
    gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG(font_selector), tmpbuf);
    gtk_font_selection_dialog_set_preview_text (GTK_FONT_SELECTION_DIALOG (font_selector),
                                                EXAMPLE_KANA_TEXT);
    gtk_widget_show (font_selector);

    response = gtk_dialog_run (GTK_DIALOG (font_selector));

    if (response == GTK_RESPONSE_OK) {

        s = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(font_selector));
        n = strrchr (s, ' ');
        *n= '\0';
        strncpy(config.kana_font_face, s, MAX_FONTNAME_LEN);
        g_free (s);
    }

    gtk_widget_destroy (font_selector);
}

/*--------------------------------------------------------------------*/

void
options_repeat_mode_changed_cb (GtkToggleButton *button, gpointer user_data) {

     if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(rna_radio_button)) == TRUE) {
        config.repeat_mode = REPEAT_NONE;
     } else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(rwa_radio_button)) == TRUE) {
        config.repeat_mode = REPEAT_WRONG;
     } else {
        config.repeat_mode = REPEAT_ALL;
     }
}

/*--------------------------------------------------------------------*/

void
options_tooltips_changed_cb (GtkToggleButton *button, gpointer user_data) {

    config.enable_tooltips = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(button));
}

/*--------------------------------------------------------------------*/

gint
update_selected_kanas(void) {

    gint i, n;
    gchar tmp[MAX_BUFFER_SIZE];

    for(i = n = 0; i < NUMBER_OF_SIGNS; i++) {
        if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(check_buttons[i])) == TRUE) {
            n++;
        }
    }

    sprintf(tmp, "%d", n);
    gtk_label_set_text (GTK_LABEL(number_of_kanas_label), tmp);

    return n;
}

/*--------------------------------------------------------------------*/

void
kana_selected_cb (GtkToggleButton *button, gpointer user_data) {

    gint pos;

    if (disable_toggles == FALSE) {

        pos = (int) user_data;

        if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(button)) == TRUE) {
            config.user_defined_lesson[pos] = '+';
        } else {
            config.user_defined_lesson[pos] = '-';
        }

        update_selected_kanas();
    }
}

/*--------------------------------------------------------------------*/

gint
delete_event_cb( GtkWidget *widget, GdkEvent *event, gpointer data) {
    return TRUE;
}

/*--------------------------------------------------------------------*/

void
options_window_close_cb (void) {

    GtkWidget *info_dialog;
    GdkColor color;
    gchar color_str[MAX_COLORNAME_LEN];

    if (update_selected_kanas() < 2) {

        gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), 1);

        info_dialog = gtk_message_dialog_new (GTK_WINDOW(options_window),
                                              GTK_DIALOG_MODAL,
                                              GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
                                              _("Please select at least two kanas to test."));

        gtk_window_set_transient_for(GTK_WINDOW(info_dialog), GTK_WINDOW(options_window));
        gtk_window_set_title(GTK_WINDOW(info_dialog), _("Error"));
        gtk_widget_show (info_dialog);
        gtk_dialog_run(GTK_DIALOG(info_dialog));
        gtk_widget_destroy(info_dialog);

    } else {

        gtk_color_button_get_color(GTK_COLOR_BUTTON(kana_colorbutton), &color);
        sprintf(color_str, "#%02X%02X%02X",
                color.red * 256 / 65536, color.green * 256 / 65536, color.blue * 256 / 65536);
        strncpy(config.kana_color, color_str, MAX_COLORNAME_LEN-1);

        gtk_color_button_get_color(GTK_COLOR_BUTTON(romaji_colorbutton), &color);
        sprintf(color_str, "#%02X%02X%02X",
                color.red * 256 / 65536, color.green * 256 / 65536, color.blue * 256 / 65536);
        strncpy(config.romaji_color, color_str, MAX_COLORNAME_LEN-1);

        if (config.enable_tooltips == TRUE) {
            gtk_tooltips_enable(tooltips);
        } else {
            gtk_tooltips_disable(tooltips);
        }

        gdk_window_get_root_origin (options_window->window,
                                    &config.options_window_x, &config.options_window_y);
        gtk_widget_destroy (options_window);
    }
}

/*--------------------------------------------------------------------*/

void
options_combobox_ca_timeout_handler_cb (GtkComboBox *widget, gpointer user_data) {

    config.ca_timeout = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
}

/*--------------------------------------------------------------------*/

gint
options_key_press_cb (GtkWidget *widget, GdkEventKey *event, gpointer data) {

    if (event->keyval == GDK_Escape) {
        options_window_close_cb ();
        return TRUE;
    }

    return FALSE;
}

/*--------------------------------------------------------------------*/

void
options_combobox_dtf_handler_cb (GtkComboBox *widget, gpointer user_data) {

gint i, j, n, pos;
gchar tmp[BUFFER_SIZE];

    n = gtk_combo_box_get_active(GTK_COMBO_BOX(widget));
    pos = 0;

    for(j=0; j < CHART_ROWS; j++) {
        for(i=0; i < CHART_COLUMNS; i++) {
            if(kana_signs_mask[j][i]) {
                if (n != 0) {
                    sprintf(tmp, "<span font_desc='12' face='%s'>%s</span>",
                            config.kana_font_face, gettext(kana_signs[pos*3+n]));
                } else {
                    sprintf(tmp, "<span font_desc='10' face='%s'>%s</span>",
                            config.kana_font_face, gettext(kana_signs[pos*3]));
                }
                gtk_label_set_markup (GTK_LABEL(GTK_BIN(GTK_BUTTON(check_buttons[pos]))->child), tmp);
                pos++;
            }
        }
    }

}

/*--------------------------------------------------------------------*/

void
select_action_cb (GtkWidget *widget, gpointer user_data) {

    gint i, j, pos;
    gboolean state;

    pos = 0;

    for(j=0; j < CHART_ROWS; j++) {
        for(i=0; i < CHART_COLUMNS; i++) {

            if(kana_signs_mask[j][i]) {

                switch((gint) user_data) {

                    case SELECT_ALL:
                        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check_buttons[pos]), TRUE);
                        break;

                    case SELECT_NONE:
                        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check_buttons[pos]), FALSE);
                        break;

                    case SELECT_INVERT:
                        state = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(check_buttons[pos]));
                        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check_buttons[pos]), !state);
                        break;

                    default:
                        break;
                };

                pos++;
            }
        }
    }
}

/*--------------------------------------------------------------------*/

void
select_deselect_row (gint row, gboolean state) {
gint i;

    for(i=0; i < CHART_COLUMNS; i++) {
        if (row_pos[row][i] != -1) {
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check_buttons[(gint)row_pos[row][i]]), state);
        }
    }
}

void
row_button_s_cb (GtkWidget *widget, gpointer data) {
    select_deselect_row ((gint)data, TRUE);
}

void
row_button_c_cb (GtkWidget *widget, gpointer data) {
    select_deselect_row ((gint)data, FALSE);
}

/*--------------------------------------------------------------------*/

void
options_create_window (void) {

    GtkWidget       *vbox1;
    GtkWidget       *vbox2;
    GtkWidget       *vbox_n;
    GtkWidget       *vbox_l;
    GtkWidget       *hbox;
    GtkWidget       *hseparator;
    GtkWidget       *hbuttonbox;
    GtkWidget       *hbuttonbox_s;
    GtkWidget       *alignment;
    GtkWidget       *close_button;
    GtkWidget       *frame;
    GtkWidget       *label;
    GtkWidget       *combobox_ca_timeout;
    GtkWidget       *combobox_dtf;
    GtkWidget       *font_button;
    GtkWidget       *table;
    GdkColor        color;
    GtkWidget       *frames[NUMBER_OF_SIGNS];
    GtkWidget       *scrolledwindow;
    GtkWidget       *viewport;
    GtkWidget       *select_all_button;
    GtkWidget       *select_none_button;
    GtkWidget       *invert_selection_button;
    gint            i, j, pos;
    gchar           buffer[BUFFER_SIZE], tmp[BUFFER_SIZE];

    options_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_transient_for(GTK_WINDOW(options_window),GTK_WINDOW(main_window));
    gtk_window_set_resizable (GTK_WINDOW (options_window), TRUE);
    gtk_window_set_modal(GTK_WINDOW(options_window), TRUE);
    gtk_container_set_border_width (GTK_CONTAINER (options_window), 12);
    gtk_window_set_title (GTK_WINDOW (options_window), _("Options"));
    gtk_window_set_default_size (GTK_WINDOW(options_window), 560, 460);

    g_signal_connect (G_OBJECT (options_window), "delete_event",
                      G_CALLBACK(delete_event_cb), NULL);

    g_signal_connect (G_OBJECT(options_window), "key_press_event",
                        G_CALLBACK(options_key_press_cb), NULL);

    gtk_window_move (GTK_WINDOW (options_window),
                                config.options_window_x, config.options_window_y);

    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (options_window), vbox1);

    notebook = gtk_notebook_new();
    GTK_WIDGET_UNSET_FLAGS(notebook, GTK_CAN_FOCUS);
    gtk_widget_show (notebook);
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
    gtk_box_pack_start (GTK_BOX (vbox1), notebook, TRUE, TRUE, 0);

    label = gtk_label_new(_("General"));
    vbox_n = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox_n);
    gtk_container_set_border_width (GTK_CONTAINER (vbox_n), 4);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_n, label);

    /*-----------------------------------------------------------------*/
    /* Drill options */

    frame = gtk_frame_new (NULL);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox_n), frame, TRUE, FALSE, 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

    sprintf(buffer, "<b>%s:</b>", _("Drill options"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_frame_set_label_widget (GTK_FRAME (frame), label);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

    alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
    gtk_widget_show (alignment);
    gtk_container_add (GTK_CONTAINER (frame), alignment);
    gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 0, 0, 12, 0);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (alignment), vbox2);

    rna_radio_button = gtk_radio_button_new_with_label(NULL,
                                                       _("Display each kana once"));
    gtk_box_pack_start (GTK_BOX (vbox2),rna_radio_button, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (rna_radio_button), 8);
    gtk_widget_show (rna_radio_button);
    gtk_tooltips_set_tip (tooltips, rna_radio_button, _("When this option is enabled the kanatest will display every question once"), NULL);
    g_signal_connect (G_OBJECT (rna_radio_button), "toggled",
                      G_CALLBACK (options_repeat_mode_changed_cb), NULL);

    rwa_radio_button = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(rna_radio_button),
                                                                   _("Repeat wrongly-answered questions"));
    gtk_box_pack_start (GTK_BOX (vbox2),rwa_radio_button, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (rwa_radio_button), 8);
    gtk_widget_show (rwa_radio_button);
    gtk_tooltips_set_tip (tooltips, rwa_radio_button, _("When this option is enabled the kanatest will repeat all wrongly answered questions at the end of test"), NULL);
    g_signal_connect (G_OBJECT (rwa_radio_button), "toggled",
                      G_CALLBACK (options_repeat_mode_changed_cb), NULL);

    raa_radio_button = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(rna_radio_button),
                                                                   _("Repeat all forever"));
    gtk_box_pack_start (GTK_BOX (vbox2),raa_radio_button, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (raa_radio_button), 8);
    gtk_widget_show (raa_radio_button);
    gtk_tooltips_set_tip (tooltips, raa_radio_button, _("When this option is enabled the kanatest will repeat all questions forever"), NULL);
    g_signal_connect (G_OBJECT (raa_radio_button), "toggled",
                      G_CALLBACK (options_repeat_mode_changed_cb), NULL);

    table = gtk_table_new (2, 1, FALSE);
    gtk_widget_show (table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 12);
    gtk_box_pack_start (GTK_BOX (vbox2), table, FALSE, FALSE, 0);

    sprintf(buffer, "%s:", _("Correct answer display timeout"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

    combobox_ca_timeout = gtk_combo_box_new_text ();
    GTK_WIDGET_UNSET_FLAGS(combobox_ca_timeout, GTK_CAN_FOCUS);
    gtk_widget_show (combobox_ca_timeout);
    g_signal_connect (G_OBJECT (combobox_ca_timeout), "changed",
                      G_CALLBACK (options_combobox_ca_timeout_handler_cb), NULL);
    gtk_table_attach (GTK_TABLE (table), combobox_ca_timeout, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                    (GtkAttachOptions) (0), 8, 0);
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_ca_timeout), _("Disabled"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_ca_timeout), _("1 sec"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_ca_timeout), _("2 sec"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_ca_timeout), _("3 sec"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_ca_timeout), _("Until any key will be pressed"));

    gtk_combo_box_set_active (GTK_COMBO_BOX (combobox_ca_timeout), config.ca_timeout);


    /*-----------------------------------------------------------------*/
    /* Display options */

    frame = gtk_frame_new (NULL);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox_n), frame, TRUE, FALSE, 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

    sprintf(buffer, "<b>%s:</b>", _("Appearance"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_frame_set_label_widget (GTK_FRAME (frame), label);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

    alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
    gtk_widget_show (alignment);
    gtk_container_add (GTK_CONTAINER (frame), alignment);
    gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 0, 0, 12, 0);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (alignment), vbox2);

    table = gtk_table_new (5, 1, FALSE);
    gtk_widget_show (table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 12);
    gtk_box_pack_start (GTK_BOX (vbox2), table, TRUE, TRUE, 0);

    sprintf(buffer, "%s:", _("Kana color"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

    kana_colorbutton = gtk_color_button_new ();
    gtk_widget_show (kana_colorbutton);
    gtk_table_attach (GTK_TABLE (table), kana_colorbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 0);
    gtk_container_set_border_width (GTK_CONTAINER (kana_colorbutton), 3);

    gdk_color_parse(config.kana_color, &color);
    gtk_color_button_set_color (GTK_COLOR_BUTTON (kana_colorbutton), &color);

    sprintf(buffer, "%s:", _("Romaji color"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

    romaji_colorbutton = gtk_color_button_new ();
    gtk_widget_show (romaji_colorbutton);
    gtk_table_attach (GTK_TABLE (table), romaji_colorbutton, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 6, 0);
    gtk_container_set_border_width (GTK_CONTAINER (romaji_colorbutton), 3);

    gdk_color_parse(config.romaji_color, &color);
    gtk_color_button_set_color (GTK_COLOR_BUTTON (romaji_colorbutton), &color);

    font_button = gui_stock_label_button(_("Select kana font"), GTK_STOCK_SELECT_FONT);
    g_signal_connect (G_OBJECT (font_button), "clicked",
                        G_CALLBACK (options_font_select_handler_cb), NULL);
    gtk_widget_show (font_button);
    gtk_table_attach (GTK_TABLE (table), font_button, 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                    (GtkAttachOptions) (0), 8, 0);

    /*-----------------------------------------------------------------*/
    /* Misc options */

    frame = gtk_frame_new (NULL);
    gtk_widget_show (frame);
    gtk_box_pack_start (GTK_BOX (vbox_n), frame, TRUE, FALSE, 0);
    gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);

    sprintf(buffer, "<b>%s:</b>", _("Misc options"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_frame_set_label_widget (GTK_FRAME (frame), label);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);

    alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
    gtk_widget_show (alignment);
    gtk_container_add (GTK_CONTAINER (frame), alignment);
    gtk_alignment_set_padding (GTK_ALIGNMENT (alignment), 0, 0, 12, 0);

    vbox2 = gtk_vbox_new (TRUE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (alignment), vbox2);

    enable_tooltips_button = gtk_check_button_new_with_label(_("Enable tooltips"));
    gtk_container_set_border_width (GTK_CONTAINER (enable_tooltips_button), 8);
    g_signal_connect (G_OBJECT (enable_tooltips_button), "toggled",
                      G_CALLBACK (options_tooltips_changed_cb), NULL);
    gtk_box_pack_start (GTK_BOX (vbox2), enable_tooltips_button, TRUE, FALSE, 0);
    gtk_widget_show (enable_tooltips_button);
    gtk_tooltips_set_tip (tooltips, enable_tooltips_button, _("Toggle to enable/disable tooltips"), NULL);

    /*-----------------------------------------------------------------*/
    /* User-defined lesson TAB */

    label = gtk_label_new(_("User-defined lesson"));
    vbox_l = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox_l);
    gtk_container_set_border_width (GTK_CONTAINER (vbox_l), 4);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), vbox_l, label);

    scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_show (scrolledwindow);
    gtk_box_pack_start (GTK_BOX (vbox_l), scrolledwindow, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

    viewport = gtk_viewport_new (NULL, NULL);
    gtk_widget_show (viewport);
    gtk_container_add (GTK_CONTAINER (scrolledwindow), viewport);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_container_add (GTK_CONTAINER (viewport), vbox2);

    table = gtk_table_new (CHART_ROWS, CHART_COLUMNS+2, FALSE);     /* 2 - S and C buttons */
    gtk_widget_show (table);
    gtk_box_pack_start (GTK_BOX (vbox2), table, FALSE, TRUE, 0);

    pos = 0;
    disable_toggles = TRUE;

    for(j=0; j < CHART_ROWS; j++) {
        for(i=0; i < CHART_COLUMNS; i++) {

            row_pos[j][i] = -1;
            if(kana_signs_mask[j][i]) {

                frames[pos] = gtk_frame_new (NULL);
                gtk_widget_show (frames[pos]);
                gtk_table_attach (GTK_TABLE (table), frames[pos], i, i+1, j, j+1,
                                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
                gtk_container_set_border_width (GTK_CONTAINER (frames[pos]), 2);
                gtk_frame_set_shadow_type (GTK_FRAME (frames[pos]), GTK_SHADOW_ETCHED_OUT);

                sprintf(tmp, "%s", gettext(kana_signs[pos*3+ROMAJI]));

                check_buttons[pos] = gtk_check_button_new_with_mnemonic (tmp);

                gtk_widget_show (check_buttons[pos]);
                g_signal_connect (G_OBJECT (check_buttons[pos]), "toggled",
                                  G_CALLBACK (kana_selected_cb), (gpointer) pos);
                GTK_WIDGET_UNSET_FLAGS(check_buttons[pos], GTK_CAN_FOCUS);
                gtk_container_add (GTK_CONTAINER (frames[pos]), check_buttons[pos]);

                if(config.user_defined_lesson[pos] == '+') {
                    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check_buttons[pos]), TRUE);
                }

                row_pos[j][i] = pos;
                pos++;
            }

        }

        i++;
        row_button_s[j] = gui_stock_label_button(NULL, GTK_STOCK_APPLY);
        gtk_button_set_relief (GTK_BUTTON (row_button_s[j]), GTK_RELIEF_NONE);
        GTK_WIDGET_UNSET_FLAGS(row_button_s[j], GTK_CAN_FOCUS);
        gtk_tooltips_set_tip (tooltips, row_button_s[j], _("Select all kanas in row"), NULL);
        gtk_widget_show (row_button_s[j]);
        gtk_table_attach (GTK_TABLE (table), row_button_s[j], i, i+1, j, j+1,
                          (GtkAttachOptions) (GTK_FILL),
                          (GtkAttachOptions) (GTK_FILL), 0, 0);

        g_signal_connect (G_OBJECT (row_button_s[j]), "clicked",
                            G_CALLBACK (row_button_s_cb), (gpointer) j);

        i++;
        row_button_c[j] = gui_stock_label_button(NULL, GTK_STOCK_CLEAR);
        gtk_button_set_relief (GTK_BUTTON (row_button_c[j]), GTK_RELIEF_NONE);
        GTK_WIDGET_UNSET_FLAGS(row_button_c[j], GTK_CAN_FOCUS);
        gtk_tooltips_set_tip (tooltips, row_button_c[j], _("Deselect all kanas in row"), NULL);
        gtk_widget_show (row_button_c[j]);
        gtk_table_attach (GTK_TABLE (table), row_button_c[j], i, i+1, j, j+1,
                          (GtkAttachOptions) (GTK_FILL),
                          (GtkAttachOptions) (GTK_FILL), 0, 0);

        g_signal_connect (G_OBJECT (row_button_c[j]), "clicked",
                            G_CALLBACK (row_button_c_cb), (gpointer) j);

    }

    disable_toggles = FALSE;

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox_l), hbox, FALSE, TRUE, 4);

    sprintf(buffer, "<b>%s:</b>", _("Selected kanas"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
    gtk_misc_set_padding (GTK_MISC (label), 4, 0);

    number_of_kanas_label = gtk_label_new ("");
    gtk_widget_show (number_of_kanas_label);
    gtk_box_pack_start (GTK_BOX (hbox), number_of_kanas_label, FALSE, FALSE, 0);
    gtk_misc_set_padding (GTK_MISC (number_of_kanas_label), 4, 0);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox_l), hbox, FALSE, TRUE, 4);

    sprintf(buffer, "<b>%s:</b>", _("Display as"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
    gtk_misc_set_padding (GTK_MISC (label), 4, 0);

    combobox_dtf = gtk_combo_box_new_text ();
    GTK_WIDGET_UNSET_FLAGS(combobox_dtf, GTK_CAN_FOCUS);
    gtk_widget_show (combobox_dtf);
    gtk_box_pack_start (GTK_BOX (hbox), combobox_dtf, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (combobox_dtf), "changed",
                      G_CALLBACK (options_combobox_dtf_handler_cb), NULL);
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_dtf), _("Romaji"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_dtf), _("Hiragana"));
    gtk_combo_box_append_text (GTK_COMBO_BOX (combobox_dtf), _("Katakana"));
    gtk_combo_box_set_active (GTK_COMBO_BOX (combobox_dtf), 0);

    hbuttonbox_s = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox_s);
    gtk_box_pack_end (GTK_BOX (hbox), hbuttonbox_s, FALSE, TRUE, 0);
    gtk_box_set_spacing (GTK_BOX (hbuttonbox_s), 4);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox_s), GTK_BUTTONBOX_END);

    sprintf(buffer, "<b>%s:</b>", _("Select"));
    label = gtk_label_new (buffer);
    gtk_widget_show (label);
    gtk_box_pack_end (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
    gtk_misc_set_padding (GTK_MISC (label), 4, 0);

    select_all_button = gtk_button_new_with_label (_("All"));
    GTK_WIDGET_UNSET_FLAGS(select_all_button, GTK_CAN_FOCUS);
    gtk_widget_show (select_all_button);
    gtk_container_add (GTK_CONTAINER (hbuttonbox_s), select_all_button);
    g_signal_connect (G_OBJECT (select_all_button), "clicked",
                        G_CALLBACK (select_action_cb), (gpointer) SELECT_ALL);

    select_none_button = gtk_button_new_with_label (_("None"));
    GTK_WIDGET_UNSET_FLAGS(select_none_button, GTK_CAN_FOCUS);
    gtk_widget_show (select_none_button);
    gtk_container_add (GTK_CONTAINER (hbuttonbox_s), select_none_button);
    g_signal_connect (G_OBJECT (select_none_button), "clicked",
                        G_CALLBACK (select_action_cb), (gpointer) SELECT_NONE);

    invert_selection_button = gtk_button_new_with_label (_("Invert"));
    GTK_WIDGET_UNSET_FLAGS(invert_selection_button, GTK_CAN_FOCUS);
    gtk_widget_show (select_none_button);
    gtk_widget_show (invert_selection_button);
    gtk_container_add (GTK_CONTAINER (hbuttonbox_s), invert_selection_button);
    g_signal_connect (G_OBJECT (invert_selection_button), "clicked",
                        G_CALLBACK (select_action_cb), (gpointer) SELECT_INVERT);

    hseparator = gtk_hseparator_new ();
    gtk_widget_show (hseparator);
    gtk_box_pack_start (GTK_BOX (vbox1), hseparator, FALSE, FALSE, 8);

    hbuttonbox = gtk_hbutton_box_new ();
    gtk_widget_show (hbuttonbox);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
    gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox, FALSE, FALSE, 0);

    close_button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
    gtk_widget_show (close_button);
    g_signal_connect (G_OBJECT (close_button), "clicked",
                        G_CALLBACK (options_window_close_cb), NULL);
    gtk_container_add (GTK_CONTAINER (hbuttonbox), close_button);
    GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);

    switch(config.repeat_mode) {
        case REPEAT_ALL:
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(raa_radio_button), TRUE);
            break;
        case REPEAT_WRONG:
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(rwa_radio_button), TRUE);
            break;
        default:
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(rna_radio_button), TRUE);
    }

    if (config.enable_tooltips == TRUE) {
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(enable_tooltips_button), TRUE);
    }

    update_selected_kanas();

    gtk_widget_show (options_window);

    gtk_widget_grab_default (close_button);
}

/*--------------------------------------------------------------------*/

