#ifndef KADU_SEARCH_H
#define KADU_SEARCH_H

#include <qwidget.h>
#include <qtoolbutton.h>
#include <qvaluelist.h>

#include "gadu.h"
#include "toolbar.h"

class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QPushButton;
class QRadioButton;

class Action;

/**
	Klasa ta reprezentuje okno dialogowe wyszukiwania w katalogu publicznym.
	\brief Wyszukiwanie w katalogu publicznym.
	\class SearchDialog
**/
class SearchDialog : public QWidget {
	Q_OBJECT
	public:
		/**
			\fn SearchDialog(QWidget *parent=0, const char *name=0, UinType whoisSearchUin = 0)
			Standardowy konstruktor.
			\param parent rodzic kontrolki. Domylnie 0.
			\param name nazwa kontrolki. Domylnie 0.
			\param whoisSearchUin warto logiczna informujca o tym, czy wstpnie ma by wybrane
				wyszukiwanie po numerze UIN (1) czy po danych osobowych (0). Domylnie 0.
		**/
		SearchDialog(QWidget *parent=0, const char *name=0, UinType whoisSearchUin = 0);
		~SearchDialog(void);
		static void initModule();
		static void closeModule();

	private:
		QCheckBox *only_active;
		QLineEdit *e_uin;
		QLineEdit *e_name;
		QLineEdit *e_nick;
		QLineEdit *e_byrFrom;
		QLineEdit *e_byrTo;
		QLineEdit *e_surname;
		QComboBox *c_gender;
		QLineEdit *e_city;
		QListView *results;
		QLabel *progress;
		QRadioButton *r_uin;
		QRadioButton *r_pers;
		UinType _whoisSearchUin;
		uint32_t seq;
		UserGroup *selectedUsers;

		Action *add_searched_action;
		Action *chat_searched_action;
		Action *first_search_action;
		Action *next_results_action;
		Action *stop_search_action;
		Action *clear_search_action;

		SearchRecord *searchRecord;

		bool searchhidden;
		bool searching;
		bool workaround; // TODO: remove

		bool isPersonalDataEmpty() const;

	public slots:

		void selectedUsersNeeded(const UserGroup*& user_group);

		/**
			\fn void stopSearch(void)
			Zatrzymuje aktualne wyszukiwanie. Jeli w pniejszym czasie zwrcone
			zostan jakie wyniki, bd one zignorowane.
		**/
		void stopSearch(void);

		/**
			\fn void firstSearch(void)
			Czyci list wynikw, a nastpnie wyszukuje w katalogu publicznym wg.
			podanych w oknie danych. Wywietla tylko ograniczon ich liczb, ze wzgldu
			na dziaanie protokou Gadu-Gadu. Metoda ta wywoywana jest przy wciniciu
			przycisku "Szukaj". Aby uzyska kolejne wyniki i doda je do
			bierzcych, naley dokona wtrnego zapytania metod SearchDialog::nextSearch.
		**/
		void firstSearch(void);

		/**
			\fn void nextSearch(void)
			Kontynuuje wyszukowanie kolejnych kontaktw, a wyniki dodaje do bierzcych.
			Metoda ta wywoywana jest przy wciniciu przycisku "Nastpne wyniki".
		**/
		void nextSearch(void);

		/**
			\fn void newSearchResults(SearchResults& searchResults, int seq, int fromUin)
			Interpretuje uzyskane wyniki wyszukiwania i dodaje je do listy wynikw.
			Metoda ta jest wywoywana, gdy serwer Gadu-Gadu odpowie na zapytanie do katalogu publicznego.
			\param searchResults lista struktur opisujcych wyniki wyszukiwania.
			\param seq unikalny identyfikator zapytania do katalogu publicznego.
			\param fromUin numer UIN, od ktrego rozpoczto wyszukiwanie (jest rny dla kolejnych
			wywoa - najpierw SearchDialog::firstSearch, a potem kolejne SearchDialog::nextSearch).
		**/
		void newSearchResults(SearchResults& searchResults, int seq, int fromUin);

	private slots:
		void clearResults(void);
		void addSearchedActionActivated(const UserGroup*);
		void uinTyped(void);
		void personalDataTyped(void);
		void byrFromDataTyped(void);
		void persClicked();
		void uinClicked();
		void updateInfoClicked();
		void actionsAddedToToolbar(ToolButton*, ToolBar*);
		void stopSearchActionAddedToToolbar(ToolButton*, ToolBar*);
		void firstSearchActionAddedToToolbar(ToolButton*, ToolBar*);
		void nextResultsActionAddedToToolbar(ToolButton*, ToolBar*);
		void clearResultsActionAddedToToolbar(ToolButton*, ToolBar*);
		void selectionChanged();

	protected:
		/**
			\fn void closeEvent(QCloseEvent * e)
			Obsuguje zdarzenie zamknicia okna wyszukiwania w katalogu publicznym.
			\param e wskanik do obiektu opisujcego zdarzenie zamknicie okna.
		**/
		virtual void closeEvent(QCloseEvent *e);
		virtual void resizeEvent(QResizeEvent *e);
		virtual void keyPressEvent(QKeyEvent *e);
};

#endif

