#include "alsa_access.h"
#include <stdio.h>
#include <alsa/asoundlib.h>

AlsaHandle::AlsaHandle(QObject *parent, const char *name) 
    : QObject(parent, name) {

    if (!(snd_seq_open(&seq, "hw", SND_SEQ_OPEN_DUPLEX, 0) < 0)) {
        fprintf(stdout, "\nALSA sequencer successfully opened\n");
    }
}

AlsaHandle::~AlsaHandle() {

    snd_seq_close(seq);
}

void AlsaHandle::alsaAnnounce(int fd) {
 
    snd_seq_event_t *ev;

    snd_seq_event_input(seq, &ev);
    snd_seq_free_event(ev);
}
