/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wikiwizard.CopyAndPastePopup;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.observeModul;

public class LinkDialog
extends JDialog
implements KeyListener,
FocusListener,
ActionListener,
MouseListener {
    private observeModul obsable;
    private JTextField name;
    private JComboBox url;
    private JButton insertButton;
    private JButton cancelButton;
    private WikiWizardApplet wiki;
    private JApplet owner;
    private ResourceBundle bundle = null;
    private boolean replace;
    private boolean renderer;
    private boolean table;
    private CopyAndPastePopup popupMenu = new CopyAndPastePopup();
    Font menuFontSize = new Font("Dialog", 0, 12);

    public LinkDialog(JDialog d, boolean table, boolean renderer, Object obs, String labelText, String urlText, boolean http) {
        super((Dialog)d, true);
        this.init(table, obs, labelText, urlText, http, this.replace);
    }

    public LinkDialog(JApplet d, boolean table, Object obs, String labelText, String urlText, boolean http, boolean replace) {
        super(JOptionPane.getFrameForComponent(d), true);
        this.init(table, obs, labelText, urlText, http, replace);
    }

    public void init(boolean table, Object obs, String labelText, String urlText, boolean http, boolean replace) {
        this.renderer = this.renderer;
        this.table = table;
        this.replace = replace;
        this.bundle = ResourceBundle.getBundle(WikiWizardApplet.resource_lang + ".ProgramStrings", WikiWizardApplet.locale);
        this.wiki = (WikiWizardApplet)obs;
        this.owner = (JApplet)obs;
        this.setTitle(this.bundle.getString("linkDialogTitle"));
        this.setModal(true);
        this.setLocationRelativeTo(this.owner);
        this.obsable = new observeModul();
        this.obsable.addObserver((Observer)obs);
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JLabel label = new JLabel("  " + this.bundle.getString("linkDialogURL") + " ");
        label.setFont(this.menuFontSize);
        pane.add((Component)label, c);
        StringTokenizer str = new StringTokenizer(this.wiki.trail, ";");
        this.url = new JComboBox();
        this.url.getEditor().getEditorComponent().addKeyListener(this);
        this.url.getEditor().getEditorComponent().addMouseListener(this);
        this.url.setEditable(true);
        urlText = urlText == null ? "" : urlText.trim();
        String[] pageName = new String[str.countTokens()];
        int i = -1;
        while (str.hasMoreElements()) {
            ++i;
            String item = (String)str.nextElement();
            boolean duplicateItem = false;
            for (int j = 0; j < i; ++j) {
                if (!item.equals(pageName[j])) continue;
                duplicateItem = true;
            }
            if (!duplicateItem && !item.equals(urlText)) {
                pageName[i] = item;
                continue;
            }
            --i;
        }
        this.url.addItem(urlText);
        while (i >= 0) {
            if (pageName[i] != null) {
                this.url.addItem(pageName[i]);
            }
            --i;
        }
        this.url.addFocusListener(this);
        this.url.setFont(this.menuFontSize);
        this.url.addKeyListener(this);
        pane.add((Component)this.url, c);
        c.gridy = 1;
        label = new JLabel("  " + this.bundle.getString("linkDialogName") + " ");
        label.setFont(this.menuFontSize);
        pane.add((Component)label, c);
        this.name = new JTextField(labelText, 20);
        this.name.addFocusListener(this);
        this.name.addMouseListener(this);
        this.name.setFont(this.menuFontSize);
        this.name.addKeyListener(this);
        pane.add((Component)this.name, c);
        ButtonGroup group = new ButtonGroup();
        JPanel panel = new JPanel();
        this.cancelButton = new JButton(this.bundle.getString("linkDialogCancelButton"));
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(0, 20, 0, 0);
        this.cancelButton.setFont(this.menuFontSize);
        pane.add((Component)this.cancelButton, c);
        this.insertButton = new JButton(this.bundle.getString("linkDialogInsertButton"));
        c.gridx = 2;
        c.gridy = 0;
        this.insertButton.setFont(this.menuFontSize);
        pane.add((Component)this.insertButton, c);
        this.insertButton.addActionListener(this);
        this.insertButton.getRootPane().setDefaultButton(this.insertButton);
        this.insertButton.setDefaultCapable(true);
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        TravPolicyLinkDialog policyLinkDialog = new TravPolicyLinkDialog();
        this.setFocusTraversalPolicy(policyLinkDialog);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.setVisible(false);
            this.wiki.getTextWindow().requestFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        Object source = evt.getSource();
        if (arg.equals(this.bundle.getString("linkDialogInsertButton"))) {
            if (!this.table && !this.renderer) {
                this.obsable.input("Insert LinkDialog");
            } else if (this.renderer) {
                this.obsable.input("Insert LinkDialog Renderer");
            } else {
                this.obsable.input("Insert LinkDialog in table");
            }
            this.hide();
        }
        if (arg.equals(this.bundle.getString("linkDialogCancelButton"))) {
            if (!this.table && !this.renderer) {
                this.obsable.input("Beende LinkDialog");
            } else if (this.renderer) {
                this.obsable.input("Beende LinkDialog Renderer");
            } else {
                this.obsable.input("Beende LinkDialog in table");
            }
            this.hide();
        }
    }

    public boolean getReplace() {
        return this.replace;
    }

    public String getName() {
        try {
            return this.name.getText();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getURL() {
        try {
            return (String)this.url.getSelectedItem();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void show() {
        super.show();
        this.setLocationRelativeTo(this.owner);
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
    }

    class TravPolicyLinkDialog
    extends FocusTraversalPolicy {
        TravPolicyLinkDialog() {
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return LinkDialog.this.url;
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return LinkDialog.this.url;
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return LinkDialog.this.cancelButton;
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent == LinkDialog.this.url.getEditor().getEditorComponent()) {
                return LinkDialog.this.name;
            }
            if (aComponent == LinkDialog.this.name) {
                return LinkDialog.this.insertButton;
            }
            if (aComponent == LinkDialog.this.insertButton) {
                return LinkDialog.this.cancelButton;
            }
            if (aComponent == LinkDialog.this.cancelButton) {
                return LinkDialog.this.url;
            }
            return LinkDialog.this.url;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent == LinkDialog.this.url.getEditor().getEditorComponent()) {
                return LinkDialog.this.cancelButton;
            }
            if (aComponent == LinkDialog.this.cancelButton) {
                return LinkDialog.this.insertButton;
            }
            if (aComponent == LinkDialog.this.insertButton) {
                return LinkDialog.this.name;
            }
            if (aComponent == LinkDialog.this.name) {
                return LinkDialog.this.url;
            }
            return LinkDialog.this.url;
        }
    }
}

