/*
 * Decompiled with CFR 0.152.
 */
package net.iamvegan.multipartrequest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.iamvegan.multipartrequest.EmptyInputStream;

public class MultipartFile {
    private String m_fieldName;
    private String m_fileName;
    private File m_tmpFile;
    private byte[] m_fileContents;
    private long m_fileSize;
    private String m_contentType;

    public MultipartFile(String fieldName, String fileName, String contentType, long fileSize, File tmpFile) {
        this.m_fieldName = fieldName;
        this.m_fileName = fileName;
        this.m_contentType = contentType;
        this.m_tmpFile = tmpFile;
        this.m_fileSize = fileSize;
    }

    public MultipartFile(String fieldName, String fileName, String contentType, long fileSize, byte[] fileContents) {
        this.m_fieldName = fieldName;
        this.m_fileName = fileName;
        this.m_contentType = contentType;
        this.m_fileContents = fileContents;
        this.m_fileSize = fileSize;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public String getName() {
        return this.m_fileName;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public long getSize() {
        return this.m_fileSize;
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_tmpFile != null) {
            return new FileInputStream(this.m_tmpFile);
        }
        if (this.m_fileContents != null) {
            return new ByteArrayInputStream(this.m_fileContents);
        }
        return new EmptyInputStream();
    }

    public String toString() {
        return "filename=" + this.m_fileName + "; contentType=" + this.m_contentType + "; m_fileSize=" + this.m_fileSize;
    }
}

