(in-package :crypto-tests)


;;; standard tests

(digest-test "" "d41d8cd98f00b204e9800998ecf8427e")
(digest-test "a" "0cc175b9c0f1b6a831c399e269772661")
(digest-test "abc" "900150983cd24fb0d6963f7d28e17f72")
(digest-test "message digest" "f96b697d7cb7938d525a2f31aaf161d0")
(digest-test "abcdefghijklmnopqrstuvwxyz" "c3fcd3d76192e4007dfb496cca67e13b")
(digest-test "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" "d174ab98d277d9f5a5611c2c9f419d9f")
(digest-test "12345678901234567890123456789012345678901234567890123456789012345678901234567890" "57edf4a22be3c955ac49da2e2107b67a")


;;; bit-level tests from NESSIE (http://www.cryptonessie.org/)

(digest-bit-test 0 #x80 63 "D100ADC7D963AC0B837F7AC29DC701D7")
(digest-bit-test 0 #x40 63 "5946DFD41CC23659B3A6671B61BEEBD5")
(digest-bit-test 0 #x20 63 "DEC544A38537D47AE3074C1B1FE258CE")
(digest-bit-test 0 #x10 63 "F86BBABF1921DDE8BDA8BFD280C7EF42")
(digest-bit-test 0 #x08 63 "F5504FB61B4A45F425A7E81A5EE46F9D")
(digest-bit-test 0 #x04 63 "6D0FE6F22A181464E6445CECCC9F0637")
(digest-bit-test 0 #x02 63 "B17122050F10191A428685C69D6443FC")
(digest-bit-test 0 #x01 63 "BC5481E124C00F21E314EF579DC23C42")
(digest-bit-test 1 #x80 62 "E0D1D11DB4A1920B5D1E2AC3C8FF2EE5")
(digest-bit-test 1 #x40 62 "B41789204BFB001544CF30C99B80C2BF")
(digest-bit-test 1 #x20 62 "427E645F8141751530520C4AEDF94AF6")
(digest-bit-test 1 #x10 62 "313E604ACFFC20F994BC77A5338868F9")
(digest-bit-test 1 #x08 62 "0A53C1D28669E7E0E50FCDF88C8127C5")
(digest-bit-test 1 #x04 62 "22589A024E2B52B44365C84BF9053EAB")
(digest-bit-test 1 #x02 62 "B0052285C8B28883ADDD0728B85A7FA2")
(digest-bit-test 1 #x01 62 "77598FEF54DCD2A8AF4062FEC8EA07D0")
(digest-bit-test 2 #x80 61 "C0516F144ADA2C0093BFEA89C9FA5CEF")
(digest-bit-test 2 #x40 61 "1A4AAB1565206E54831978864E6B4E98")
(digest-bit-test 2 #x20 61 "ED46B74E2F7904F49E2FF64038EFC620")
(digest-bit-test 2 #x10 61 "A60F5E85EB851E6367428340BF949D7A")
(digest-bit-test 2 #x08 61 "26770E1F01C793D8363B79CEF5594749")
(digest-bit-test 2 #x04 61 "71878DF60B5DF9A34B1064ED509F3B07")
(digest-bit-test 2 #x02 61 "C372906819C3B158A5A91FD08332EEE8")
(digest-bit-test 2 #x01 61 "5E468347458E0171D2459B72FA762A5D")
(digest-bit-test 3 #x80 60 "4A3D18FB567AB08710581C9810B3C1F1")
(digest-bit-test 3 #x40 60 "AD2FBD456923D0405A7413463E26FC91")
(digest-bit-test 3 #x20 60 "4B94D72B5CB2CF60E1360035A6A823A9")
(digest-bit-test 3 #x10 60 "562A13C1BC97451ACB25584C7741EECA")
(digest-bit-test 3 #x08 60 "97C6A1580F949812E5FEEE45F0DF91E5")
(digest-bit-test 3 #x04 60 "711EB2C46C3E465BCF05204A829D75DB")
(digest-bit-test 3 #x02 60 "BE9AA44A92B42D0740A59FC3EF96C59B")
(digest-bit-test 3 #x01 60 "841A0BCE1788101C5E650ABFA1367509")
(digest-bit-test 4 #x80 59 "D51020E2512CEF1F19781497A8065252")
(digest-bit-test 4 #x40 59 "03380DEF2104B313079E26A20D65A67C")
(digest-bit-test 4 #x20 59 "486D95AC56F4A12878676E896E0A6279")
(digest-bit-test 4 #x10 59 "ED0289B0EA4570C831F880A0007F7404")
(digest-bit-test 4 #x08 59 "667FFB9C10ACBAF700E30EA0C0497BA8")
(digest-bit-test 4 #x04 59 "151C00A49855680BA36700676857A8F4")
(digest-bit-test 4 #x02 59 "CA7CD07DA0E6EDA1040613CF4B70777E")
(digest-bit-test 4 #x01 59 "71DA93F3E01AE2945AED2BC4F5052C53")
(digest-bit-test 5 #x80 58 "421AD4DBECDDCCB0138E6A2AC0E4F6FC")
(digest-bit-test 5 #x40 58 "30BFC0E8F8C2FC95773138BC8DA947B6")
(digest-bit-test 5 #x20 58 "9D3A13F27EB032F2687D8E6D1788D61E")
(digest-bit-test 5 #x10 58 "0BE383B2766ED8B575B9040BC0D42EF5")
(digest-bit-test 5 #x08 58 "4427BC6CC79301E7A26C2A3D8ECB6E10")
(digest-bit-test 5 #x04 58 "534D98E515BA47AACF89E3C351887F68")
(digest-bit-test 5 #x02 58 "8A8A0244B9B3F6F3C0330CBC34304522")
(digest-bit-test 5 #x01 58 "E54B50B64867080469586A3A2B3EF892")
(digest-bit-test 6 #x80 57 "873821E3ED8865BC96639C18B23A9A44")
(digest-bit-test 6 #x40 57 "757E17C903DF12EA67252CBA283B66A0")
(digest-bit-test 6 #x20 57 "D344B3E83A02BCF8D75CF6E5FBEBFCF7")
(digest-bit-test 6 #x10 57 "08A482079AED8725E0A41DA42F3BCF88")
(digest-bit-test 6 #x08 57 "B148E58BB47D90595E34EFD04A6BF45C")
(digest-bit-test 6 #x04 57 "FEE2CB77ABF8EE1DBE1FE5112C05EBE7")
(digest-bit-test 6 #x02 57 "4A5DB81DDB230FEBA62388CD585EDFF6")
(digest-bit-test 6 #x01 57 "2B48DCA04A1CB4CCCF74D8C8AEF831E0")
(digest-bit-test 7 #x80 56 "D6B3AA2679C44FFF034482620FC4B6C4")
(digest-bit-test 7 #x40 56 "651C77103A6CAA2DDD64253AB619DCEC")
(digest-bit-test 7 #x20 56 "4DA303D58A562B00FD3A168750A5DC51")
(digest-bit-test 7 #x10 56 "13670CF998C2E742F0466D414B10FE03")
(digest-bit-test 7 #x08 56 "0846D2C1F7202CC2DC62B40E23AD1604")
(digest-bit-test 7 #x04 56 "09F09DA03DE4AB2FDCD34A101AA71560")
(digest-bit-test 7 #x02 56 "55876BC89EB5D8A45A063F46A758C83D")
(digest-bit-test 7 #x01 56 "FF2719AE2554BA4C0EB721799CDA860E")
(digest-bit-test 8 #x80 55 "99B6A99F2BF6E8DFEAE34BC1B8BEA0FE")
(digest-bit-test 8 #x40 55 "153A4356041A8AFC4610244D059D625C")
(digest-bit-test 8 #x20 55 "ADFF5B78D55AF02CA60DC92EE7A5FB72")
(digest-bit-test 8 #x10 55 "7B25E849B8EF1F651A85707D0B673CE7")
(digest-bit-test 8 #x08 55 "3B81887F8FCBD61A81E98257DBE82814")
(digest-bit-test 8 #x04 55 "3640E4FC3D96346AACC19CE13197BC26")
(digest-bit-test 8 #x02 55 "9F392C0A01B3F31C872501D822E123B1")
(digest-bit-test 8 #x01 55 "FA534E290740E8DF8637C76F1904518B")
(digest-bit-test 9 #x80 54 "1C0098B2775421532A7CB1844DD304D9")
(digest-bit-test 9 #x40 54 "CA4123F709792AABD8593207AA3D870E")
(digest-bit-test 9 #x20 54 "5425E8B0EFCD62EA3E1C5F1798E5057C")
(digest-bit-test 9 #x10 54 "671ABDDEE265899ABEEB777C26FE0628")
(digest-bit-test 9 #x08 54 "3D78D853674651BE79F7EEB985D66CA0")
(digest-bit-test 9 #x04 54 "6EE70CE7ACAC7BBFCAA5918FC7D7A231")
(digest-bit-test 9 #x02 54 "5A8CD68C9E7EBB8EC286F95527E1FABD")
(digest-bit-test 9 #x01 54 "A3B9360D025565B5BBB74E11EB4CCAF6")
(digest-bit-test 10 #x80 53 "FF3A4D6DA7A8C8C223B784F7BB89D3A0")
(digest-bit-test 10 #x40 53 "9B2E198A717FF73011A49E4436A993EB")
(digest-bit-test 10 #x20 53 "3FE32E36378A361D53811CBB3B65E036")
(digest-bit-test 10 #x10 53 "CBA94A4C71DE66B971CC1D1715B4BF97")
(digest-bit-test 10 #x08 53 "4FFB7C963D0504F6D0F76D3A74982371")
(digest-bit-test 10 #x04 53 "C540F2FF6F64B3F8201CA26DEDF38982")
(digest-bit-test 10 #x02 53 "7BD5B7EDB6049EB30E29F7AA381D8BA9")
(digest-bit-test 10 #x01 53 "4A0630379B12E49EEE8212350A936463")
(digest-bit-test 11 #x80 52 "712E4057E7BD5A9E2F37F24557FE8AD8")
(digest-bit-test 11 #x40 52 "EF98CA91A9657B23B153EFC5711A97C2")
(digest-bit-test 11 #x20 52 "66C77963623201ACADD590E332DCB36A")
(digest-bit-test 11 #x10 52 "EE1FA779386BF3ABDFE5B1CDA730BF1F")
(digest-bit-test 11 #x08 52 "FA9A2E663AEFB2A3EF14DF8407CC3CC7")
(digest-bit-test 11 #x04 52 "F03821A6191AED4FA02B66A9C7F71C63")
(digest-bit-test 11 #x02 52 "53A7A4B6D595901360F4507D9362D11F")
(digest-bit-test 11 #x01 52 "58507FDADC715BB403A179FE094FDB3F")
(digest-bit-test 12 #x80 51 "C6A4255B565F0B7FA5F3BF239B3CE550")
(digest-bit-test 12 #x40 51 "331A4C06F709E2BCE0E5331BCD8770F5")
(digest-bit-test 12 #x20 51 "10733E1F79C2B5C1F78C688C43A3CD19")
(digest-bit-test 12 #x10 51 "FD5DDB64A262D775FEAFECBE6B196361")
(digest-bit-test 12 #x08 51 "D23F63302AE2F9D987D50641A74D09CD")
(digest-bit-test 12 #x04 51 "206693D8C90F7FC826820AAD553FB3C0")
(digest-bit-test 12 #x02 51 "54571E2A04C159B9CD187E84CD591B5D")
(digest-bit-test 12 #x01 51 "5FD2ACD825D46FBB58EB912A263D0144")
(digest-bit-test 13 #x80 50 "4000D3A40B0CB27806530E25F2CF1645")
(digest-bit-test 13 #x40 50 "3129198B6D899EAF6355AA9038E76D25")
(digest-bit-test 13 #x20 50 "D8D03681175ADBF8F46242C2EB7DC855")
(digest-bit-test 13 #x10 50 "E33B91B2D6B65749DCD7BFD16FF6496D")
(digest-bit-test 13 #x08 50 "BCC9EF044C7D4A807D7BA8DE5ABD9DA0")
(digest-bit-test 13 #x04 50 "48277E4B13A266FF3389F2A5D219A341")
(digest-bit-test 13 #x02 50 "04B174213538AAD2F2546F8CDA4E1AE3")
(digest-bit-test 13 #x01 50 "1C2D889EABE9B8DF20AF4F82CB8E9F32")
(digest-bit-test 14 #x80 49 "2CC4983246D6613B913C46A9A9626AC0")
(digest-bit-test 14 #x40 49 "CA27C85CB612740C0B811B117080104E")
(digest-bit-test 14 #x20 49 "15E7103C17842034916397988BBE4179")
(digest-bit-test 14 #x10 49 "52C6EFB891B43888B59871EE62DE12C4")
(digest-bit-test 14 #x08 49 "B62131086AFE3EA0965181CC25A4271C")
(digest-bit-test 14 #x04 49 "F14EB6ABA0B197361A0008A2F7BD2C17")
(digest-bit-test 14 #x02 49 "28DEDF5CD293E20E8D4724DE72EF21B4")
(digest-bit-test 14 #x01 49 "D734625FCFCECAE9E6422BC9B0E25C09")
(digest-bit-test 15 #x80 48 "4837F0FC7F4477E20897DC342E8A441A")
(digest-bit-test 15 #x40 48 "1707597D3776B9FC9FA1880174591AF2")
(digest-bit-test 15 #x20 48 "BF7B65F71482D88575422D0ED5B45F6B")
(digest-bit-test 15 #x10 48 "D249809882892BAED703041E78B4E31F")
(digest-bit-test 15 #x08 48 "80D4B2EFDAE671E9201C6EE54CF24744")
(digest-bit-test 15 #x04 48 "A7517BC483991C3D517DAD8CB22AE90A")
(digest-bit-test 15 #x02 48 "4FEC09054AF195AEE8BE25A69EEDAE9D")
(digest-bit-test 15 #x01 48 "E8E8BBD894CC2E34C30580319F434B0D")
(digest-bit-test 16 #x80 47 "B8BC4C030D9B5E7C21DAD46C64A01D47")
(digest-bit-test 16 #x40 47 "2FE6FF005BD3DD6B7A0DD2E19B494D86")
(digest-bit-test 16 #x20 47 "1F19F7138EF63D8E204761C6F94D7A66")
(digest-bit-test 16 #x10 47 "4D068C3202A3E6672D423E18F2376590")
(digest-bit-test 16 #x08 47 "1E9952941C130B19BB856BF7C575D776")
(digest-bit-test 16 #x04 47 "B697FEB25C0DBE9B15AAF267CA43FB00")
(digest-bit-test 16 #x02 47 "155EA0621E9038C14C0731059589FD1C")
(digest-bit-test 16 #x01 47 "BD0C6E70CD8BDD76D1A785E807758744")
(digest-bit-test 17 #x80 46 "9D769C10174B8913F7E8169AE915A753")
(digest-bit-test 17 #x40 46 "025001736462C0854B38E97E36A6A722")
(digest-bit-test 17 #x20 46 "BAAE5CD4937CE794C123719159FB04C3")
(digest-bit-test 17 #x10 46 "3308EF5BBED8073DF6C40840B7CB1949")
(digest-bit-test 17 #x08 46 "87162A4A837FD93A5E917C697471C471")
(digest-bit-test 17 #x04 46 "C6F9639643E42CE1CD58FF5B1FC77F54")
(digest-bit-test 17 #x02 46 "04684925D5CB72903C75586AFB22F824")
(digest-bit-test 17 #x01 46 "0EB1E65C388190160ECF5A1B0B9D6264")
(digest-bit-test 18 #x80 45 "C7257CEB571C737132D11B6521BE67EA")
(digest-bit-test 18 #x40 45 "EE7648EF561CAE348C3DCC1344CA2D8D")
(digest-bit-test 18 #x20 45 "18715BA9CAA905F7D42EE35BB9B6DAF0")
(digest-bit-test 18 #x10 45 "81F7169AA6B34763F37EC296EDF8E777")
(digest-bit-test 18 #x08 45 "16C8DFFC05C2E5A3FAB785169F655EA1")
(digest-bit-test 18 #x04 45 "945DBB32B439F6746C1DCA85BCC19650")
(digest-bit-test 18 #x02 45 "507294EA0591C0E74EAA016663A9D41B")
(digest-bit-test 18 #x01 45 "DE75CF7B97DBB781D9B7B5D4AE8204C7")
(digest-bit-test 19 #x80 44 "85D06D83AE3EF12D42A55DF38DE3905D")
(digest-bit-test 19 #x40 44 "515433D6CD023AA480E8E111DC43C7B5")
(digest-bit-test 19 #x20 44 "9839348A2E202C867FF409B2AD90E8E3")
(digest-bit-test 19 #x10 44 "E8FB9977E83A56190180A77BF3CF73A0")
(digest-bit-test 19 #x08 44 "5B80805194B94E300C6356B9316E0485")
(digest-bit-test 19 #x04 44 "086E40611F0649CC5B330A0BCD430411")
(digest-bit-test 19 #x02 44 "48C94CC7533CAB43EDBCC9828F0416C8")
(digest-bit-test 19 #x01 44 "2B6F068A88D555E2E7802FC8A045EA47")
(digest-bit-test 20 #x80 43 "2A346699E7C039F552426ACA283A666B")
(digest-bit-test 20 #x40 43 "E302E0A7AF88DC248AE8EDC617197A36")
(digest-bit-test 20 #x20 43 "6A7F062A9765B7E72FA96FA90DDD143E")
(digest-bit-test 20 #x10 43 "CDBFDCC221EB2FFAA3786130098C8592")
(digest-bit-test 20 #x08 43 "F5A9AFB7A3C5007C5AEE6ECFAAE9B40C")
(digest-bit-test 20 #x04 43 "D5B00318E61E0F34BD1487EE222F7080")
(digest-bit-test 20 #x02 43 "333CD297065AF4A6895006E9D4280142")
(digest-bit-test 20 #x01 43 "32A631DB7E2CEEBDBEAFB4F875024DE8")
(digest-bit-test 21 #x80 42 "AE560D63E7BB6F828FE0F86ADF29F86C")
(digest-bit-test 21 #x40 42 "9CE9366DA2449989DD4EB7124B1424A3")
(digest-bit-test 21 #x20 42 "BAD0D7713C2C6913C46F7F1A2A92B4A4")
(digest-bit-test 21 #x10 42 "FD5D05F5B5EB324A2B594BA8D2435825")
(digest-bit-test 21 #x08 42 "58E5890DD2E1DAA3F911EC6A9C33B88F")
(digest-bit-test 21 #x04 42 "368AEBF2535160286C1508E8B0D8015A")
(digest-bit-test 21 #x02 42 "F9BBF1F99BA8DE645D5DA4E4FC661B13")
(digest-bit-test 21 #x01 42 "618688BF18F0A630D8AA26E0644FB20D")
(digest-bit-test 22 #x80 41 "1EFCDB0E7B1510826FB1073DF48AA5EA")
(digest-bit-test 22 #x40 41 "0D7D9124EA411E52CA2B01FFA1EE292A")
(digest-bit-test 22 #x20 41 "BDA259C306268A65B348B575C2CA72CA")
(digest-bit-test 22 #x10 41 "A3221BD958FEE82FF3C0374885B33138")
(digest-bit-test 22 #x08 41 "3ECFA4CF473A94AC01EB576427B2620E")
(digest-bit-test 22 #x04 41 "75A2FE3A9471A0D8D45EE5756C46DBD5")
(digest-bit-test 22 #x02 41 "3106D91DCF01FDCF28203F8F2D9100DB")
(digest-bit-test 22 #x01 41 "8B80DF449634ADD584C56EC82FA8B491")
(digest-bit-test 23 #x80 40 "7642C132B0FF94C2585BFAB0DDD7F6AB")
(digest-bit-test 23 #x40 40 "1D5E6A65A4ACA67ECD46104B81BE50CB")
(digest-bit-test 23 #x20 40 "60E861BC3EDB744A966B43EBEDA7B56E")
(digest-bit-test 23 #x10 40 "6D0BD086D12CEF697B746334883AE196")
(digest-bit-test 23 #x08 40 "50B7EC4B54BDBBA0EF6D56765B29E2C0")
(digest-bit-test 23 #x04 40 "20D8A4B3C11A4759963AF7A6429FA2C3")
(digest-bit-test 23 #x02 40 "98FE37C528A7AE0E341B3DBCCD98EEA6")
(digest-bit-test 23 #x01 40 "33D64C0B4E5A9E444252F0738B9C2DE0")
(digest-bit-test 24 #x80 39 "5D2BE56802387E0D53C4374EEB8C82B6")
(digest-bit-test 24 #x40 39 "5CB0C473C47139C526BDDB60043C68C2")
(digest-bit-test 24 #x20 39 "EF271AF9F4401397DDB402C99A4F0F4E")
(digest-bit-test 24 #x10 39 "72BF2334299E719FA84844CED300CD4A")
(digest-bit-test 24 #x08 39 "E3FD2AC469580923C48AEE429B3562CB")
(digest-bit-test 24 #x04 39 "267A19F7B8E18E2B4E720432139B6E8C")
(digest-bit-test 24 #x02 39 "381382D00904888081A9552B81ED36BB")
(digest-bit-test 24 #x01 39 "824D1F79E689A04CFD5EE69DDC580BE2")
(digest-bit-test 25 #x80 38 "357C82CE0EB4F6F667DEF290C0D1D120")
(digest-bit-test 25 #x40 38 "D389C3A8975C0AACB44104CCF632C1F8")
(digest-bit-test 25 #x20 38 "03631F92DA0C67552BF7A026D679F723")
(digest-bit-test 25 #x10 38 "CB0A3236BB2F2DC7B785BA63676A964D")
(digest-bit-test 25 #x08 38 "79AC06CCCD507714BD453964ED787677")
(digest-bit-test 25 #x04 38 "83B33925BED3AC0EB4F9AF6BC75F0D8B")
(digest-bit-test 25 #x02 38 "221A948B265FA265ED0217AFA9448AC9")
(digest-bit-test 25 #x01 38 "358FBC82B38B0A24D4AF61C87D6C62A5")
(digest-bit-test 26 #x80 37 "66D9F3919AE352F3F16246EAD3074E75")
(digest-bit-test 26 #x40 37 "84136628469F13A6D30C2F81D9FB8709")
(digest-bit-test 26 #x20 37 "6B8D6430324A11559E31A92743F16644")
(digest-bit-test 26 #x10 37 "F009B9C33611966B29B945EB38D2B130")
(digest-bit-test 26 #x08 37 "DED34074FEDFCDBBCC4DA3074AEB5087")
(digest-bit-test 26 #x04 37 "6A528A222478BCA9DFBFAC2A00B64E15")
(digest-bit-test 26 #x02 37 "22C5635999C532034A3FBE8CCA3BFBAE")
(digest-bit-test 26 #x01 37 "0C9193A1124BD00CEBB09A05CA6BAC7D")
(digest-bit-test 27 #x80 36 "9EE0BA3AFFBC9610FBB0C1F93F98E957")
(digest-bit-test 27 #x40 36 "40F6E1BAB20BC825462FA8B84B029E03")
(digest-bit-test 27 #x20 36 "479AA5097DB0D27D906967DFE0359B94")
(digest-bit-test 27 #x10 36 "4EE4F2F35E36A2729EA0BB07658CEF83")
(digest-bit-test 27 #x08 36 "A7D27906D1889C91C565FEB36D3E41E5")
(digest-bit-test 27 #x04 36 "488D5CD0C76DEEB44D839F0280F42BD8")
(digest-bit-test 27 #x02 36 "3383D0E16168120B3A440D5CB517E65C")
(digest-bit-test 27 #x01 36 "049F7E9F7A579E9DC8CB2E90370B7DFD")
(digest-bit-test 28 #x80 35 "F15759B10756BBC1F057174E11FBEA3C")
(digest-bit-test 28 #x40 35 "9E915844865C745CDDAAE9086D67CB7C")
(digest-bit-test 28 #x20 35 "3C5A2485AA83037AE41529AE190DF88B")
(digest-bit-test 28 #x10 35 "871E522A6D16C4A0E000C8809F9EC5F6")
(digest-bit-test 28 #x08 35 "968B472E57E76D5D1E63476B38C58816")
(digest-bit-test 28 #x04 35 "E662F9A0CE1298E18FE149BEE0504AB0")
(digest-bit-test 28 #x02 35 "30C3AE4FBC27B9ECD88BBC21D8B3F55D")
(digest-bit-test 28 #x01 35 "B4DC26D3BFED9ED9BBE0DBAF21DD95FF")
(digest-bit-test 29 #x80 34 "F0EDA2E5CB682C4C82A6DED6E1A9E4E2")
(digest-bit-test 29 #x40 34 "AE6E5FE9CD9B0B8FBBA08D86A73C1FC9")
(digest-bit-test 29 #x20 34 "B0AF28AB9D0FC7EEE36A757E9A1ED66B")
(digest-bit-test 29 #x10 34 "70F0627C98DF0A4282D20B07A6A05BA1")
(digest-bit-test 29 #x08 34 "7CE886342A970ED79132994AA682BEBC")
(digest-bit-test 29 #x04 34 "25313BE41F42B3D30E1CD065D73ACDD7")
(digest-bit-test 29 #x02 34 "A90FA5EBF49DD9F4E77716C3C1E9765D")
(digest-bit-test 29 #x01 34 "1F9DD8FC6AC8EFBC2D378D6AB44AAFE7")
(digest-bit-test 30 #x80 33 "4B0858EEB2639659EACA7B7B7C3349A5")
(digest-bit-test 30 #x40 33 "5E8280869101EF49835627FDFB13E5D3")
(digest-bit-test 30 #x20 33 "0B495C962E6799B67D93F1B5B590C844")
(digest-bit-test 30 #x10 33 "4DC7D22B8F29BEB964B2965191A11463")
(digest-bit-test 30 #x08 33 "60768F63CFA2E88A75367561DF60FA01")
(digest-bit-test 30 #x04 33 "009B7E32759B44054975D918DA7424CC")
(digest-bit-test 30 #x02 33 "DC82A437FF020C9C9BC699ADF214D937")
(digest-bit-test 30 #x01 33 "904D158775D4A8666D663AD2FB2E79A1")
(digest-bit-test 31 #x80 32 "FC6B5B1628894C202D19C36A29BE2C98")
(digest-bit-test 31 #x40 32 "AA186F907E4A59827646EC5DA8CB4B8C")
(digest-bit-test 31 #x20 32 "C889405D3292C5F4866E2B82EB743FDB")
(digest-bit-test 31 #x10 32 "2ACD03AC14947052515B8F311F759093")
(digest-bit-test 31 #x08 32 "B4CDCE550EF4285C2851EF81B479FDE8")
(digest-bit-test 31 #x04 32 "9D1FD01C05A09169E37ED94562BAAAF5")
(digest-bit-test 31 #x02 32 "E97333985B140C769EF4CDBF13B5FBA3")
(digest-bit-test 31 #x01 32 "29911578E644BDF6257D23B8D4DD0D38")
(digest-bit-test 32 #x80 31 "ED9D395824171A7F82A0CB538433A22B")
(digest-bit-test 32 #x40 31 "101BE3EECE1ED26CE794B90C6C5D0460")
(digest-bit-test 32 #x20 31 "89B836293A99ED6E02D5DADE0121AC20")
(digest-bit-test 32 #x10 31 "AEBBF1CFCA7CCE6941FA0B93B9E58B7A")
(digest-bit-test 32 #x08 31 "C4714103FA3E1AC58C9AB450F4567764")
(digest-bit-test 32 #x04 31 "499F861EE4EFB2FB38A00B97EFF10010")
(digest-bit-test 32 #x02 31 "D95C0AD5BB39C47DB3B0D6EE7F354444")
(digest-bit-test 32 #x01 31 "FB0E49A8512A6514C8E52E8F302C1313")
(digest-bit-test 33 #x80 30 "92ACEF120453F4AF4AC41BF1970D7356")
(digest-bit-test 33 #x40 30 "1F9836EE1AFDB7972819B91ABF856A4E")
(digest-bit-test 33 #x20 30 "0C3D4612FC048FDAA32E4A94B6F1386F")
(digest-bit-test 33 #x10 30 "7CE5B968386A1AC3759B4B4BA636D939")
(digest-bit-test 33 #x08 30 "4250DA118C52D1BCD8C76D657535EC5E")
(digest-bit-test 33 #x04 30 "07A7BDC93E71936D4358FF104F5C6F2B")
(digest-bit-test 33 #x02 30 "39069C6B6051F6F0D270A0E04E91369E")
(digest-bit-test 33 #x01 30 "882EE17FB046D8A07610C313AC5915DF")
(digest-bit-test 34 #x80 29 "BEBF589B9A2561EDA0E6A08221882759")
(digest-bit-test 34 #x40 29 "96C91B562423BCD0727E0A0731D797AC")
(digest-bit-test 34 #x20 29 "421B5C3068FC2555A4DF70B3817B8780")
(digest-bit-test 34 #x10 29 "43D4E2EA49CD56875A788AE9E892D9C5")
(digest-bit-test 34 #x08 29 "67FDD0B32AC1C39FC3331B3CAF957E2E")
(digest-bit-test 34 #x04 29 "3B1290877EE8C9D6C0785D7D08B13578")
(digest-bit-test 34 #x02 29 "239986662C2E2FDD2DA5C8EBD9AC78B4")
(digest-bit-test 34 #x01 29 "1FDF66EA7A8791B4DBD42B3D97624788")
(digest-bit-test 35 #x80 28 "6831072E80D199D3C4A348AE6DD143D0")
(digest-bit-test 35 #x40 28 "9470D664B893EFF4D79B36ED46D9493F")
(digest-bit-test 35 #x20 28 "4B635B3106408769F8F1CD71EF4AF402")
(digest-bit-test 35 #x10 28 "FC7ABB2218193926602C5BE159EF2157")
(digest-bit-test 35 #x08 28 "8F6D97EC60BBF7BE9F9E2DE37B495D9D")
(digest-bit-test 35 #x04 28 "A921143B8BCA6CAC4B44D946E5948537")
(digest-bit-test 35 #x02 28 "DD2EB5678E96DE9148B8851680016F63")
(digest-bit-test 35 #x01 28 "04F0A7E368A6FEF21524BEB4DC5310C2")
(digest-bit-test 36 #x80 27 "07BED9042B3422E6158DA127D4C2BD60")
(digest-bit-test 36 #x40 27 "D47C8F862F2A5DA9FAA888FDA124808B")
(digest-bit-test 36 #x20 27 "C2C749BF832F924E379EAC89959694C3")
(digest-bit-test 36 #x10 27 "4096823ABA928A856D6724FD91C57D3D")
(digest-bit-test 36 #x08 27 "B731BBD56CFC1E3EFB11F717E494EA82")
(digest-bit-test 36 #x04 27 "A4F83A8ACD7A56B5200834DFF5ABA455")
(digest-bit-test 36 #x02 27 "1ECA937A011FD3C181A455D5DCDDAC73")
(digest-bit-test 36 #x01 27 "F481C363C8AB7EF5AC2DD6B4389BF62F")
(digest-bit-test 37 #x80 26 "5E6906AD1D5495F44366D61FDD593689")
(digest-bit-test 37 #x40 26 "033F089D5B15DF34AEE9862A2998B190")
(digest-bit-test 37 #x20 26 "C5B96A88C4D30AC218A00FE8C8A5FE0E")
(digest-bit-test 37 #x10 26 "ECA700AA944E6014C5336A0A797E9EA5")
(digest-bit-test 37 #x08 26 "9822EA7178B96DC5156EF33477D9FFF6")
(digest-bit-test 37 #x04 26 "5EEEB310879425F489A2910A1E5BF85B")
(digest-bit-test 37 #x02 26 "09C86FFA6114D9356DDD340B829B8315")
(digest-bit-test 37 #x01 26 "9A7120E4C17EBCE75121C55F56EA7122")
(digest-bit-test 38 #x80 25 "B3632C95BCAB4E24EE5333AA2F28941B")
(digest-bit-test 38 #x40 25 "3C5C4A9AD5BA676E0F916621C4D09398")
(digest-bit-test 38 #x20 25 "723FD90024007F7103E98DA58890DE41")
(digest-bit-test 38 #x10 25 "8C83B58202FE44078263C22E3329B2A6")
(digest-bit-test 38 #x08 25 "4E8FD8E2758CD544E6682B987AE13820")
(digest-bit-test 38 #x04 25 "4B5A95DBC9911A08B27D33F5B606BC1C")
(digest-bit-test 38 #x02 25 "B8CE619A1D6B9956E0B54DB4B295994C")
(digest-bit-test 38 #x01 25 "4A5F3B1A66788529448A43F3E12AF39D")
(digest-bit-test 39 #x80 24 "DFEBB879EC199A81A4D3B4A8B435DD4C")
(digest-bit-test 39 #x40 24 "06F8D0A5735612DD5967037B7CDAC850")
(digest-bit-test 39 #x20 24 "E57BCB5946E8F7058DB6528F61C430FA")
(digest-bit-test 39 #x10 24 "D99EBFDA2BB73EED3665216E8C2A1CF1")
(digest-bit-test 39 #x08 24 "61C9AA0D28C04D6DD753EC855214149E")
(digest-bit-test 39 #x04 24 "3A6070C3732E697E7FC826E8EEB5094C")
(digest-bit-test 39 #x02 24 "063DEEAE397AE2C6F3A6AE4B98AB2C7A")
(digest-bit-test 39 #x01 24 "9D15B95AEB06B324A0134A1F9976DCB4")
(digest-bit-test 40 #x80 23 "434B09EA2CCB9C84EE9D5E53224A1AEF")
(digest-bit-test 40 #x40 23 "EC30D78EC1CE0EF63367AAEB083161BB")
(digest-bit-test 40 #x20 23 "CAA711A199F4A91B0B04DD7D7226ADE7")
(digest-bit-test 40 #x10 23 "4A7A550DEDFF320DDA0A5538EC0CAA5B")
(digest-bit-test 40 #x08 23 "EF5BF0E556BB02C413E3E721EE46CE8E")
(digest-bit-test 40 #x04 23 "AE78A69932F7567419555CB281CC43FB")
(digest-bit-test 40 #x02 23 "D4974DF3B1C5C570F9EDBBC36B4E0EFA")
(digest-bit-test 40 #x01 23 "66F4FC209A7DC510FD540DB13FA5A9D0")
(digest-bit-test 41 #x80 22 "D8B0C69B1460D390394B18A8291CCAE6")
(digest-bit-test 41 #x40 22 "842F8BAE44E33E459870B947FBA846A4")
(digest-bit-test 41 #x20 22 "19EE32DC24E80C8E41A1DE95B555C3DB")
(digest-bit-test 41 #x10 22 "5EC5971D4C35A16E4DF4957454C9AC67")
(digest-bit-test 41 #x08 22 "28712A9C1B541BF38BDD3579D050D5CB")
(digest-bit-test 41 #x04 22 "6A6B51E428A95BEEA6F4D4597296E03D")
(digest-bit-test 41 #x02 22 "14D77332F92E1C1BA396812696946307")
(digest-bit-test 41 #x01 22 "3494210E35210F36EF5863E9654FE203")
(digest-bit-test 42 #x80 21 "2153AFCA13686918AD74D84B91B3FD7E")
(digest-bit-test 42 #x40 21 "E8C2D6FDA486A004774D642971D299DE")
(digest-bit-test 42 #x20 21 "D8BFD743BAC554D9FAEE587568C779C9")
(digest-bit-test 42 #x10 21 "3C6D50F6E8B2DF1F0170DD1F5078005B")
(digest-bit-test 42 #x08 21 "904751732AD4A6DD1633F6F32FE15B6C")
(digest-bit-test 42 #x04 21 "6F6458AC973D5227EA1FA11BDDCF5C28")
(digest-bit-test 42 #x02 21 "3512A0D0699AB677C0E8D18AA60669F5")
(digest-bit-test 42 #x01 21 "D20E8CE906D28EB16A79AA50133D0390")
(digest-bit-test 43 #x80 20 "FA25C49644FE02B2DCC09B21DC80CC8C")
(digest-bit-test 43 #x40 20 "BEF7CB2C5BB419A274DB5F752B58789B")
(digest-bit-test 43 #x20 20 "4E5B96D2A37D53FAD56E1011F83A9B95")
(digest-bit-test 43 #x10 20 "F896E7E529BA2C51F35FA96713A90A54")
(digest-bit-test 43 #x08 20 "08A7042023558FEFE2EED405784152BC")
(digest-bit-test 43 #x04 20 "793B08BDBF6FE53A4DABF59D0F3065E9")
(digest-bit-test 43 #x02 20 "AA147CCCFE9C4D8DB5B53CB30DD9E06F")
(digest-bit-test 43 #x01 20 "5D59349615747260835F2453EEE6BC5B")
(digest-bit-test 44 #x80 19 "CC729FB233027898E5C518AF9B545EB0")
(digest-bit-test 44 #x40 19 "8B6E6D2982109FF64A86951CF1DB22E6")
(digest-bit-test 44 #x20 19 "2C979E5B5505F99C0285462C6E9A2585")
(digest-bit-test 44 #x10 19 "5E921F1CDB50574A1D42A318F72F4E06")
(digest-bit-test 44 #x08 19 "91C95A8DCA2CA8989CE17EC38A6388A7")
(digest-bit-test 44 #x04 19 "684120A9CFAB2CD256FA26077E98D848")
(digest-bit-test 44 #x02 19 "FBB5156D83A78CB68DC5DF712C253D1A")
(digest-bit-test 44 #x01 19 "3CB2BDC773A346D47EE802D67D547693")
(digest-bit-test 45 #x80 18 "DBF8F334AB91DED574DD285F8C000FF4")
(digest-bit-test 45 #x40 18 "0B46FA6EE628F27B47F0A4A2596EADEC")
(digest-bit-test 45 #x20 18 "EBDFAF3A03CB6F6B132DC4978D68995C")
(digest-bit-test 45 #x10 18 "1B8832D27893A6F8B971EF9145CAED46")
(digest-bit-test 45 #x08 18 "C7424DA41E411A7DBD0EBD1182DE61A3")
(digest-bit-test 45 #x04 18 "4E66E56FD2AD4E534C43A9976DB2C75E")
(digest-bit-test 45 #x02 18 "760C2D53D55FBD65E7DAED31E4F463CF")
(digest-bit-test 45 #x01 18 "D517E380A8C618BBA8169A905224AD4A")
(digest-bit-test 46 #x80 17 "3031C0316DE64B89C3E0780FE5C2ECE6")
(digest-bit-test 46 #x40 17 "E11DDBFE49C7D15D4605FE051F7DC13C")
(digest-bit-test 46 #x20 17 "6AAED62F00954A26BF916E0C245ACF42")
(digest-bit-test 46 #x10 17 "FF448413805677217C354881E17FD9E5")
(digest-bit-test 46 #x08 17 "908FD38B278D2DF6E24A13DD924C484D")
(digest-bit-test 46 #x04 17 "152F4843E348EFE4E73E74E0CF4B8219")
(digest-bit-test 46 #x02 17 "E21E3D6E39C1F98BFE666A2C69520211")
(digest-bit-test 46 #x01 17 "E07EA5D16AEB8431BFB016EE7BD0C5CC")
(digest-bit-test 47 #x80 16 "AFF6A755F2ABD47A06165D5C28E125BB")
(digest-bit-test 47 #x40 16 "DCE5532469BDD235444DF3608D98EBF0")
(digest-bit-test 47 #x20 16 "DA4808CEDCF6FD31715854CF73CC3383")
(digest-bit-test 47 #x10 16 "22D2C86CA8BE7782C2239D51CC285A52")
(digest-bit-test 47 #x08 16 "6DE111AC57EEC38FF4F5B8B458F35C20")
(digest-bit-test 47 #x04 16 "0169943B9748514AB5D0083D5174F7F0")
(digest-bit-test 47 #x02 16 "C1EB9BCEEC97EBD8E6589C2CE337033F")
(digest-bit-test 47 #x01 16 "ECB3F11368167148C7D35CAD06FF0C6C")
(digest-bit-test 48 #x80 15 "9A42CB788CDEE1C20EEC7B16F294E184")
(digest-bit-test 48 #x40 15 "2CCF587C931D62CAC815676A6A6457B3")
(digest-bit-test 48 #x20 15 "F6F2004BC97D03608CABB0BD44E998A1")
(digest-bit-test 48 #x10 15 "7C80829659877A03938CC796BA738DEF")
(digest-bit-test 48 #x08 15 "4CA3F42094A36B4FE4DC893BFB813310")
(digest-bit-test 48 #x04 15 "474513BB6D0C0F73A63DFE920210216E")
(digest-bit-test 48 #x02 15 "431BE2611DFFD6DE4EAB6936E0E497DA")
(digest-bit-test 48 #x01 15 "813B32050FEDCDB719F95A646E888560")
(digest-bit-test 49 #x80 14 "49384B8B60C1A065346A995BB31CEA47")
(digest-bit-test 49 #x40 14 "B97D733DE2C048FF0C01891114D0AFB5")
(digest-bit-test 49 #x20 14 "8B8346E0F1D63A73CE1CCAD90D2CF097")
(digest-bit-test 49 #x10 14 "137398F39EF97AE7B6B682F8253CE123")
(digest-bit-test 49 #x08 14 "6E244EC4300F40A8DCBE38A446DE9006")
(digest-bit-test 49 #x04 14 "0286C3F8D66DAB8FF8CD925A1B9D7140")
(digest-bit-test 49 #x02 14 "788CC909AD9F81FEF4749B8B58C92473")
(digest-bit-test 49 #x01 14 "A05C4E77731A523F396EADA342D6E66A")
(digest-bit-test 50 #x80 13 "5C5208058E887AEFA1A32E8988A37455")
(digest-bit-test 50 #x40 13 "7567725FF801A30914E07CFFE1A6C49A")
(digest-bit-test 50 #x20 13 "346DE7910432F66E09BAC32E34EB1B58")
(digest-bit-test 50 #x10 13 "145C587A9887EFE3D3E0E758B7589D39")
(digest-bit-test 50 #x08 13 "E0CFD61D4F4604C26E299A7F1FF60A9B")
(digest-bit-test 50 #x04 13 "031525ABB3AA04A8F9FF4EEA20955BF2")
(digest-bit-test 50 #x02 13 "8FC8AFDFFBA17F5F6FECAAB9B52DF2A6")
(digest-bit-test 50 #x01 13 "1959366FB1C73BE165B12D3A972BBBF7")
(digest-bit-test 51 #x80 12 "822496D965F7D85215D7752AFF1C03CC")
(digest-bit-test 51 #x40 12 "C2E0DE6429654FB9590324DCF1D92D8F")
(digest-bit-test 51 #x20 12 "4D360BBE43BE367A2A7EE6BFF0ECDC65")
(digest-bit-test 51 #x10 12 "83351D012FEF8C39D6C8ED2764365222")
(digest-bit-test 51 #x08 12 "68B502C668B792ED079866770B10C965")
(digest-bit-test 51 #x04 12 "9160B774CBD240B9971CC01C694254EA")
(digest-bit-test 51 #x02 12 "772D02B47D9A881ED8793AEA6DB156A2")
(digest-bit-test 51 #x01 12 "453952F734884B80C5843A05693F9BB5")
(digest-bit-test 52 #x80 11 "F5816D1064596ABFF2E783455467626B")
(digest-bit-test 52 #x40 11 "AB5FE94D6F3942B597087F55689F88E3")
(digest-bit-test 52 #x20 11 "53CAAF5CBC27128942AB99FC82F93D16")
(digest-bit-test 52 #x10 11 "4ECC87CE3E1663123FC0073032A46698")
(digest-bit-test 52 #x08 11 "AEDD921FC1C61F882874AD4C852326E7")
(digest-bit-test 52 #x04 11 "13B9902301C02A268AD8BF10B8F9E3A1")
(digest-bit-test 52 #x02 11 "A223438271EB74888A765160D6522886")
(digest-bit-test 52 #x01 11 "0ADAFB3AB3E613570405A34CD6F45F66")
(digest-bit-test 53 #x80 10 "EAE6F63E52CD7468B6D0ECC4B071237C")
(digest-bit-test 53 #x40 10 "18D3E8B9062752CAEBE9D883134AAABC")
(digest-bit-test 53 #x20 10 "6EDF355D7837ABDFA212D2CD5BCB87D6")
(digest-bit-test 53 #x10 10 "0A3ECD269F355AB60EEFBE4091F18AD5")
(digest-bit-test 53 #x08 10 "6E7B760A6835B012538A335E380780E3")
(digest-bit-test 53 #x04 10 "C662C5004355636CA82CD719F9D1C73E")
(digest-bit-test 53 #x02 10 "F5AE69B217C1CF7244A23B131EDD92EA")
(digest-bit-test 53 #x01 10 "C1932E05A9013D9F99F4D3E5276A119C")
(digest-bit-test 54 #x80 9 "A6B846C6737042EA576BE18DE7E02269")
(digest-bit-test 54 #x40 9 "F4152ECC66945DA718F7D9D555187B6C")
(digest-bit-test 54 #x20 9 "501779DF50469939215CCCE08A3A94D6")
(digest-bit-test 54 #x10 9 "C1ABB35E11F4BC38294874287BEE9AAF")
(digest-bit-test 54 #x08 9 "9C91D1E0FA615B35AE1BECB2246E6455")
(digest-bit-test 54 #x04 9 "0C0736C7063B09A489911E501C0150E3")
(digest-bit-test 54 #x02 9 "B38E7B51485EDD91FD7E9F4378E38816")
(digest-bit-test 54 #x01 9 "595EB1247564E5E2F0CD600972D5BDD1")
(digest-bit-test 55 #x80 8 "1903BA1EC1F52753FBB268F9F3CCD6B1")
(digest-bit-test 55 #x40 8 "AAD887A7C026424568B7ABD0811EB531")
(digest-bit-test 55 #x20 8 "A7045885FB7FCD4A53CB0F22C6CDB5AD")
(digest-bit-test 55 #x10 8 "CD5B21D3AA49BABBC11B111BBDF76EC9")
(digest-bit-test 55 #x08 8 "4643EF5500FDED7B08B5D69C62D5582D")
(digest-bit-test 55 #x04 8 "4B90DA4B10A0B514998EF664C3BAFF69")
(digest-bit-test 55 #x02 8 "3F93EDCBC0F9DAA89D2034C562F1BDFA")
(digest-bit-test 55 #x01 8 "6E4C987BE3A6B24B3E38F1CAFE963C1E")
(digest-bit-test 56 #x80 7 "F025E2F601BBD45F231B7DCC4056B365")
(digest-bit-test 56 #x40 7 "C6C66B75C45E8E06811AF898D995AE1C")
(digest-bit-test 56 #x20 7 "78A2026C6B2693223B902BE948136BB8")
(digest-bit-test 56 #x10 7 "E2BBAC6D03DDAF61E40CE15DBFBE90C3")
(digest-bit-test 56 #x08 7 "CDB03F27AEDB30F7E596343BECB734BD")
(digest-bit-test 56 #x04 7 "93E750C651C7948DA2A60699DF6DEDCA")
(digest-bit-test 56 #x02 7 "DEAF528DF04ACF72DE18B3217053D427")
(digest-bit-test 56 #x01 7 "46A254BF46ED3199BB635ECCDAF15885")
(digest-bit-test 57 #x80 6 "0FF7741D480328D0686A2DEC4B41B4AE")
(digest-bit-test 57 #x40 6 "E146B00D2369DC2DDDA083A8BB1A7DEE")
(digest-bit-test 57 #x20 6 "C87C5FF808384504E42BFD1BE5A712B1")
(digest-bit-test 57 #x10 6 "8275B17CEABDFEF760222DA01A35715D")
(digest-bit-test 57 #x08 6 "D3DD3D6F53B45B797778E7FEF28A8C5B")
(digest-bit-test 57 #x04 6 "E5F72DF56B978D8DB7E7EED04AF709B4")
(digest-bit-test 57 #x02 6 "0F5730004ACE61A069514071F184A1B6")
(digest-bit-test 57 #x01 6 "5B70D9641D978CE2E2CFFD7FB77710A9")
(digest-bit-test 58 #x80 5 "7EDDEF710BA2068E8598EE4D4359114D")
(digest-bit-test 58 #x40 5 "B89DFF15C70666B1F41D53C3EEFDF88B")
(digest-bit-test 58 #x20 5 "3762BACD52DC2AD602CFEFDBCCB86699")
(digest-bit-test 58 #x10 5 "EC0B054B6DF1C6622ACB55F025092521")
(digest-bit-test 58 #x08 5 "38C8CC15D9C50B404EB18E07F5C020DC")
(digest-bit-test 58 #x04 5 "B841829E581AA28D25B61890711D99C5")
(digest-bit-test 58 #x02 5 "D91E2A0CFD68A772D39A15DCB0061E72")
(digest-bit-test 58 #x01 5 "46D2ED6F3043A6201A7A9853320D70BA")
(digest-bit-test 59 #x80 4 "0E380317C0B7A38666CA700C54A86A7D")
(digest-bit-test 59 #x40 4 "6459F489263B4AA47205258F8844B57B")
(digest-bit-test 59 #x20 4 "67CF6FBF0D86024C9B54B140350298C2")
(digest-bit-test 59 #x10 4 "67D1FEFA06650699BBA2498D77422E48")
(digest-bit-test 59 #x08 4 "7EF6EEF95A7F051CFF31EB3F8906D7BD")
(digest-bit-test 59 #x04 4 "8EF040642F6A536C63556B8708BC17E5")
(digest-bit-test 59 #x02 4 "DB7648736FFA74596EB5C3B3918AEBA3")
(digest-bit-test 59 #x01 4 "01C0DCC29632E632E2D65D22C8D5A397")
(digest-bit-test 60 #x80 3 "505A6E9E779E4AC35767F624C815F2E2")
(digest-bit-test 60 #x40 3 "E5404AD29B710C5189669E150A710D29")
(digest-bit-test 60 #x20 3 "40BEE92CF590D130F7CD8DF31223B105")
(digest-bit-test 60 #x10 3 "A213CD218594A7F3EB14B627E1FC5B76")
(digest-bit-test 60 #x08 3 "F2ECA81F5EE194D356210A5E83657BCC")
(digest-bit-test 60 #x04 3 "BE42CF5328636668130F9000FD6B601C")
(digest-bit-test 60 #x02 3 "7D8CB103E55798EBC816DBB9D49B1B0F")
(digest-bit-test 60 #x01 3 "7996972214DBEA50ED400B5250E3AE6F")
(digest-bit-test 61 #x80 2 "47CAF317CF83F0D4B52015079A22067C")
(digest-bit-test 61 #x40 2 "2C8B88503B88BBF4E03F9112EADCAA1E")
(digest-bit-test 61 #x20 2 "27D5C2DBD350B6D18849CC5DFD690630")
(digest-bit-test 61 #x10 2 "F2F36909DBA92546CCC4536C529E1244")
(digest-bit-test 61 #x08 2 "A8F24846E4BEB0662FB1DB3448B9B80E")
(digest-bit-test 61 #x04 2 "15E190036F667CE0AE80DB61834DB56F")
(digest-bit-test 61 #x02 2 "EBC2C68270E129D7766887108739BAC9")
(digest-bit-test 61 #x01 2 "B6A4C6F85D391A98D0513E074B5313C5")
(digest-bit-test 62 #x80 1 "25F86F015DF2C1DB33B53BDAC1F7C37E")
(digest-bit-test 62 #x40 1 "26154B8662C7AB915CFD5D3AEACA736A")
(digest-bit-test 62 #x20 1 "1EFCFE1F115FE9DF8D60F1B985FEBE3A")
(digest-bit-test 62 #x10 1 "37DC0F6EDD8AC35C5A556081B41097DD")
(digest-bit-test 62 #x08 1 "E4B76A9A8F6BCA334439CB82892C2925")
(digest-bit-test 62 #x04 1 "934867C0BBFCB06C5BBA8A324EBF9EA4")
(digest-bit-test 62 #x02 1 "56859B2F54F496E8BB0A09231975842E")
(digest-bit-test 62 #x01 1 "7D7B4FB873242930EF536C6E80879BA1")
(digest-bit-test 63 #x80 0 "CC10DAD64C6DECDA5FBDD62A11BBE586")
(digest-bit-test 63 #x40 0 "83F78A4FAA4E4ED312DC33C6B2514700")
(digest-bit-test 63 #x20 0 "DDA2969799CEC4F270FCB69209474EC7")
(digest-bit-test 63 #x10 0 "8197D643B6A206825B566BFEC1461987")
(digest-bit-test 63 #x08 0 "638A19A3375D1CD4A6D597D0ED0FB2A3")
(digest-bit-test 63 #x04 0 "62881F317DE9E38108F29307239EC178")
(digest-bit-test 63 #x02 0 "441C9490934F4E743EF246C24576AF8E")
(digest-bit-test 63 #x01 0 "0B0BA2C1FE0416434ABD826DB682FAD5")
