/***************************************************************************
 *   Copyright (C) 2004 by Andrew de Quincey                               *
 *   adq@lidskialf.net                                                     *
 *   Copyright (C) 2005 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IPODSYSINFO_H
#define IPODSYSINFO_H

#include <qobject.h>
#include <qmap.h>
#include <qstring.h>
#include <qdir.h>

/**
 * @author Andrew de Quincey, Michael Schulze
 */
class IPodSysInfo {
public:
    IPodSysInfo(const QString& filename);
    ~IPodSysInfo();
    bool load();

    void refreshDiskUsageStats();

    /**
    * Get the keys to all known system information properties.
    *
    * @return Key list.
    */
    QValueList<QString> getKeys();

    /**
    * Retrieve an individual property by key
    *
    * @param key The key to look up.
    * @return The value, or QString::null if unknown.
    */
    QString getValue(const QString& key);

    /**
     * Returns the total disk space available on the device (filesystem wise)
     * in kBytes
     */
    unsigned long getTotalDiskSpaceKB();

    /**
     * Returns the currently available disk space on the device (filesystem wise)
     * in kBytes
     */
    unsigned long getAvailableDiskSpaceKB();

    /**
     * Returns the currently used disk space on the device (filesystem wise)
     * in kBytes
     */
    unsigned long getUsedDiskSpaceKB();

    int getNumTrackFileDirs() { return numTrackFileDirs; }

    QDir getMusicDir() { return musicDir; }

    static const QString iPodControlDir;

private:
    void ensureDiskUsageStats();
    QMap<QString, QString> details;
    QString ipod_base;
    QDir musicDir;

    unsigned long kbytesTotal;
    unsigned long kbytesAvail;
    uint numTrackFileDirs;
};

#endif
