// -*- C++ -*-
// --------------------------------------------------------------------
// XML parsing
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEXML_H
#define IPEXML_H

#include "ipebase.h"

// --------------------------------------------------------------------

class IPE_EXPORT IpeXmlAttributes {
private:
  typedef std::map<IpeString, IpeString> Map;
public:
  //! Iterator for (key, value) pairs.
  typedef Map::const_iterator const_iterator;

  //! Return const iterator for first attribute.
  const_iterator begin() const { return iMap.begin(); }
  //! Return const iterator for end of attributes.
  const_iterator end() const { return iMap.end(); }

  IpeXmlAttributes();
  void Clear();
  IpeString operator[](IpeString str) const;
  bool Has(IpeString str, IpeString &val) const;
  void Add(IpeString key, IpeString val);
  //! Set that the tag contains the final /.
  inline void SetSlash() { iSlash = true; }
  //! Return whether tag contains the final /.
  inline bool Slash() const { return iSlash; }

private:
  Map iMap;
  bool iSlash;
};

class IPE_EXPORT IpeXmlParser {
public:
  IpeXmlParser(IpeDataSource &source);
  virtual ~IpeXmlParser();

  int ParsePosition() const { return iPos; }

protected:
  IpeString ParseToTag();
  IpeString ParseToTagX();
  bool ParseAttributes(IpeXmlAttributes &attr, bool qm = false);
  bool ParsePCDATA(IpeString tag, IpeString &pcdata);

  inline bool IsTagChar(int ch) {
    return ('a' <= ch && ch <= 'z') || ('A' <= ch && ch <= 'Z')
      || ch == '-'; }
  inline void GetChar() { iCh = iSource.GetChar(); ++iPos; }
  inline bool Eos() { return (iCh == EOF); }
  void SkipWhitespace();

protected:
  IpeDataSource &iSource;
  IpeString iTopElement;
  int iCh;  // current character
  int iPos; // position in input stream
};

// --------------------------------------------------------------------
#endif
