/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: SliceFiller.h,v $
  Language:  C++
  Date:      $Date: 2003/09/10 14:30:12 $
  Version:   $Revision: 1.3 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef __SliceFiller_h
#define __SliceFiller_h

#include "itkImageToImageFilter.h"

template< class TImage >
class SliceFiller : public itk::ImageToImageFilter< TImage, TImage >
{
public:
  /** Standard class typedefs. */
  typedef SliceFiller  Self;
  typedef itk::ImageToImageFilter< TImage, TImage >  Superclass;
  typedef itk::SmartPointer<Self>  Pointer;
  typedef itk::SmartPointer<const Self>  ConstPointer;
  
  /** Method for creation through the object factory. */
  itkNewMacro(Self);
  
  /** Run-time type information (and related methods). */
  itkTypeMacro(SliceFiller, ImageToImageFilter);

  typedef typename TImage::SizeType ImageSizeType ;
  typedef typename TImage::PixelType ImagePixelType ;

  void SetStartingSliceNumber(int sliceNumber) ;

  void SetDesiredSize(ImageSizeType size) ;

  void SetBackgroundPixelValue(ImagePixelType value) ;
  
protected:
  SliceFiller() ;
  ~SliceFiller() ;

  void GenerateData() ;

private:
  typename TImage::PixelType m_BackgroundPixelValue ;
  typename TImage::SizeType m_DesiredSize ;
  int m_SliceSize ;
  int m_StartingSliceNumber ;
} ; // end of class

#ifndef ITK_MANUAL_INSTANTIATION
#include "SliceFiller.txx"
#endif

#endif
