# -*- coding: iso-8859-1 -*-
""" Batch editor implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: BatchEditWnd.py,v 1.27 2004/10/21 02:50:16 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""

from string import *                    #TODO2: this import sucks. Remove it
import time

try:
    from BatchEditForm import *
except:
    print "BatchEditWnd: Unable to import some imgSeek modules. Some features will not work."

class BatchEditWnd(batchform):
    def tr(self,msg):
        return qApp.translate('main',msg)

    def __init__(self, parent,env):
        batchform.__init__(self,parent)
        self.env = env
        self.curdb = self.env.curdb
        self.curdb.cbs["Batch"].append(self.syncBatchCombo)                # make syncBatchCombo get called whenever something reladed to batches change
        self.curBatch = -1
        self.batchtable.setColumnStretchable(0,1)
        if len(self.curdb.batches.keys()):
            self.showBatch(self.curdb.batches.keys()[0])
        # Table popup menu
        self.tbMenu = QPopupMenu(self)
        self.tbMenu.insertItem ( parent.removedead.iconSet(), self.tr("&Remove this item"), self.onDelItem)
        self.tbMenu.insertSeparator()
        self.tbMenu.insertItem ( parent.resetqhistory.iconSet(), self.tr("&Clear current batch"), self.onReset)
        self.curRow = -1
        self.syncBatchCombo()
        # populate action combo
        self.actioncombo.insertItem(self.tr("No action selected"))
        self.actioncombo.insertItem(self.tr("Extract image metadata from file"))
        self.actioncombo.insertItem(self.tr("Slideshow"))
        self.actioncombo.insertItem(self.tr("Create HTML album"))

    def onReset(self):
        if self.curBatch==-1: return
        self.curdb.resetBatch(self.curBatch)

    def onDelItem(self):
        if self.curRow==-1: return
        self.curdb.removeItemBatch(self.curRow,self.curBatch)

    def syncBatchCombo(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])
        if self.curBatch != -1:
            self.showBatch(self.curBatch)
        else:
            if len(self.curdb.batches.keys()):
                self.showBatch(self.curdb.batches.keys()[0])
            else:
                self.batchtable.setNumRows(0)

    def batchcombo_activated(self,a0):
        try:
            bid = self.curdb.batches.keys()[a0]
        except:
            print "key Error showing desired batch"
            return
        self.showBatch(bid)
        self.curdb.curBatch = bid

    def showBatch(self,bid):
        txt = self.curdb.BatchToText(bid)
        self.batchtable.setNumRows(len(txt))
        self.curBatch = bid
        if not txt:
            return
        cnt = 0
        for it in txt:
            self.batchtable.setText(cnt,0,it[1])
            self.batchtable.setText(cnt,1,it[0])
            cnt = cnt+1

    def batchtable_doubleClicked(self,a0,a1,a2,a3):
        pass

    def batchtable_contextMenuRequested(self,a0,a1,a2):
        self.tbMenu.popup(a2)
        self.curRow = a0

    def newbatchbtn_clicked(self):
        text = str(QInputDialog.getText("imgSeek",self.tr("New batch name:") ,QLineEdit.Normal, time.asctime(time.localtime()))[0])
        if text:
            if not self.curdb.addBatch(text):
                QMessageBox.information( self, "imgSeek",self.tr("Error adding batch"))
                return

    def removebatchbtn_clicked(self):
        if self.curBatch==-1: return
        if self.curBatch==1:
            QMessageBox.information( self, "imgSeek",self.tr("You can't remove the default work batch"))
            return
        todel = self.curBatch
        try:
            self.curBatch = 1
        except:
            pass
        self.curdb.removeBatch(todel)

    def resetbatchesbtn_clicked(self):
        self.curdb.resetBatchHistory()

    def applyactionbtn_clicked(self):
        if not self.actioncombo.currentItem(): return

        if self.actioncombo.currentItem() == 1: # scan meta
            reopenmeta = 0
            if self.env.wnd.MetaForm:   # close metadata editor dialog if opened
                reopenmeta = 1
                self.env.wnd.MetaForm.close()
                del self.env.wnd.MetaForm
                self.env.wnd.MetaForm = None
            self.curdb.scanForMetaTags(self.curBatch)
            if reopenmeta: self.env.wnd.editmeta_activated() # reopen metadata editor dialog if it was closed before this action
            QMessageBox.information( self, "imgSeek",self.tr("Metadata successfully extracted."))

        if self.actioncombo.currentItem() == 2: # slide
            flist = []
            self.curdb.crawlBatchForFile(self.curBatch,flist)
            self.env.wnd.doSlideShow(flist)

        if self.actioncombo.currentItem() == 3: # html
            self.env.wnd.createhtml_activated(self.curBatch)
