#ifndef _VKB_AUX_H_
#define _VKB_AUX_H_

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "vkb_layout.h"

#define PALETTE_AUX_VKB_LAYOUT_FILE  "/keyboard_layout.txt"


typedef struct _vkb_window_t {
    GtkWidget *window;
    GtkWidget *drawing_area;
    GdkPixmap *pixmap;

    PangoContext *context;
    PangoLayout *pango_layout;
    PangoFontDescription *fontdesc_basekey;
    PangoFontDescription *fontdesc_ctrlkey;

    GdkCursor *moving_cursor;
    GdkCursor *normal_cursor;

    GdkRectangle buttons[MAX_VK_NUM];

    gint width;
    gint height;

    gint pos_x;
    gint pos_y;

    gint button_id_focused;
    gint button_id_pressed;

    gboolean draging;
    gboolean draw_draging_frame;
    gint drag_x_start;
    gint drag_y_start;
    gint drag_x_save;
    gint drag_y_save;

    vkb_layout_t *layout;

    int status_ctrlkey:2;
    int status_shiftkey:2;
    int status_altkey:2;
    int status_capslockkey:2;
} vkb_window_t;

typedef struct _vkb_session_t {
    vkb_layout_t *layout;

    int pos_x;
    int pos_y;
    int status_ctrlkey:2;
    int status_shiftkey:2;
    int status_altkey:2;
    int status_capslockkey:2;
} vkb_session_t;

#endif	/* _VKB_AUX_H_ */
