/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGGPARAMETER_H
#define IGGPARAMETER_H


namespace iggParameter
{
	const int _WidgetTypeOther = 0;
	const int _WidgetTypeEntry = 1;

	const int _RenderModeUseGlobal = 0;
	const int _RenderModeImmediate = 1;
	const int _RenderModeDelayed = 2;
	const int _RenderModeNoRender = 3;

	const int _ButtonTypePushButton = 0;
	const int _ButtonTypeToolButton = 1;
	const int _ButtonTypeSwitchButton = 2;
	const int _ButtonTypeToggleButton = 3;
	const int _ButtonTypeCheckBox = 4;

	//
	//  Reloading widget conditions
	//
	const int _DataWithBoundaryCondition = 0;
	const int _DataWithVariableCalculation = 1;
	const int _DataWithParticleDownsampling = 2;
	const int __NumDataWith = 3;

	//
	//  DataTypeSelector modes
	//
	const int _ListDataTypesAll = 0;
	const int _ListDataTypesWithData = 1;
	const int _ListDataTypesWithVariables = 2;

	//
	//  Mouse interaction buttons
	//
	const int _MouseNoButton = 0;
	const int _MouseLeftButton = 1;
	const int _MouseMiddleButton = 2;
	const int _MouseRightButton = 4;
	const int _MouseAnyButton = 7;
	const int _MouseControlKey = 8;
	const int _MouseShiftKey = 16;

	//
	//  Mouse clicks
	//
	const int _SingleClick = 1;
	const int _DoubleClick = 2;

	//
	//  Dialog modes masks
	//
	const unsigned int _DialogBlocking = 1U;
	const unsigned int _DialogWithEventLoop = 2U;
	const unsigned int _DialogModal = 3U;
	const unsigned int _DialogNoTitleBar = 4U;
	const unsigned int _DialogUnattached = 8U;

	//
	//  Book widget modes
	//
	const int _BookTitleOnly = 0;
	const int _BookImageOnly = 1;
	const int _BookTitleAndImage = 2;

	//
	//  Text editor masks
	//
	const unsigned int _TextEditorReadOnly = 1U;
	const unsigned int _TextEditorWithHTML = 2U;
	const unsigned int _TextEditorWrapping = 4U;

	//
	//  Text editor capabilities
	//
	const int _TextEditorFunctionUndo = 1;
	const int _TextEditorFunctionRedo = 2;
	const int _TextEditorFunctionCut = 3;
	const int _TextEditorFunctionCopy = 4;
	const int _TextEditorFunctionPaste = 5;

	//
	//  Keyboard keys
	//
	const int _KeyEnter = 1;
	const int _KeyLineUp = 2;
	const int _KeyLineDown = 3;
	const int _KeyPageUp = 4;
	const int _KeyPageDown = 5;
	const int _KeyTop = 6;
	const int _KeyBottom = 7;

	//
	//  Popup types
	//
	const int _PopupWindowMessage = 0;
	const int _PopupWindowWarning = 1;
	const int _PopupWindowError = 2;
};

#endif  // IGGPARAMETER_H

