#   sourceclientgui.py: new for version 0.7 this provides the graphical
#   user interface for the new improved streaming module
#   Copyright (C) 2007 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require('2.0')
import gtk
import gobject

import os, time

from idjc_config import gfext, pkgdatadir, libexecdir, lameenabled
from langheader import *
from IDJCfree import int_object
from IDJCservdialog import *

num_encoders  = 6
num_streamers = 6
num_recorders = 2

ENCODER_START=1; ENCODER_STOP=0					# start_stop_encoder constants

class ModuleFrame(gtk.Frame):
   def __init__(self, frametext = None):
      gtk.Frame.__init__(self, frametext)
      gtk.Frame.set_shadow_type(self, gtk.SHADOW_ETCHED_OUT)

class CategoryFrame(gtk.Frame):
   def __init__(self, frametext = None):
      gtk.Frame.__init__(self, frametext)
      gtk.Frame.set_shadow_type(self, gtk.SHADOW_IN)
 
class SubcategoryFrame(gtk.Frame):
   def __init__(self, frametext = None):
      gtk.Frame.__init__(self, frametext)
      gtk.Frame.set_shadow_type(self, gtk.SHADOW_ETCHED_IN)

class TimeEntry(gtk.HBox):		# A 24-hour-time entry widget with a checkbutton
   def time_valid(self):
      return self.seconds_past_midnight >= 0
   def get_seconds_past_midnight(self):
      return self.seconds_past_midnight
   def set_active(self, boolean):
      self.check.set_active(boolean and True or False)
   def get_active(self):
      return self.check.get_active() and self.time_valid
   def __entry_activate(self, widget):
      boolean = widget.get_active()
      self.entry.set_sensitive(boolean)
      if boolean:
         self.entry.grab_focus()
   def __key_validator(self, widget, event):
      if event.keyval < 128:
         if event.string == ":":
            return False
         if event.string < "0" or event.string > "9":
            return True
   def __time_updater(self, widget):
      text = widget.get_text()
      if len(text) == 5 and text[2] == ":":
         try:
            hours = int(text[:2])
            minutes = int(text[3:])
         except:
            self.seconds_past_midnight = -1
         else:
            if hours >= 0 and hours <=23 and minutes >= 0 and minutes <= 59:
               self.seconds_past_midnight = hours * 3600 + minutes * 60
            else:
               self.seconds_past_midnight = -1
      else:
         self.seconds_past_midnight = -1
   def __init__(self, labeltext):
      gtk.HBox.__init__(self)
      self.set_spacing(5)
      self.check = gtk.CheckButton(labeltext)
      self.check.connect("toggled", self.__entry_activate)
      self.pack_start(self.check)
      self.check.show()
      self.entry = gtk.Entry(5)
      self.entry.set_sensitive(False)
      self.entry.set_width_chars(5)
      self.entry.connect("key-press-event", self.__key_validator)
      self.entry.connect("changed", self.__time_updater)
      self.pack_start(self.entry)
      self.entry.show()
      self.seconds_past_midnight = -1

class AutoAction(gtk.HBox):			# widget consiting of a check button and several radio buttons
   def activate(self):			        # radio buttons linked to actions to be performed on the activate method
      if self.get_active():			# all radio buttons exist in the same radio group so only one action is
         for radio, action in self.action_lookup:	# performed
            if radio.get_active():
               action()
   def get_active(self):
      return self.check_button.get_active()
   def set_active(self, boolean):
      self.check_button.set_active(boolean)
   def get_radio_index(self):
      return self.radio_active
   def set_radio_index(self, value):
      self.action_lookup[value][0].clicked()
   def __set_sensitive(self, widget):
      boolean = widget.get_active()
      for radio, action in self.action_lookup:
         radio.set_sensitive(boolean)
   def __handle_radioclick(self, widget, which):
      if widget.get_active():
         self.radio_active = which
   def __init__(self, labeltext, names_actions):
      gtk.HBox.__init__(self)
      self.radio_active = 0
      self.check_button = gtk.CheckButton(labeltext)
      self.set_spacing(4)
      self.pack_start(self.check_button, False, False, 0)
      self.check_button.show()
      lastradio = None
      self.action_lookup = []
      for index, (name, action) in enumerate(names_actions):
         radio = gtk.RadioButton(lastradio, name)
         radio.connect("clicked", self.__handle_radioclick, index)
         lastradio = radio
         radio.set_sensitive(False)
         self.check_button.connect("toggled", self.__set_sensitive)
         self.pack_start(radio, False, False, 0)
         radio.show()
         self.action_lookup.append((radio, action))

class MetadataBar(gtk.HBox):
   def send(self, widget):
      utf8meta = self.metadata_entry.get_text().encode("utf-8", "replace").strip()
      if self.source_client_gui.parent.prefs_window.mp3_utf8.get_active():
         mp3meta = utf8meta
      else:
         mp3meta = self.metadata_entry.get_text().encode("iso8859-1", "replace").strip()
      if not utf8meta:
         utf8meta = mp3meta = "%s"
      for index, checkbutton in enumerate(self.enablers):
         if checkbutton.get_active(): 
            self.source_client_gui.send("tab_id=%d\ndev_type=encoder\nmetaformat=%s\nmetaformat_mp3=%s\ncommand=new_metaformat\n" % (index, utf8meta, mp3meta))
   def __init__(self, parent, qty, default_text=""):
      self.source_client_gui = parent
      gtk.HBox.__init__(self, True)
      self.set_spacing(12)
      left_hbox = gtk.HBox()
      self.add(left_hbox)
      left_hbox.show()
      label = gtk.Label(metadata_text)
      left_hbox.pack_start(label, False, False, 0)
      label.show()
      self.enablers = []
      for tab in range(qty):
         cb = gtk.CheckButton(str(tab + 1))
         cb.set_active(True)
         self.enablers.append(cb)
         left_hbox.pack_start(cb, True, False, 0)
         cb.show()
      right_hbox = gtk.HBox()
      right_hbox.set_spacing(5)
      self.add(right_hbox)
      right_hbox.show()
      self.metadata_entry = gtk.Entry()
      self.metadata_entry.set_text("%s")
      right_hbox.pack_start(self.metadata_entry, True, True, 0)
      self.metadata_entry.show()
      self.metadata_update_button = gtk.Button(update_text)
      self.metadata_update_button.connect("clicked", self.send)
      right_hbox.pack_start(self.metadata_update_button, False, False, 0)
      self.metadata_update_button.show()

class Tab(gtk.VBox):
   def show_indicator(self, colour):
      thematch = self.indicator_lookup[colour]
      thematch.show()
      for colour, indicator in self.indicator_lookup.iteritems():
         if indicator is not thematch:
            indicator.hide()
   def send(self, stringtosend):
      self.source_client_gui.send("tab_id=%d\n%s" % (self.numeric_id, stringtosend))
   def receive(self):
      return self.source_client_gui.receive()
   def __init__(self, scg, numeric_id, indicator_lookup):
      self.indicator_lookup = indicator_lookup
      self.numeric_id = numeric_id
      self.source_client_gui = scg
      gtk.VBox.__init__(self)
      gtk.VBox.set_border_width(self, 8)
      gtk.VBox.show(self)

class StreamTab(Tab):
   class ResampleFrame(SubcategoryFrame):
      def cb_eval(self, widget, data = None):
         if data is not None:
            if widget.get_active():
               self.extraction_method = data
            else:
               return
         if self.extraction_method == "no_resample":
            self.resample_rate = self.jack_sample_rate
         elif self.extraction_method == "standard":
            self.resample_rate = int(self.resample_rate_combo_box.get_active_text())
         else:
            self.resample_rate = int(self.resample_rate_spin_adj.get_value())
         self.resample_quality = ("highest", "high", "fast", "fastest")[self.resample_quality_combo_box.get_active()]
         self.mp3_compatible = self.resample_rate in self.mp3_samplerates
         self.parentobject.mp3_dummy_object.clicked()		# update mp3 pane
         self.parentobject.ogg_dummy_object.clicked()
      def __init__(self, parent, sizegroup):
         self.parentobject = parent
         self.jack_sample_rate = parent.source_client_gui.jack_sample_rate
         self.resample_rate = self.jack_sample_rate
         self.extraction_method = "no_resample"
         self.mp3_compatible = True
         SubcategoryFrame.__init__(self, stream_resample_text)
         self.resample_no_resample, self.resample_standard, self.resample_custom = self.parentobject.make_radio(3)
         self.resample_no_resample.connect("clicked", self.cb_eval, "no_resample")
         self.resample_standard.connect("clicked", self.cb_eval, "standard")
         self.resample_custom.connect("clicked", self.cb_eval, "custom")
         no_resample_label = gtk.Label(no_resample_text)
         self.mp3_samplerates = (48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000)
         self.resample_rate_combo_box = self.parentobject.make_combo_box(map(str, self.mp3_samplerates))
         self.resample_rate_combo_box.set_active(1)
         self.resample_rate_combo_box.connect("changed", self.cb_eval)
         self.resample_rate_spin_adj = gtk.Adjustment(44100, 4000, 96000, 10, 100, 0)
         self.resample_rate_spin_control = gtk.SpinButton(self.resample_rate_spin_adj, 0, 0)
         self.resample_rate_spin_control.connect("value-changed", self.cb_eval)
         resample_quality_label = gtk.Label(resample_quality_text)
         self.resample_quality_combo_box = self.parentobject.make_combo_box((best_quality_resample_text,
         		good_quality_resample_text, fast_resample_text, fastest_resample_text))
         self.resample_quality_combo_box.set_active(3)
         self.resample_quality_combo_box.connect("changed", self.cb_eval)
         self.resample_dummy_object = gtk.Button()
         self.resample_dummy_object.connect("clicked", self.cb_eval)
         sample_rate_pane = self.parentobject.item_item_layout(((self.resample_no_resample, no_resample_label),
                              (self.resample_standard, self.resample_rate_combo_box),
                              (self.resample_custom, self.resample_rate_spin_control),
                              (resample_quality_label, self.resample_quality_combo_box)), sizegroup)
         sample_rate_pane.set_border_width(10)
         self.add(sample_rate_pane)
         sample_rate_pane.show()
   def make_combo_box(self, items):
      combobox = gtk.combo_box_new_text()
      for each in items:
         combobox.append_text(each)
      return combobox
   def make_radio(self, qty):
      listofradiobuttons = []
      for iteration in range(qty):
         listofradiobuttons.append(gtk.RadioButton())
         if iteration > 0:
            listofradiobuttons[iteration].set_group(listofradiobuttons[0])
      return listofradiobuttons
   def make_notebook_tab(self, notebook, labeltext):
      label = gtk.Label(labeltext)
      vbox = gtk.VBox()
      notebook.append_page(vbox, label)
      label.show()
      vbox.show()
      return vbox
   def item_item_layout(self, item_item_pairs, sizegroup):
      vbox = gtk.VBox()
      vbox.set_spacing(2)
      for left, right in item_item_pairs:
         hbox = gtk.HBox()
         sizegroup.add_widget(hbox)
         hbox.set_spacing(5)
         if left is not None:
            hbox.pack_start(left, False, False, 0)
            left.show()
         if right is not None:
            hbox.pack_start(right, True, True, 0)
            right.show()
         vbox.pack_start(hbox, False, False, 0)
         hbox.show()
      return vbox
   def item_item_layout2(self, item_item_pairs, sizegroup):
      rhs_size = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      vbox = gtk.VBox()
      vbox.set_spacing(2)
      for left, right in item_item_pairs:
         hbox = gtk.HBox()
         sizegroup.add_widget(hbox)
         hbox.set_spacing(5)
         hbox.pack_start(left, False, False, 0)
         left.show()
         if right is not None:
            rhs_size.add_widget(right)
            hbox.pack_end(right, False, False, 0)
            right.show()
         vbox.pack_start(hbox, False, False, 0)
         hbox.show()
      return vbox
   def label_item_layout(self, label_item_pairs, sizegroup):	# align vertical colums of label : item
      hbox = gtk.HBox()						# label is right justified and narrow as possible
      vbox_left = gtk.VBox()					# the item widget is free to expand
      vbox_left.set_spacing(1)
      vbox_right = gtk.VBox()
      vbox_right.set_spacing(1)
      hbox.pack_start(vbox_left, False, False, 0)
      hbox.pack_start(vbox_right, True, True, 0)
      hbox.set_spacing(5)
      for text, item in label_item_pairs:
         if text is not None:
            labelbox = gtk.HBox()
            label = gtk.Label(text)
            sizegroup.add_widget(label)
            labelbox.pack_end(label, False, False)
            label.show()
            vbox_left.pack_start(labelbox, False, False, 0)
            labelbox.show()
         itembox = gtk.HBox()
         sizegroup.add_widget(itembox)
         itembox.add(item)
         item.show()
         vbox_right.pack_start(itembox, False, False, 0)
         itembox.show()
      vbox_left.show()
      vbox_right.show()
      return hbox
   def send(self, string_to_send):
      Tab.send(self, "dev_type=streamer\n" + string_to_send)
   def receive(self):
      return Tab.receive(self)
   def cb_servertype(self, widget):
      sens = bool(widget.get_active())
      for each in (self.mount_entry, self.login_entry):
         each.set_sensitive(sens)
      self.update_sensitives()
   def update_sensitives(self):
      if self.encoder == "off":
         self.update_button.set_sensitive(False)
      non_shoutcast = bool(self.server_type_dropdown.get_active())
      if self.encoder == "ogg":
         self.server_connect.set_sensitive(non_shoutcast)
         if self.format_page == 0:
            self.update_button.set_sensitive(False)
         elif self.format_page == 1:
           self.update_button.set_sensitive(self.ogg_settings_valid)
         elif self.format_page == 2:
            try:
               self.update_button.set_sensitive(self.file_dialog.get_filename().lower().endswith(".ogg"))
            except AttributeError:
               self.update_button.set_sensitive(False)
         else:
            print "update_sensitives: unhandled format page"
      elif self.encoder == "mp3":
         self.server_connect.set_sensitive(True)
         if self.format_page == 0:
            self.update_button.set_sensitive(self.mp3_compatibility != "s-rate!")
         elif self.format_page == 1:
           self.update_button.set_sensitive(False)
         elif self.format_page == 2:
            try:
               self.update_button.set_sensitive(self.file_dialog.get_filename().lower().endswith(".mp3"))
            except AttributeError:
               self.update_button.set_sensitive(False)
         else:
            print "update_sensitives: unhandled format page"
      elif self.encoder == "off":
         self.test_monitor.set_sensitive(True)
         if self.format_page == 0:
            sens = self.mp3_compatibility != "s-rate!" and True or False
            self.server_connect.set_sensitive(sens)
            self.test_monitor.set_sensitive(sens)
         elif self.format_page == 1:
            sens = self.ogg_settings_valid
            self.server_connect.set_sensitive(sens and non_shoutcast or self.server_connect.get_active())
            self.test_monitor.set_sensitive(sens)
         elif self.format_page == 2:
            filename = self.file_dialog.get_filename()
            if filename is not None:
               if filename.lower().endswith(".ogg") and not non_shoutcast:
                  self.server_connect.set_sensitive(False)
               else:
                  self.server_connect.set_sensitive(True)
            else:
               self.server_connect.set_sensitive(False)
               self.test_monitor.set_sensitive(False)
         try:
            record_tabs = self.source_client_gui.recordtabframe.tabs
         except:
            pass	# this will be called inevitably before recordtabframe has been created yet
         else:
            for rectab in record_tabs:
               rectab.source_dest.source_combo.emit("changed")	# update sensitivity on record buttons
      if self.encoder != "off":
         if self.format_page == 0:
            if self.encoder == "ogg" or self.mp3_compatibility == "s-rate!":
               self.update_button.set_sensitive(False)
         if self.format_page == 1 and self.encoder == "mp3":
               self.update_button.set_sensitive(False)
         if self.format_page == 2:
            filename = self.file_dialog.get_filename()
            if filename is None or (filename.lower().endswith(".mp3") and self.encoder == "ogg") or (filename.lower().endswith(".ogg") and self.encoder == "mp3"):
               self.update_button.set_sensitive(False)
   def cb_file_dialog_response(self, widget, response_id):
      self.update_sensitives()
   def cb_format_notebook(self, widget, page, page_num):
      if self.format_page != page_num:
         self.format_page = page_num
         self.update_sensitives()
   def cb_mp3tab(self, widget, data = None):
      if data == "standard" or data == "custom":
         if widget.get_active():
            self.mp3_bitrate_widget = data
         else:
            return
      self.mp3_stereo_type = ("stereo", "mono", "jstereo")[self.mp3_stereo_combo_box.get_active()]
      self.mp3_encode_quality = self.mp3_encoding_quality_combo_box.get_active_text()
      if self.mp3_bitrate_widget == "standard":
         self.mp3_bitrate = int(self.mp3_bitrate_combo_box.get_active_text())
      elif self.mp3_bitrate_widget == "custom":
         self.mp3_bitrate = int(self.mp3_bitrate_spin_adj.get_value())
      self.mp3_standard_bitrate = self.mp3_bitrate in self.mp3_standard_bitrates
      self.mp3_samplerate = self.stream_resample_frame.resample_rate
      self.mp3_resample_compatible = self.stream_resample_frame.mp3_compatible
      self.mp3_compatibility = "freeformat"
      if not self.mp3_resample_compatible:
         self.mp3_compatibility = "s-rate!"
      else:
         if self.mpeg_std_search(self.mp3_bitrate, self.mp3_samplerate, self.mp3_mpeg2_5_bitrates_samplerates):
            self.mp3_compatibility = "mpeg 2.5"
         if self.mpeg_std_search(self.mp3_bitrate, self.mp3_samplerate, self.mp3_mpeg2_bitrates_samplerates):
            self.mp3_compatibility = "mpeg 2"
         if self.mpeg_std_search(self.mp3_bitrate, self.mp3_samplerate, self.mp3_mpeg1_bitrates_samplerates):
            self.mp3_compatibility = "mpeg 1"
      self.mp3_compatibility_status.push(1, self.mp3_compatibility)
      self.mp3_freeformat = ("0", "1")[self.mp3_compatibility == "freeformat"]
      self.update_sensitives()
   def cb_oggtab(self, widget, data = None):
      ogg_bitrate = self.ogg_encoding_nominal_spin_adj.get_value()
      if self.ogg_min_checkbutton.get_active():
         ogg_min = self.ogg_encoding_relmin_spin_adj.get_value() + ogg_bitrate
         if ogg_min <= 0:
            ogg_min = -1
      else:
         ogg_min = -1
      if self.ogg_max_checkbutton.get_active():
         ogg_max = self.ogg_encoding_relmax_spin_adj.get_value() + ogg_bitrate
      else:
         ogg_max = -1
      self.send("sample_rate=%d\nbit_rate=%d\nbit_rate_min=%d\nbit_rate_max=%d\nstereo=%s\ncommand=test_ogg_values\n" % (self.stream_resample_frame.resample_rate, 
         	ogg_bitrate, ogg_min, ogg_max,
                ("mono","stereo")[self.ogg_encoding_stereo_checkbutton.get_active()]))
      self.ogg_settings_valid = self.receive() == "succeeded"
      self.update_sensitives()
   def mpeg_std_search(self, bitrate, samplerate, brsr):
      return bitrate in brsr[0] and samplerate in brsr[1]
   def cb_server_connect(self, widget):
      if widget.get_active():
         self.start_stop_encoder(ENCODER_START)
         self.send("\n".join((    "stream_source=" + str(self.numeric_id),
         			  "server_type=" + self.server_type_dropdown.get_active_text(),
      				  "host=" + self.host_entry.get_text().strip(),
                                  "port=" + str(self.port_adj.get_value()),
      				  "mount=" + self.mount_entry.get_text().strip(),
                                  "login=" + self.login_entry.get_text().strip(),
                                  "password=" + self.passwd_entry.get_text().strip(),
                                  "dj_name=" + self.dj_name_entry.get_text().strip(),
                                  "listen_url=" + self.listen_url_entry.get_text().strip(),
                                  "description=" + self.description_entry.get_text().strip(),
                                  "genre=" + self.genre_entry.get_text().strip(),
                                  "make_public=" + str(bool(self.make_public.get_active())),
                                  "command=server_connect\n")))
         if self.receive() == "failed":
            self.server_connect.set_active(False)
      else:
         self.send("command=server_disconnect\n")
         self.receive()
         self.start_stop_encoder(ENCODER_STOP)
   def cb_test_monitor(self, widget):
      if widget.get_active():
         self.start_stop_encoder(ENCODER_START)
         self.send("command=monitor_start\n")
      else:
         self.send("command=monitor_stop\n")
         self.start_stop_encoder(ENCODER_STOP)
   def cb_update_button(self, widget):
      self.start_encoder("encoder_update")
   def start_stop_encoder(self, command):		# provides for nested starts, stops of the encoder
      if command == ENCODER_START:
         self.encoder_on_count += 1
         if self.encoder_on_count == 1:
            self.start_encoder()
      else:
         self.encoder_on_count -= 1
         if self.encoder_on_count == 0:
            self.stop_encoder()
      self.update_sensitives()
   def start_encoder(self, command = "encoder_start"):
      if self.format_page == 0:
         self.encoder = "mp3"
         self.send("format=mp3\nencode_source=jack\nsample_rate=%d\nresample_quality=%s\nbit_rate=%d\nstereo=%s\nencode_quality=%s\nfreeformat_mp3=%s\ncommand=%s\n" %   (self.stream_resample_frame.resample_rate,
         				 self.stream_resample_frame.resample_quality,
                                         self.mp3_bitrate, 
                                         self.mp3_stereo_type,
                                         self.mp3_encode_quality,
                                         self.mp3_freeformat,
                                         command))
         if self.receive() == "succeeded":
            self.format_info_bar.push(1, "mp3   %dHz   %dkbps   %s" % (self.stream_resample_frame.resample_rate, self.mp3_bitrate, self.mp3_stereo_type))
         else:
            self.format_info_bar.push(1, "")
      elif self.format_page == 1:
         self.encoder = "ogg"
         ogg_bitrate = self.ogg_encoding_nominal_spin_adj.get_value()
         if self.ogg_min_checkbutton.get_active():
            ogg_min = self.ogg_encoding_relmin_spin_adj.get_value() + ogg_bitrate
            if ogg_min <= 0:
               ogg_min = -1
         else:
            ogg_min = -1
         if self.ogg_max_checkbutton.get_active():
            ogg_max = self.ogg_encoding_relmax_spin_adj.get_value() + ogg_bitrate
         else:
            ogg_max = -1
         ogg_channels = ("mono", "stereo")[self.ogg_encoding_stereo_checkbutton.get_active()]
         self.send("format=ogg\nencode_source=jack\nsample_rate=%d\nresample_quality=%s\nbit_rate=%d\nbit_rate_min=%d\nbit_rate_max=%d\nstereo=%s\ncommand=%s\n" % (self.stream_resample_frame.resample_rate, 
         				  self.stream_resample_frame.resample_quality,
                                          ogg_bitrate, ogg_min, ogg_max,
                                          ogg_channels, command))
         if self.receive() == "succeeded":
            self.format_info_bar.push(1, "Ogg   %dHz   %dkbps   %s" % (self.stream_resample_frame.resample_rate, ogg_bitrate, ogg_channels))
         else:
            self.format_info_bar.push(1, "")
      else:
         if self.file_dialog.get_filename().endswith(".mp3"):
            self.encoder = "mp3"
         else:
            self.encoder = "ogg"
      	 self.send("format=%s\nencode_source=file\nfilename=%s\noffset=%d\ncommand=%s\n" %   (self.encoder, self.file_dialog.get_filename(), self.file_offset_adj.get_value(), command))
         if self.receive() == "succeeded":
            self.format_info_bar.push(1, self.file_dialog.get_filename())
         else:
            self.format_info_bar.push(1, "")
   def stop_encoder(self):
      self.encoder = "off"
      self.send("command=encoder_stop\n")
      if self.receive() == "failed":
         print "stop_encoder: encoder was already stopped"
      self.format_info_bar.push(1, "")
   def __init__(self, scg, numeric_id, indicator_lookup):
      Tab.__init__(self, scg, numeric_id, indicator_lookup)
      self.show_indicator("clear")
      self.tab_type = "streamer"
      self.encoder = "off"			# can also be set to "mp3" or "ogg" depending on what is encoded
      self.encoder_on_count = 0			# when this counter hits zero the encoder is turned off
      self.format_page = 0			# the current format page
      Tab.set_spacing(self, 10)
      scrolled = gtk.ScrolledWindow()
      Tab.add(self, scrolled)
      scrolled.show()
      scrolled.set_size_request(-1, 162)
      scrolled.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
      scrolled.set_shadow_type(gtk.SHADOW_NONE)
      scrolled_vbox = gtk.VBox()
      scrolled_vbox.set_border_width(10)
      scrolled_vbox.set_spacing(10)
      scrolled.add_with_viewport(scrolled_vbox)
      scrolled_vbox.show()
      frame = CategoryFrame(connection_text)		# Connection Frame
      scrolled_vbox.pack_start(frame, False, False, 0)
      frame.show()
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_VERTICAL)
      self.server_type_dropdown = gtk.combo_box_new_text()
      self.server_type_dropdown.append_text("Shoutcast")
      self.server_type_dropdown.append_text("Icecast 2")
      self.server_type_dropdown.append_text("Icecast")
      self.server_type_dropdown.set_active(1)
      self.server_type_dropdown.connect("changed", self.cb_servertype)
      self.host_entry = gtk.Entry()
      self.host_entry.set_text("localhost")
      self.port_adj = gtk.Adjustment(8000, 0, 65535, 1, 1, 1)
      self.port_spinbox = gtk.SpinButton(self.port_adj, 0.4, 0)
      self.mount_entry = gtk.Entry()
      self.mount_entry.set_text("/listen")
      self.login_entry = gtk.Entry()
      self.login_entry.set_text("source")
      self.passwd_entry = gtk.Entry()
      self.passwd_entry.set_text("hackme")
      self.passwd_entry.set_visibility(False)
      connectionpanesizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      left_pane = self.label_item_layout( ((server_type_text, self.server_type_dropdown),
      				           (server_host_text, self.host_entry),
                                           (server_port_text, self.port_spinbox)), sizegroup)
      connectionpanesizegroup.add_widget(left_pane)
      right_pane = self.label_item_layout(((server_mount_text, self.mount_entry),
      				           (server_login_text, self.login_entry),
                                           (server_passwd_text, self.passwd_entry)), sizegroup)
      connectionpanesizegroup.add_widget(right_pane)
      hbox = gtk.HBox()
      hbox.set_border_width(10)
      hbox.set_spacing(15)
      hbox.add(left_pane)
      left_pane.show()
      divider = gtk.VSeparator()
      hbox.pack_start(divider, False, False, 0)
      divider.show()
      hbox.add(right_pane)
      right_pane.show()
      frame.add(hbox)
      hbox.show()
      frame = CategoryFrame(format_text)		# Format Frame
      scrolled_vbox.pack_start(frame, False, False, 0)
      frame.show()
      vbox = gtk.VBox()
      vbox.set_border_width(10)
      vbox.set_spacing(14)
      frame.add(vbox)
      vbox.show()
      hbox = gtk.HBox(True)
      hbox.set_spacing(16)
      vbox.add(hbox)
      hbox.show()
      self.stream_resample_frame = self.ResampleFrame(self, sizegroup)	# stream resample frame
      hbox.add(self.stream_resample_frame)
      self.stream_resample_frame.show()
      self.format_notebook = gtk.Notebook()				# [mp3 / ogg / file] chooser
      self.format_notebook.connect("switch-page", self.cb_format_notebook)
      hbox.add(self.format_notebook)
      self.format_notebook.show()
      self.mp3tab = self.make_notebook_tab(self.format_notebook, "mp3")		# mp3 tab
      self.standard_mp3_bitrate, self.custom_mp3_bitrate = self.make_radio(2)
      self.standard_mp3_bitrate.connect("clicked", self.cb_mp3tab, "standard")
      self.custom_mp3_bitrate.connect("clicked", self.cb_mp3tab, "custom")
      self.mp3_standard_bitrates = (320, 256, 224, 192, 160, 144, 128, 112, 96, 80, 64, 56, 48, 40, 32, 24, 16, 8)
      self.mp3_mpeg1_bitrates_samplerates = ((320, 256, 224, 192, 160, 128, 112, 96, 80, 64, 56, 48, 40, 32), (48000, 44100, 32000))
      self.mp3_mpeg2_bitrates_samplerates = ((160, 144, 128, 112, 96, 80, 64, 56, 48, 40, 32, 24, 16, 8), (24000, 22050, 16000))
      self.mp3_mpeg2_5_bitrates_samplerates = ((160, 144, 128, 112, 96, 80, 64, 56, 48, 40, 32, 24, 16, 8), (12000, 11025, 8000))
      self.mp3_bitrate_combo_box = self.make_combo_box(map(str, self.mp3_standard_bitrates))
      self.mp3_bitrate_combo_box.set_active(6)
      self.mp3_bitrate_combo_box.connect("changed", self.cb_mp3tab)
      self.mp3_bitrate_spin_adj = gtk.Adjustment(128, 8, 640, 10, 100, 0)
      self.mp3_bitrate_spin_control = gtk.SpinButton(self.mp3_bitrate_spin_adj)
      self.mp3_bitrate_spin_control.connect("value-changed", self.cb_mp3tab)
      encoding_quality_label = gtk.Label(encoding_quality_text)
      self.mp3_encoding_quality_combo_box = self.make_combo_box(("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"))
      self.mp3_encoding_quality_combo_box.set_active(2)
      self.mp3_encoding_quality_combo_box.connect("changed", self.cb_mp3tab)
      self.mp3_stereo_combo_box = self.make_combo_box(("Stereo", "Mono", "Joint Stereo"))
      self.mp3_stereo_combo_box.set_active(2)
      self.mp3_stereo_combo_box.connect("changed", self.cb_mp3tab)
      self.mp3_compatibility_status = gtk.Statusbar()
      self.mp3_compatibility_status.set_has_resize_grip(False)
      self.mp3_dummy_object = gtk.Button()
      self.mp3_dummy_object.connect("clicked", self.cb_mp3tab)
      self.mp3_bitrate = 128
      self.mp3_bitrate_widget = "standard"
      mp3_pane = self.item_item_layout(((self.standard_mp3_bitrate, self.mp3_bitrate_combo_box),
      					(self.custom_mp3_bitrate, self.mp3_bitrate_spin_control),
                                        (encoding_quality_label, self.mp3_encoding_quality_combo_box),
                                        (self.mp3_stereo_combo_box, self.mp3_compatibility_status)), sizegroup)
      mp3_pane.set_border_width(10)
      self.mp3tab.add(mp3_pane)
      mp3_pane.show()
      if not lameenabled:
         self.mp3tab.hide()

      self.oggtab = self.make_notebook_tab(self.format_notebook, "Ogg")		# Ogg tab
      nominal_label = gtk.Label(ogg_bitrate_nominal_text)
      self.ogg_encoding_nominal_spin_adj = gtk.Adjustment(128, 45, 500, 1, 10, 0)
      self.ogg_encoding_nominal_spin_control = gtk.SpinButton(self.ogg_encoding_nominal_spin_adj)
      self.ogg_encoding_nominal_spin_control.connect("value-changed", self.cb_oggtab)
      self.ogg_min_checkbutton = gtk.CheckButton(ogg_bitrate_neg_rel_text)
      self.ogg_min_checkbutton.connect("clicked", self.cb_oggtab)
      self.ogg_encoding_relmin_spin_adj = gtk.Adjustment(0, -400, 0, 1, 10, 0)
      self.ogg_encoding_relmin_spin_control = gtk.SpinButton(self.ogg_encoding_relmin_spin_adj)
      self.ogg_encoding_relmin_spin_control.connect("value-changed", self.cb_oggtab)
      self.ogg_max_checkbutton = gtk.CheckButton(ogg_bitrate_pos_rel_text)
      self.ogg_max_checkbutton.connect("clicked", self.cb_oggtab)
      self.ogg_encoding_relmax_spin_adj = gtk.Adjustment(0, 0, 400, 1, 10, 0)
      self.ogg_encoding_relmax_spin_control = gtk.SpinButton(self.ogg_encoding_relmax_spin_adj)
      self.ogg_encoding_relmax_spin_control.connect("value-changed", self.cb_oggtab)
      self.ogg_encoding_stereo_checkbutton = gtk.CheckButton(stereo_text)
      self.ogg_encoding_stereo_checkbutton.set_active(True)
      self.ogg_encoding_stereo_checkbutton.connect("clicked", self.cb_oggtab)
      ogg_pane = self.item_item_layout2(((nominal_label, self.ogg_encoding_nominal_spin_control),
      					(self.ogg_min_checkbutton, self.ogg_encoding_relmin_spin_control),
                                        (self.ogg_max_checkbutton, self.ogg_encoding_relmax_spin_control),
                                        (self.ogg_encoding_stereo_checkbutton, None)), sizegroup)
      ogg_pane.set_border_width(10)
      self.oggtab.add(ogg_pane)
      ogg_pane.show()
      self.ogg_settings_valid = False
      self.ogg_dummy_object = gtk.Button()
      self.ogg_dummy_object.connect("clicked", self.cb_oggtab)
      
      self.filetab = self.make_notebook_tab(self.format_notebook, "File")	# File tab
      filefilter = gtk.FileFilter()
      filefilter.add_pattern("*.[mM]p3")
      filefilter.add_pattern("*.MP3")
      filefilter.add_pattern("*.[oO]gg")
      filefilter.add_pattern("*.OGG")
      self.file_dialog = gtk.FileChooserDialog("", None, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OPEN, gtk.RESPONSE_ACCEPT))
      self.file_dialog.set_filter(filefilter)
      fcb = gtk.FileChooserButton(self.file_dialog)
      self.file_dialog.set_title(stream_file_chooser_title_text)
      self.file_dialog.set_current_folder(os.environ["HOME"])
      self.file_dialog.connect("response", self.cb_file_dialog_response)
      self.file_offset_checkbutton = gtk.CheckButton("Start offset (s)")
      self.file_offset_adj = gtk.Adjustment(0, 0, 30000, 1, 10, 0)
      self.file_offset_spinbutton = gtk.SpinButton(self.file_offset_adj)
      self.textbuffer = gtk.TextBuffer()
      self.textbuffer.set_text("0:00:00 / 0:00:00\nFinish: 00:00:00\n0Kb/s 0Hz")
      self.file_textview = gtk.TextView(self.textbuffer)
      self.file_textview.set_cursor_visible(False)
      self.file_textview.set_editable(False)
      frame = gtk.Frame()
      frame.set_shadow_type(gtk.SHADOW_IN)
      frame.add(self.file_textview)
      self.file_textview.show()
      file_pane = self.item_item_layout(((None, fcb), (self.file_offset_checkbutton, self.file_offset_spinbutton)), sizegroup)
      file_pane.set_border_width(10)
      file_pane.add(frame)
      frame.show()
      self.filetab.add(file_pane)
      file_pane.show()
      self.filetab.hide()		# TODO: add this feature
      
      format_control_bar = gtk.HBox()				# Button box in Format frame
      format_control_sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      format_control_bar.set_spacing(10)
      vbox.add(format_control_bar)
      format_control_bar.show()
      self.test_monitor = gtk.ToggleButton(test_monitor_text)
      self.test_monitor.connect("toggled", self.cb_test_monitor)
      format_control_sizegroup.add_widget(self.test_monitor)
      format_control_bar.pack_start(self.test_monitor, False, False, 0)
      #self.test_monitor.show()
      self.format_info_bar = gtk.Statusbar()
      self.format_info_bar.set_has_resize_grip(False)
      format_control_bar.pack_start(self.format_info_bar, True, True, 0)
      self.format_info_bar.show()
      self.update_button = gtk.Button(update_text)
      self.update_button.connect("clicked", self.cb_update_button)
      format_control_sizegroup.add_widget(self.update_button)
      self.update_button.set_sensitive(False)
      format_control_bar.pack_start(self.update_button, False, False, 0)
      self.update_button.show()
      frame = ModuleFrame(stream_info_text)		# frame containing stream information (optional)
      scrolled_vbox.pack_start(frame, False, False, 0)
      frame.show()
      self.dj_name_entry = gtk.Entry()
      self.listen_url_entry = gtk.Entry()
      self.description_entry = gtk.Entry()
      genre_entry_box = gtk.HBox()
      genre_entry_box.set_spacing(12)
      self.genre_entry = gtk.Entry()
      genre_entry_box.pack_start(self.genre_entry, True, True, 0)
      self.genre_entry.show()
      self.make_public = gtk.CheckButton(make_public_text)
      genre_entry_box.pack_start(self.make_public, False, False, 0)
      self.make_public.show()
      info_sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_VERTICAL)
      stream_details_pane = self.label_item_layout(((dj_name_text, self.dj_name_entry),
      					      (listen_url_text, self.listen_url_entry),
                                              (description_text, self.description_entry),
                                              (genre_text, genre_entry_box)), info_sizegroup)
      stream_details_pane.set_border_width(10)
      frame.add(stream_details_pane)
      stream_details_pane.show()
      hbox = gtk.HBox()					# box containing connect button and timers
      hbox.set_spacing(30)
      self.server_connect = gtk.ToggleButton(server_connect_text)
      self.server_connect.connect("toggled", self.cb_server_connect)
      hbox.pack_start(self.server_connect, True, True, 0)
      self.server_connect.show()
      timerbox = gtk.HBox()
      timerbox.set_spacing(20)
      self.start_timer = TimeEntry(start_streaming_time_text)
      timerbox.pack_start(self.start_timer, False, False, 0)
      self.start_timer.show()
      self.stop_timer = TimeEntry(stop_streaming_time_text)
      timerbox.pack_start(self.stop_timer, False, False, 0)
      self.stop_timer.show()
      hbox.pack_end(timerbox, False, False, 0)
      timerbox.show()
      Tab.pack_start(self, hbox, False, False, 0)
      hbox.show()
      hbox = gtk.HBox()					# box containing auto action widgets
      hbox.set_spacing(10)
      label = gtk.Label(upon_connection_text)
      hbox.pack_start(label, False, False, 0)
      label.show()
      self.start_player_action = AutoAction(start_player_text, (
      		("1", self.source_client_gui.parent.player_left.play.clicked),
                ("2", self.source_client_gui.parent.player_right.play.clicked)))
      hbox.pack_start(self.start_player_action, False, False, 0)
      self.start_player_action.show()
      vseparator = gtk.VSeparator()
      hbox.pack_start(vseparator, True, False, 0)
      vseparator.show()
      self.start_recorder_action = AutoAction(start_recorder_text, (
         ("1", self.source_client_gui.recordtabframe.tabs[0].record_buttons.record_button.activate),
         ("2", self.source_client_gui.recordtabframe.tabs[1].record_buttons.record_button.activate)))
      hbox.pack_end(self.start_recorder_action, False, False, 0)
      self.start_recorder_action.show()
      Tab.pack_start(self, hbox, False, False, 0)
      hbox.show()
      self.stream_resample_frame.resample_no_resample.emit("clicked")	# bogus signal to update mp3 pane
      self.objects = {  "server_type" : (self.server_type_dropdown, "active"),
      			"hostname" : (self.host_entry, "text"),
                        "portnum" : (self.port_adj, "value"),
                        "mountpoint" : (self.mount_entry, "text"),
                        "source_login" : (self.login_entry, "text"),
                        "source_password" : (self.passwd_entry, "password"),
                        "rs_use_jack" : (self.stream_resample_frame.resample_no_resample, "active"),
                        "rs_use_std" : (self.stream_resample_frame.resample_standard, "active"),
                        "rs_use_custom_rate" : (self.stream_resample_frame.resample_custom, "active"),
                        "rs_std_rate" : (self.stream_resample_frame.resample_rate_combo_box, "active"),
                        "rs_custom_rate" : (self.stream_resample_frame.resample_rate_spin_adj, "value"),
                        "rs_quality" : (self.stream_resample_frame.resample_quality_combo_box, "active"),
                        "source_type" : (self.format_notebook, "notebookpage"),
                        "std_mp3bitrate" : (self.standard_mp3_bitrate, "active"),
                        "custom_mp3_bitrate" : (self.custom_mp3_bitrate, "active"),
                        "mp3_bitrate_combo" : (self.mp3_bitrate_combo_box, "active"),
                        "mp3_bitrate_spin" : (self.mp3_bitrate_spin_adj, "value"),
                        "mp3_quality" : (self.mp3_encoding_quality_combo_box, "active"),
                        "mp3_stereo" : (self.mp3_stereo_combo_box, "active"),
                        "ogg_bitrate" : (self.ogg_encoding_nominal_spin_adj, "value"),
                        "ogg_use_min" : (self.ogg_min_checkbutton, "active"),
                        "ogg_min_bitrate" : (self.ogg_encoding_relmin_spin_adj, "value"),
                        "ogg_use_max" : (self.ogg_max_checkbutton, "active"),
                        "ogg_max_bitrate" : (self.ogg_encoding_relmax_spin_adj, "value"),
                        "ogg_stereo" : (self.ogg_encoding_stereo_checkbutton, "active"),
                        "file_source" : (self.file_dialog, "filename"),
                        "file_use_offset" : (self.file_offset_checkbutton, "active"),
                        "file_offset" : (self.file_offset_adj, "value"),
                        "dj_name" : (self.dj_name_entry, "text"),
                        "listen_url" : (self.listen_url_entry, "text"),
                        "description" : (self.description_entry, "text"),
                        "genre" : (self.genre_entry, "text"),
                        "make_public" : (self.make_public, "active"),
                        "timer_start_active" : (self.start_timer.check, "active"),
                        "timer_start_time" : (self.start_timer.entry, "text"),
                        "timer_stop_active" : (self.stop_timer.check, "active"),
                        "timer_stop_time" : (self.stop_timer.entry, "text"),
                        "action_play_active" : (self.start_player_action, "active"),
                        "action_play_which" : (self.start_player_action, "radioindex"),
                        "action_record_active" : (self.start_recorder_action, "active"),
                        "action_record_which" : (self.start_recorder_action, "radioindex") }

class RecordTab(Tab):
   class RecordButtons(CategoryFrame):
      def cb_recbuttons(self, widget, userdata):
         changed_state = False
         if userdata == "rec":
            if widget.get_active():
               if not self.recording:
                  self.parentobject.source_dest.streamtab.start_stop_encoder(ENCODER_START)
                  self.parentobject.send("record_source=%d\nrecord_folder=%s\ncommand=recorder_start\n" % (
                  	 		self.parentobject.source_dest.streamtab.numeric_id,
                         		self.parentobject.source_dest.file_dialog.get_current_folder()))
                  self.parentobject.source_dest.file_dialog.response(gtk.RESPONSE_CLOSE)
                  self.parentobject.source_dest.set_sensitive(False)
                  self.recording = True
                  if self.parentobject.receive() == "failed":
                     self.stop_button.clicked()
            else:
               if self.stop_pressed:
                  self.stop_pressed = False
                  if self.recording == True:
                     self.recording = False
                     self.parentobject.send("command=recorder_stop\n")
                     self.parentobject.receive()
                  self.parentobject.source_dest.streamtab.start_stop_encoder(ENCODER_STOP)
                  self.parentobject.source_dest.set_sensitive(True)
                  if self.pause_button.get_active():
                     self.pause_button.set_active(False)
               else:
                  widget.set_active(True)
         elif userdata == "stop":
            if self.recording:
               self.stop_pressed = True
               self.record_button.set_active(False)
            else:
               self.pause_button.set_active(False)
         elif userdata == "pause":
            if self.pause_button.get_active():
               self.parentobject.send("command=recorder_pause\n")
            else:
               self.parentobject.send("command=recorder_unpause\n")
            self.parentobject.receive()
         elif userdata == "pause_yellow":
            pass
            #self.parentobject.send("auto_pause_button=%d\ncommand=recorder_pause\n" % self.autopause_button.get_active())
      def path2image(self, pathname):
         pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pathname, 14, 14)
         image = gtk.Image()
         image.set_from_pixbuf(pixbuf)
         image.show()
         return image
      def __init__(self, parent):
         CategoryFrame.__init__(self)
         self.parentobject = parent
         self.stop_pressed = False
         self.recording = False
         hbox = gtk.HBox()
         hbox.set_border_width(3)
         hbox.set_spacing(6)
         self.stop_button = gtk.Button()
         self.record_button = gtk.ToggleButton()
         self.autopause_button = gtk.ToggleButton()
         self.pause_button = gtk.ToggleButton()
         for button, gname, signal in ((self.stop_button, "stop", "clicked"), (self.record_button, "rec", "toggled"), (self.autopause_button, "pause_yellow", "toggled"), (self.pause_button, "pause", "toggled")):
            button.set_size_request(30, -1)
            button.add(self.path2image("".join((pkgdatadir, gname, gfext))))
            button.connect(signal, self.cb_recbuttons, gname)
            hbox.pack_start(button, False, False, 0)
            button.show()
         self.autopause_button.hide()	# may remove this feature
         self.add(hbox)
         hbox.show()
   class TimeIndicator(gtk.Entry):
      def set_value(self, seconds):
         if self.oldvalue != seconds:
            self.oldvalue = seconds
            minutes, seconds = divmod(seconds, 60)
            hours, minutes = divmod(minutes, 60)
            days, hours = divmod(hours, 24)
            if days > 10:			# shut off the recorder after 10 days continuous recording
               self.parentobject.record_buttons.stop_button.clicked()
            elif days >= 1:
               self.set_text("%dd:%02d:%02d" % (days, hours, minutes))
            else:
               self.set_text("%02d:%02d:%02d" % (hours, minutes, seconds))
      def __init__(self, parent):
         self.parentobject = parent
         gtk.Entry.__init__(self)
         self.set_width_chars(7)
         self.set_sensitive(False)
         self.oldvalue = -1
         self.set_value(0)
   class SourceDest(CategoryFrame):
      def set_sensitive(self, boolean):
         self.source_combo.set_sensitive(boolean)
         self.file_chooser_button.set_sensitive(boolean)
      def cb_source_combo(self, widget):
         self.streamtab = self.streamtabs[widget.get_active()]
         self.parentobject.record_buttons.record_button.set_sensitive(self.streamtab.server_connect.flags() & gtk.SENSITIVE)
      def populate_stream_selector(self, text, tabs):
         self.streamtabs = tabs
         for index in range(len(tabs)):
            self.source_combo.append_text(" ".join((text, str(index + 1))))
         self.source_combo.connect("changed", self.cb_source_combo)
         self.source_combo.set_active(0)
      def __init__(self, parent):
         self.parentobject = parent
         CategoryFrame.__init__(self)
         hbox = gtk.HBox()
         hbox.set_spacing(6)
         self.source_combo = gtk.combo_box_new_text()
         hbox.pack_start(self.source_combo, False, False, 0)
         self.source_combo.show()
         arrow = gtk.Arrow(gtk.ARROW_RIGHT, gtk.SHADOW_IN)
         hbox.pack_start(arrow, False, False, 0)
         arrow.show()
         self.file_dialog = gtk.FileChooserDialog("", None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
         self.file_dialog.set_do_overwrite_confirmation(True)
         self.file_chooser_button = gtk.FileChooserButton(self.file_dialog)
         self.file_dialog.set_title(save_folder_dialog_title_text)
         self.file_dialog.set_current_folder(os.environ["HOME"])
         hbox.pack_start(self.file_chooser_button, True, True, 0)
         self.file_chooser_button.show()
         self.add(hbox)
         hbox.show()
   def send(self, string_to_send):
      Tab.send(self, "dev_type=recorder\n" + string_to_send)
   def receive(self):
      return Tab.receive(self)
   def __init__(self, scg, numeric_id, indicator_lookup):
      Tab.__init__(self, scg, numeric_id, indicator_lookup)
      self.show_indicator("clear")
      self.tab_type = "recorder"
      hbox = gtk.HBox()
      hbox.set_spacing(10)
      self.pack_start(hbox, False, False, 0)
      hbox.show()
      self.source_dest = self.SourceDest(self)
      hbox.pack_start(self.source_dest, True, True, 0)
      self.source_dest.show()
      self.time_indicator = self.TimeIndicator(self)
      hbox.pack_start(self.time_indicator, False, False, 0)
      self.time_indicator.show()
      self.record_buttons = self.RecordButtons(self)
      hbox.pack_start(self.record_buttons, False, False, 0)
      self.record_buttons.show()
      self.objects = {  "recording_source": (self.source_dest.source_combo, "active"),
      			"recording_directory": (self.source_dest.file_dialog, "directory") }

class TabFrame(ModuleFrame):
   def __init__(self, scg, frametext, q_tabs, tabtype, path, indicatorlist, file_extension):
      ModuleFrame.__init__(self, frametext)
      self.notebook = gtk.Notebook()
      self.notebook.set_border_width(8)
      self.add(self.notebook)
      self.notebook.show()
      self.tabs = []
      self.indicator_image_qty = len(indicatorlist)
      for index in range(q_tabs):
         labelbox = gtk.HBox()
         labelbox.set_spacing(3)
         numlabel = gtk.Label(str(index + 1))
         labelbox.add(numlabel)
         numlabel.show()
         indicator_lookup = {}
         for colour, indicator in indicatorlist:
            image = gtk.Image()
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size("".join((path, indicator, file_extension)), 16, 16)
            image.set_from_pixbuf(pixbuf)
            labelbox.add(image)
            indicator_lookup[colour] = image
         self.tabs.append(tabtype(scg, index, indicator_lookup))
         self.notebook.append_page(self.tabs[-1], labelbox)
         labelbox.show()

class sourceclientgui:
   server_errmsg = "idjc: the server module appears to have crashed -- possible segfault"
   unexpected_reply = "unexpected reply from idjcsourceclient"
   def monitor(self):
      self.led_alternate = not self.led_alternate
      streaming = recording = False
      gtk.gdk.threads_enter()
      # update the recorder LED indicators 
      for rectab in self.recordtabframe.tabs:
         self.send("dev_type=recorder\ntab_id=%d\ncommand=get_report\n" % rectab.numeric_id)
         while 1:
            reply = self.receive()
            if reply == "succeeded" or reply == "failed":
               break
            if reply.startswith("recorder%dreport=" % rectab.numeric_id):
               recorder_state, recorded_seconds = reply.split("=")[1].split(":")
               rectab.show_indicator(("clear", "red", "amber", "clear")[int(recorder_state)])
               rectab.time_indicator.set_value(int(recorded_seconds))
               if recorder_state != "0":
                  recording = True
      for streamtab in self.streamtabframe.tabs:
         self.send("dev_type=streamer\ntab_id=%d\ncommand=get_report\n" % streamtab.numeric_id)
         reply = self.receive()
         if reply != "failed":
            self.receive()
            if reply.startswith("streamer%dreport=" % streamtab.numeric_id):
               streamer_state, stream_sendbuffer_pc, brand_new = reply.split("=")[1].split(":")
               streamtab.show_indicator(("clear", "amber", "green", "clear")[int(streamer_state)])
               if (streamer_state == "2" and int(stream_sendbuffer_pc) >= 100 and self.led_alternate):
                  streamtab.show_indicator("amber")
               if brand_new == "1":
                  # connection has just been made, do user requested actions at this time
                  streamtab.start_recorder_action.activate()
                  streamtab.start_player_action.activate()
               if streamer_state != "0":
                  streaming = True
               elif streamtab.server_connect.get_active():
                  streamtab.server_connect.set_active(False)
                  self.disconnected_dialog.present()
            else:
               print "sourceclientgui.monitor: bad reply for streamer data:", reply
         else:
            print "sourceclientgui.monitor: failed to get a report from the streamer"
	 # the connection start/stop timers are processed here
         if streamtab.start_timer.get_active():
            diff = time.localtime(time.time() - streamtab.start_timer.get_seconds_past_midnight())
            # check hours, minutes, seconds for midnightness
            if not (diff[3] or diff[4] or diff[5]):
               streamtab.server_connect.set_active(True)
         if streamtab.stop_timer.get_active():
            diff = time.localtime(int(time.time()) - streamtab.stop_timer.get_seconds_past_midnight())
            if not (diff[3] or diff[4] or diff[5]):
               streamtab.server_connect.set_active(False)
               self.autoshutdown_dialog.present()
         self.is_streaming = streaming
         self.is_recording = recording
      gtk.gdk.threads_leave()
      return True
   def cleanup(self):
      # switch off all streamers and recorders
      for rectab in self.recordtabframe.tabs:
         rectab.record_buttons.stop_button.clicked()
      for streamtab in self.streamtabframe.tabs:
         streamtab.server_connect.set_active(False)
         streamtab.test_monitor.set_active(False)
         if streamtab.encoder_on_count:
            print "sourceclientgui.cleanup: encoder %d still running!!!" % streamtab.numeric_id
      gobject.source_remove(self.monitor_source_id)
   def app_exit(self):
      if self.parent.session_loaded:
         self.parent.destroy()
      else:
         self.parent.destroy_hard()
   def receive(self):
      if not self.comms_reply_pending:
         print "sourceclientgui.receive: nothing to receive"
         time.sleep(0.5)
         return ""
      while 1:
         try:
            reply = self.comms_rply.readline()
         except:
            return ""
         if reply.startswith("idjcsc: "):
            reply = reply[8:-1]
            if reply == "succeeded" or reply == "failed":
               self.comms_reply_pending = False
            return reply
         else:
            print self.unexpected_reply, reply
            time.sleep(0.5)
         if reply == "" or reply == "Segmentation Fault\n":
            return ""
   def send(self, string_to_send):
      while self.comms_reply_pending:	# dump unused replies from previous send
         self.receive()
      if not "tab_id=" in string_to_send:
         string_to_send = "tab_id=-1\n" + string_to_send
      try:
         self.comms_cmd.write(string_to_send + "end\n")
         self.comms_cmd.flush()
         self.comms_reply_pending = True
      except (ValueError, IOError):
         print "sourceclientgui.send: send failed - idjcsourceclient crashed"
         self.source_client_crash_count += 1
         self.source_client_close()
         print self.server_errmsg
         time.sleep(1.0)
         if self.source_client_crash_count == 3:
            print "source client module has crashed too many times - exiting\n"
            self.app_exit()
         self.source_client_open()
         self.source_client_crash_count -= 1
   def new_metadata(self, artist, title, artist_title):
      if self.parent.prefs_window.mp3_utf8.get_active():
         artist_title_mp3 = artist_title.encode("utf-8")
      else:
         artist_title_mp3 = artist_title.encode("iso8859-1")
      artist_title = artist_title.encode("iso8859-1").strip()
      self.send("artist=%s\ntitle=%s\nartist_title=%s\nartist_title_mp3=%s\ncommand=new_metadata\n" % (artist.strip(), title.strip(), artist_title.strip(), artist_title_mp3.strip()))
      if self.receive() == "succeeded":
         print "updated metadata successfully" 
   def source_client_open(self):
      self.comms_cmd, self.comms_rply = os.popen2([libexecdir + "idjcsourceclient"], 4096)
      self.comms_reply_pending = True
      reply = self.receive()
      if reply != "succeeded":
         print self.server_errmsg
         self.app_exit()
      else:
         self.send("encoders=%d\nstreamers=%d\nrecorders=%d\ncommand=threads_init\n" % (num_encoders, num_streamers, num_recorders))
         if self.receive() != "succeeded":
            print self.unexpected_reply
            print "failed to initialise threads\n"
            self.app_exit()
         self.send("command=jack_samplerate_request\n")
         reply = self.receive()
         if reply != "failed" and self.receive() == "succeeded":
            sample_rate_string = reply
         else:
            print self.unexpected_reply
            print "failed to obtain the sample rate"
            self.app_exit()
         if not sample_rate_string.startswith("sample_rate="):
            print self.unexpected_reply
            print "sample rate reply contains the following:", sample_rate_string
            self.app_exit()
         else:
            print "threads initialised"
            self.jack_sample_rate = int(sample_rate_string[12:])
            print "jack sample rate is", self.jack_sample_rate
            try:
               for streamtab in self.streamtabframe.tabs:
                  streamtab.stream_resample_frame.jack_sample_rate = self.jack_sample_rate
                  streamtab.stream_resample_frame.resample_dummy_object.clicked()
                  # update the stream tabs with the current jack sample rate
            except (NameError, AttributeError):
               pass	# stream tabs will not have been created yet and no further action is needed
   def source_client_close(self):
      try:
         self.comms_cmd
      except:
         pass
      else:
         self.comms_cmd.close()
   def cb_delete_event(self, widget, event, data = None):
      self.window.hide()
      return True
   def save_session_settings(self):
      try:				# check the following are initilised before proceeding
         tabframes = (self, self.streamtabframe, self.recordtabframe)
      except AttributeError:
         return				# cancelled save
      try:
         file = open(self.parent.idjc + "s_data", "w")
      except:
         print "error attempting to write file: serverdata"
      else:
         for tabframe in tabframes:
            for tab in tabframe.tabs:
               file.write("".join(("[", tab.tab_type, " ", str(tab.numeric_id), "]\n")))
               for lvalue, (widget, method) in tab.objects.iteritems():
                  if method == "active":
                     rvalue = str(int(widget.get_active()))
                  elif method == "text":
                     rvalue = widget.get_text()
                  elif method == "value":
                     rvalue = str(widget.get_value())
                  elif method == "notebookpage":
                     rvalue = str(widget.get_current_page())
                  elif method == "password":
                     rvalue = widget.get_text()
                  elif method == "radioindex":
                     rvalue = str(widget.get_radio_index())
                  elif method == "directory":
                     rvalue = widget.get_filename() or ""
                  elif method == "filename":
                     rvalue = widget.get_filename() or ""
                  else:
                     print "unsupported", lvalue, widget, method
                     continue
                  if method != "password" or self.parent.prefs_window.keeppass.get_active():
                     file.write("".join((lvalue, "=", rvalue, "\n")))
               file.write("\n")
         file.close()
   def load_previous_session(self):
      try:
         file = open(self.parent.idjc + "s_data", "r")
      except:
         print "failed to open serverdata file"
      else:
         tabframe = None
         while 1:
            line = file.readline()
            if line == "":
               break
            else:
               line = line[:-1]		# strip off the newline character
               if line == "":
                  continue
            if line.startswith("[") and line.endswith("]"):
               try:
                  name, numeric_id = line[1:-1].split(" ")
               except:
                  print "malformed line:", line, "in serverdata file"
                  tabframe = None
               else:
                  if name == "server_window":
                     tabframe = self
                  elif name == "streamer":
                     tabframe = self.streamtabframe
                  elif name == "recorder":
                     tabframe = self.recordtabframe
                  else:
                     print "unsupported element:", line, "in serverdata file"
                     tabframe = None
                  if tabframe is not None:
                     try:
                        tab = tabframe.tabs[int(numeric_id)]
                     except:
                        print "unsupported tab number:", line, "in serverdata file"
                        tabframe = None
            else:
               if tabframe is not None:
                  try:
                     lvalue, rvalue = line.split("=")
                  except:
                     print "not a valid key, value pair:", line, "in serverdata file"
                  else:
		     if not lvalue:
                        print "key value is missing:", line, "in serverdata file"        
                     else:
                        try:
                           (widget, method) = tab.objects[lvalue]
                        except KeyError:
                           print "key value not recognised:", line, "in serverdata file"
                        else:
                           try:
                              int_rvalue = int(rvalue)
                           except:
                              int_rvalue = None
                           try:
                              float_rvalue = float(rvalue)
                           except:
                              float_rvalue = None
                           if method == "active":
                              if int_rvalue is not None:
                                 widget.set_active(int_rvalue)
                           elif method == "value":
                              if float_rvalue is not None:
                                 widget.set_value(float_rvalue)
                           elif method == "notebookpage":
                              if int_rvalue is not None:
                                 widget.set_current_page(int_rvalue)
                           elif method == "radioindex":
                              if int_rvalue is not None:
                                 widget.set_radio_index(int_rvalue)
                           elif method == "text":
                              widget.set_text(rvalue)
                           elif method == "password":
                              widget.set_text(rvalue)
                           elif method == "directory":
                              if rvalue:
                                 widget.set_current_folder(rvalue)
                           elif method == "filename":
                              if rvalue:
                                 rvalue = widget.set_filename(rvalue)
                           else:
                              print "method", method, "is unsupported at this time hence widget pertaining to", lvalue, "will not be set"
   def cb_configure_event(self, widget, event):
      self.win_x.set_value(event.width)
      self.win_y.set_value(event.height)
   def cb_after_realize(self, widget):
      widget.resize(int(self.win_x), int(self.win_y))
   def __init__(self, parent):
      self.parent = parent
      parent.server_window = self
      self.win_x = int_object(100)
      self.win_y = int_object(100)
      self.source_client_crash_count = 0
      self.source_client_open()
      self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
      self.parent.window_group.add_window(self.window)
      self.window.set_title(server_window_text)
      self.window.set_destroy_with_parent(True)
      self.window.set_border_width(11)
      self.window.set_resizable(True)
      self.window.set_icon_from_file(pkgdatadir + "icon" + gfext)
      self.window.connect("configure_event", self.cb_configure_event)
      self.window.connect_after("realize", self.cb_after_realize)
      self.window.connect("delete_event", self.cb_delete_event)
      vbox = gtk.VBox()
      vbox.set_spacing(10)
      self.window.add(vbox)
      self.recordtabframe = TabFrame(self, record_text, num_recorders, RecordTab, pkgdatadir, (
      									("clear", "led_unlit_clear_border_64x64"),
      									("amber", "led_lit_amber_black_border_64x64"),
                                                                        ("red", "led_lit_red_black_border_64x64")),
                                                                        gfext)
      self.streamtabframe = TabFrame(self, stream_text, num_streamers, StreamTab, pkgdatadir, (
      									("clear", "led_unlit_clear_border_64x64"),
      									("amber", "led_lit_amber_black_border_64x64"),
                                                                        ("green", "led_lit_green_black_border_64x64")),
                                                                        gfext)
      self.streamtabframe.set_sensitive(True)
      vbox.pack_start(self.streamtabframe, True, True, 0)
      self.streamtabframe.show()
      metabar = MetadataBar(self, 6, "%s")
      vbox.pack_start(metabar, False, False, 0)
      metabar.show()
      for rectab in self.recordtabframe.tabs:
         rectab.source_dest.populate_stream_selector(stream_text, self.streamtabframe.tabs)
      vbox.pack_start(self.recordtabframe, False, False, 0)
      self.recordtabframe.show()
      vbox.show()
      self.tabs = (self, )			#
      self.numeric_id = 0			# pretend to be a tabframe and its tab for save/load purposes
      self.tab_type = "server_window"		#
      self.objects = {  "width" : (self.win_x, "value"),
      			"height": (self.win_y, "value") }
      self.load_previous_session()
      self.is_streaming = False
      self.is_recording = False
      self.led_alternate = False
      
      self.dialog_group = dialog_group()
      self.disconnected_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, unexpected_text)
      #self.timed_out_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, timed_out_text)
      self.autoshutdown_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, disconnected_text, autoshutdown_text)
      #self.oneminwarn = autodisconnection_notification_dialog(self.dialog_group, self.parent.window_group, disconnection_text, discon_warn_text, None, self.cancel_autoshutdown)
      #self.autoreconnect_dialog = error_notification_dialog(self.dialog_group, self.parent.window_group, reconnected_text, reconnected_additional_text)
      
      self.monitor_source_id = gobject.timeout_add(250, self.monitor)
